"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminLeaveClosedGroupDialog = void 0;
const react_1 = __importStar(require("react"));
const Text_1 = require("../basic/Text");
const conversations_1 = require("../../bchat/conversations");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const BchatButton_1 = require("../basic/BchatButton");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const BchatIcon_1 = require("../icon/BchatIcon");
const styled_components_1 = __importDefault(require("styled-components"));
const AdminLeaveClosedGroupDialog = (props) => {
    const titleText = `${window.i18n('leaveGroup')} ?`;
    const warningAsAdmin = `${window.i18n('leaveGroupConfirmationAdmin')}`;
    const okText = window.i18n('leaveAndRemoveForEveryone');
    const cancelText = window.i18n('cancel');
    const [_isLoading, setIsLoading] = (0, react_1.useState)(false);
    const onClickOK = async () => {
        setIsLoading(true);
        await (0, conversations_1.getConversationController)()
            .get(props.conversationId)
            .leaveClosedGroup();
        setIsLoading(false);
        closeDialog();
    };
    const closeDialog = () => {
        window.inboxStore?.dispatch((0, modalDialog_1.adminLeaveClosedGroup)(null));
    };
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: titleText, onClose: closeDialog, okButton: {
            text: okText,
            onClickOkHandler: () => onClickOK(),
            color: BchatButton_1.BchatButtonColor.Danger,
            disabled: false,
        }, cancelButton: {
            text: cancelText,
            status: true,
            color: BchatButton_1.BchatButtonColor.Secondary,
            onClickCancelHandler: () => closeDialog(),
        }, iconShow: true, customIcon: react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'leaveGroup', iconSize: 24, iconColor: '#FF3E3E' }) },
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement(ContentWrapper, null, warningAsAdmin),
        react_1.default.createElement(Text_1.SpacerLG, null)));
};
exports.AdminLeaveClosedGroupDialog = AdminLeaveClosedGroupDialog;
const ContentWrapper = styled_components_1.default.p `
max-width: 450px;
margin-top: 0px;
text-align: initial;
color: #A7A7BA;
font-size: 16px;
font-style: normal;
font-weight: 400;
line-height: 20px;

`;
