"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatConfirm = void 0;
const react_1 = __importStar(require("react"));
const BchatHTMLRenderer_1 = require("../basic/BchatHTMLRenderer");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const Text_1 = require("../basic/Text");
const BchatButton_1 = require("../basic/BchatButton");
const icon_1 = require("../icon");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const react_use_1 = require("react-use");
const BchatConfirm = (props) => {
    const { title = '', message = '', messageSub = '', closeTheme = BchatButton_1.BchatButtonColor.Secondary, onClickOk, onClickClose, hideCancel = false, bchatIcon, iconSize, shouldShowConfirm, onClickCancel, showExitIcon, closeAfterInput = true, btndisable, Childern = '', iconShow, customIcon, okIcon, cancelIcon } = props;
    const [isLoading, setIsLoading] = (0, react_1.useState)(false);
    const okText = props.okText || window.i18n('ok');
    const cancelText = props.cancelText || window.i18n('cancel');
    const showHeader = !!props.title;
    const messageSubText = messageSub ? 'bchat-confirm-main-message' : 'subtle';
    const onClickOkHandler = async () => {
        if (onClickOk) {
            setIsLoading(true);
            try {
                await onClickOk();
            }
            catch (e) {
                window.log.warn(e);
            }
            finally {
                setIsLoading(false);
            }
        }
        if (closeAfterInput) {
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
        }
    };
    if (shouldShowConfirm && !shouldShowConfirm) {
        return null;
    }
    const onClickCancelHandler = () => {
        if (onClickCancel) {
            onClickCancel();
        }
        if (onClickClose) {
            onClickClose();
        }
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
    };
    const validCustomIcon = bchatIcon && iconSize ? react_1.default.createElement(icon_1.BchatIcon, { iconType: bchatIcon, iconSize: iconSize, clipRule: 'evenodd', fillRule: 'evenodd' }) : customIcon;
    (0, react_use_1.useKey)((event) => {
        return event.key === 'Enter';
    }, onClickOkHandler);
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: title, onClose: onClickClose, showExitIcon: showExitIcon, showHeader: showHeader, okButton: {
            text: okText,
            onClickOkHandler,
            disabled: btndisable ? btndisable : false,
            color: props.okTheme,
            iconType: okIcon ? okIcon.icon : '',
            iconSize: okIcon ? okIcon.size : ''
        }, cancelButton: {
            status: !hideCancel,
            text: cancelText,
            color: closeTheme,
            onClickCancelHandler,
            iconType: cancelIcon ? cancelIcon.icon : '',
            iconSize: cancelIcon ? cancelIcon.size : ''
        }, iconShow: iconShow, customIcon: validCustomIcon, isloading: isLoading },
        !showHeader && react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "bchat-modal-bchatConfirm" },
            Childern,
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement(BchatHTMLRenderer_1.BchatHtmlRenderer, { tag: "span", className: messageSubText, html: message }),
            react_1.default.createElement(BchatHTMLRenderer_1.BchatHtmlRenderer, { tag: "span", className: "bchat-confirm-sub-message subtle", html: messageSub }))));
};
exports.BchatConfirm = BchatConfirm;
