"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatNicknameDialog = void 0;
const react_1 = __importStar(require("react"));
const conversations_1 = require("../../bchat/conversations");
const lodash_1 = __importDefault(require("lodash"));
const Text_1 = require("../basic/Text");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const BchatButton_1 = require("../basic/BchatButton");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const icon_1 = require("../icon");
const BchatNicknameDialog = (props) => {
    const { conversationId } = props;
    const [nickname, setNickname] = (0, react_1.useState)('');
    const dispatch = (0, react_redux_1.useDispatch)();
    const onNicknameInput = async (event) => {
        if (event.key === 'Enter') {
            await saveNickname();
        }
        else if (event.target.value.length <= 26) {
            const currentNicknameEntered = event.target.value;
            setNickname(currentNicknameEntered);
        }
    };
    const onClickClose = () => {
        dispatch((0, modalDialog_1.changeNickNameModal)(null));
    };
    const saveNickname = async () => {
        if (!conversationId) {
            throw new Error('Cant save without conversation id');
        }
        const conversation = (0, conversations_1.getConversationController)().get(conversationId);
        await conversation.setNickname(nickname);
        onClickClose();
    };
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: window.i18n('changeNickname'), onClose: onClickClose, showExitIcon: false, showHeader: true, additionalClassName: "nickNameDialog", okButton: {
            text: window.i18n('ok'),
            color: BchatButton_1.BchatButtonColor.Primary,
            onClickOkHandler: () => saveNickname(),
        }, cancelButton: {
            status: true,
            text: window.i18n('cancel'),
            buttonColor: BchatButton_1.BchatButtonColor.Secondary,
            onClickCancelHandler: () => onClickClose(),
        } },
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "input-wrapper" },
            react_1.default.createElement("input", { autoFocus: true, className: "", type: "nickname", id: "nickname-modal-input", value: nickname, placeholder: window.i18n('nicknamePlaceholder'), onKeyUp: e => {
                    void onNicknameInput(lodash_1.default.cloneDeep(e));
                }, onChange: e => {
                    void onNicknameInput(lodash_1.default.cloneDeep(e));
                } }),
            react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'xWithCircle', iconSize: 24, onClick: () => setNickname('') })),
        react_1.default.createElement(Text_1.SpacerLG, null)));
};
exports.BchatNicknameDialog = BchatNicknameDialog;
