"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatSeedModal = void 0;
const react_1 = __importStar(require("react"));
const utils_1 = require("../../bchat/utils");
const Text_1 = require("../basic/Text");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const react_redux_1 = require("react-redux");
const storage_1 = require("../../util/storage");
const BchatButton_1 = require("../basic/BchatButton");
const theme_1 = require("../../state/selectors/theme");
const Seed = (props) => {
    const { recoveryPhrase, onClickCopy } = props;
    const i18n = window.i18n;
    const dispatch = (0, react_redux_1.useDispatch)();
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const copyRecoveryPhrase = (recoveryPhraseToCopy) => {
        window.clipboard.writeText(recoveryPhraseToCopy);
        utils_1.ToastUtils.pushCopiedToClipBoard();
        if (onClickCopy) {
            onClickCopy();
        }
        dispatch((0, modalDialog_1.recoveryPhraseModal)(null));
    };
    return (react_1.default.createElement("div", { className: 'bchat-modal__seedPhrase' },
        react_1.default.createElement("div", { className: 'subLayer' },
            react_1.default.createElement("div", { className: "box" },
                react_1.default.createElement("div", { className: "bchat-modal__centered text-center " },
                    react_1.default.createElement("p", { className: "bchat-modal__description" }, i18n('recoveryPhrase')),
                    react_1.default.createElement("img", { src: darkMode ? 'images/bchat/recoveryPhrase.svg' : "images/bchat/recoveryPhraseLight.svg", width: "150px", height: "150px" }),
                    react_1.default.createElement("i", { "data-testid": "recovery-phrase-seed-modal", className: "bchat-modal__text-highlight" }, recoveryPhrase),
                    react_1.default.createElement("p", { className: 'subText' }, "Copy your Recovery Seed and keep it safe."))),
            react_1.default.createElement("div", { className: 'bchat-modal-footer' },
                react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('editMenuCopy'), buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Primary, iconSize: 20, iconType: 'copy', fillRule: 'evenodd', clipRule: 'evenodd', onClick: () => { copyRecoveryPhrase(recoveryPhrase); } })))));
};
const BchatSeedModalInner = (props) => {
    const { onClickOk } = props;
    const [loadingPassword, setLoadingPassword] = (0, react_1.useState)(true);
    const [loadingSeed, setLoadingSeed] = (0, react_1.useState)(true);
    const [recoveryPhrase, setRecoveryPhrase] = (0, react_1.useState)('');
    (0, react_1.useEffect)(() => {
        setTimeout(() => document.getElementById('seed-input-password')?.focus(), 100);
        void checkHasPassword();
        void getRecoveryPhrase();
    }, []);
    const checkHasPassword = async () => {
        if (!loadingPassword) {
            return;
        }
        setLoadingPassword(false);
    };
    const getRecoveryPhrase = async () => {
        if (recoveryPhrase) {
            return false;
        }
        const newRecoveryPhrase = (0, storage_1.getCurrentRecoveryPhrase)();
        setRecoveryPhrase(newRecoveryPhrase);
        setLoadingSeed(false);
        return true;
    };
    return (react_1.default.createElement(react_1.default.Fragment, null, !loadingSeed && (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement(Seed, { recoveryPhrase: recoveryPhrase, onClickCopy: onClickOk })))));
};
exports.BchatSeedModal = BchatSeedModalInner;
