"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatWalletForgotPasswordModal = void 0;
const react_1 = __importStar(require("react"));
const BchatButton_1 = require("../basic/BchatButton");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const icon_1 = require("../icon");
const electron_1 = require("electron");
const utils_1 = require("../../bchat/utils");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const daemon_rpc_1 = require("../../wallet/daemon-rpc");
const react_redux_1 = require("react-redux");
const storage_1 = require("../../util/storage");
const daemon_1 = require("../../state/ducks/daemon");
const data_1 = require("../../data/data");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const react_use_1 = require("react-use");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const BchatWalletForgotPasswordModal = () => {
    const [seed, setSeed] = (0, react_1.useState)('');
    const [newPassword, setNewPassword] = (0, react_1.useState)('');
    const [confirmPassword, setConfirmNewPassword] = (0, react_1.useState)('');
    const [loading, setLoading] = (0, react_1.useState)(false);
    const [newPasswordVisible, setNewPasswordVisible] = (0, react_1.useState)(true);
    const [confirmPasswordVisible, setConfirmNewPasswordVisible] = (0, react_1.useState)(true);
    const userId = (0, react_redux_1.useSelector)((state) => state.user.ourNumber);
    const UserDetails = (0, react_redux_1.useSelector)((state) => state.conversations.conversationLookup);
    const recoveryPhrase = (0, storage_1.getCurrentRecoveryPhrase)();
    const walletDaemonHeight = (0, useParamSelector_1.useConversationWalletDaemonHeight)(utils_1.UserUtils.getOurPubKeyStrFromCache());
    const dispatch = (0, react_redux_1.useDispatch)();
    function onClickCancelHandler() {
        dispatch((0, modalDialog_1.updateBchatWalletForgotPasswordModal)(null));
        dispatch((0, modalDialog_1.updateBchatWalletPasswordModal)({ from: 'wallet' }));
    }
    const handlePaste = () => {
        const recoverySeed = electron_1.clipboard.readText();
        setSeed(recoverySeed.replace(/^\s+|\s+$/g, ''));
    };
    const seedvalidation = async () => {
        try {
            const trimWhiteSpace = seed.replace(/^\s+|\s+$/g, '');
            const wlist = trimWhiteSpace.split(' ');
            const wordset = { prefixLen: 3 };
            if (wlist.length < 24) {
                utils_1.ToastUtils.pushToastError('invalidSeed', "You've entered too few words, please try again");
                return false;
            }
            if ((wordset.prefixLen === 0 && wlist.length % 3 !== 0) ||
                (wordset.prefixLen > 0 && wlist.length % 3 === 2)) {
                utils_1.ToastUtils.pushToastError('invalidSeed', "You've entered too few words, please try again");
                return false;
            }
            let trimWhiteSpaceRec = recoveryPhrase.replace(/^\s+|\s+$/g, '');
            if (trimWhiteSpace.toLocaleLowerCase() !== trimWhiteSpaceRec.toLocaleLowerCase()) {
                utils_1.ToastUtils.pushToastError('invalidSeed', 'Seed entered does not match.');
                return false;
            }
            return true;
        }
        catch (error) {
            utils_1.ToastUtils.pushToastError('forgotPasswordError', `Error: ${error.message || 'Something went wrong'}`);
            return false;
        }
    };
    const passValid = async () => {
        let userDetails = await (0, data_1.getConversationById)(utils_1.UserUtils.getOurPubKeyStrFromCache());
        if (!seed) {
            return utils_1.ToastUtils.pushToastError('seedFieldEmpty', window.i18n('seedFieldEmpty'));
        }
        if (!newPassword || !confirmPassword) {
            return utils_1.ToastUtils.pushToastError('passwordFieldEmpty', window.i18n('passwordFieldEmpty'));
        }
        if (newPassword !== confirmPassword) {
            window?.log?.warn('invalid password');
            return utils_1.ToastUtils.pushToastError('invalidPassword', 'Passwords do not match');
        }
        const seedValidation = await seedvalidation();
        if (!seedValidation) {
            return;
        }
        if ((newPassword.length < 4 && confirmPassword.length < 4) ||
            (newPassword.length > 13 && confirmPassword.length > 13)) {
            return utils_1.ToastUtils.pushToastError('walletPasswordLengthError', window.i18n('walletPasswordLengthError'));
        }
        let profileName = userDetails?.attributes.walletUserName;
        if (!profileName) {
            profileName = UserDetails[userId].profileName;
        }
        const refreshDetails = {
            refresh_start_timestamp_or_height: walletDaemonHeight ? walletDaemonHeight : 0,
        };
        try {
            await wallet_rpc_1.wallet.restoreWallet(profileName, newPassword, seed, refreshDetails, 'forgotPassword');
            daemon_rpc_1.daemon.sendRPC('get_info').then(data => {
                if (!data.hasOwnProperty('error')) {
                    dispatch((0, daemon_1.updateDaemon)({ height: data.result.height }));
                }
            });
            setLoading(false);
            utils_1.ToastUtils.pushToastSuccess('changePasswordSuccess', 'Password successfully changed.');
            return onClickCancelHandler();
        }
        catch (error) {
            setLoading(false);
            {
                error?.message && utils_1.ToastUtils.pushToastError('changePasswordError', error?.message);
            }
        }
    };
    (0, react_use_1.useKey)((event) => {
        return event.key === 'Enter';
    }, passValid);
    return (react_1.default.createElement("div", { className: "wallet-forgotPassword" },
        react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: window.i18n('forgotPassword'), onClose: () => { }, buttonSizeLg: true, showExitIcon: false, showHeader: true, headerReverse: false, additionalClassName: "walletPassword", isloading: loading, okButton: {
                text: window.i18n('save'),
                onClickOkHandler: () => {
                    passValid();
                },
                color: BchatButton_1.BchatButtonColor.Primary,
                disabled: false,
            }, cancelButton: {
                text: window.i18n('cancel'),
                status: true,
                color: BchatButton_1.BchatButtonColor.Secondary,
                onClickCancelHandler: () => {
                    onClickCancelHandler();
                },
            } },
            react_1.default.createElement("div", { className: "wallet-forgotPassword-content-Box" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(Text_1.SpacerMD, null),
                    react_1.default.createElement("div", { className: "wallet-forgotPassword-content-Box-seed" },
                        react_1.default.createElement("textarea", { value: seed, onChange: e => {
                                const value = e.target.value;
                                let trimmedValue = !value.trim() ? '' : value;
                                setSeed(trimmedValue);
                            }, placeholder: window.i18n('enterSeed'), autoFocus: true }),
                        react_1.default.createElement("div", { style: { marginTop: '15px' }, "data-tip": "Paste", "data-offset": "{'top':30,'left':15}", "data-place": "right" },
                            react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'paste', iconSize: 20, iconColor: "#0B9E3C", onClick: () => handlePaste() }))),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement("div", { className: "wallet-forgotPassword-content-Box-password-label" }, window.i18n('changeWalletPassword')),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: 'row', alignItems: "center", width: "100%", className: "wallet-forgotPassword-content-Box-password" },
                        react_1.default.createElement("input", { value: newPassword, onChange: e => {
                                setNewPassword(e.target.value);
                            }, placeholder: window.i18n('enterNewWalletPassword'), type: newPasswordVisible ? 'password' : 'text', maxLength: 13 }),
                        react_1.default.createElement(icon_1.BchatIconButton, { iconType: !newPasswordVisible ? 'eye_closed' : 'eye', iconSize: 'medium', fillRule: "evenodd", clipRule: "evenodd", onClick: () => setNewPasswordVisible(!newPasswordVisible) })),
                    react_1.default.createElement(Text_1.SpacerSM, null),
                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: 'row', alignItems: "center", width: "100%", className: "wallet-forgotPassword-content-Box-password" },
                        react_1.default.createElement("input", { value: confirmPassword, onChange: e => {
                                setConfirmNewPassword(e.target.value);
                            }, placeholder: 'Confirm wallet password', type: confirmPasswordVisible ? 'password' : 'text', maxLength: 13 }),
                        react_1.default.createElement(icon_1.BchatIconButton, { iconType: !confirmPasswordVisible ? 'eye_closed' : 'eye', iconSize: 'medium', fillRule: "evenodd", clipRule: "evenodd", onClick: () => setConfirmNewPasswordVisible(!confirmPasswordVisible) }))),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement("div", { className: "wallet-forgotPassword-content-Box-disClaimerBox" },
                    react_1.default.createElement("span", { style: { color: 'red', marginRight: '10px' } }, "Disclaimer :"),
                    react_1.default.createElement("span", null, window.i18n('disclaimerForgotPassword', walletDaemonHeight)))))));
};
exports.BchatWalletForgotPasswordModal = BchatWalletForgotPasswordModal;
