"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatSendConfirm = void 0;
const react_1 = __importStar(require("react"));
const modalDialog_1 = require("../../state/ducks/modalDialog");
const Text_1 = require("../basic/Text");
const BchatButton_1 = require("../basic/BchatButton");
const icon_1 = require("../icon");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const react_use_1 = require("react-use");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const BchatSendConfirm = (props) => {
    const { onClickOk, onClickClose, bchatIcon, iconSize, shouldShowConfirm, onClickCancel, showExitIcon, closeAfterInput = true, btndisable, address, amount, fee, Priority, } = props;
    const [confirm, setConfirm] = (0, react_1.useState)(false);
    const [password, setPassword] = (0, react_1.useState)('');
    const [error, setError] = (0, react_1.useState)('');
    const inputRef = (0, react_1.useRef)(null);
    const cancelText = props.cancelText || window.i18n('cancel');
    const onClickOkHandler = async () => {
        if (onClickOk) {
            try {
                if (!confirm) {
                    passwordVerify();
                }
                else {
                    if (!password) {
                        setError(window.i18n('passwordFieldEmpty'));
                        return;
                    }
                    if (wallet_rpc_1.wallet.wallet_state.password_hash === wallet_rpc_1.wallet.passwordEncrypt(password)) {
                        await onClickOk();
                    }
                    else {
                        setError(window.i18n('invalidPassword'));
                    }
                }
            }
            catch (e) {
                window.log.warn(e);
            }
            finally {
            }
        }
        if (closeAfterInput) {
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
        }
    };
    if (shouldShowConfirm && !shouldShowConfirm) {
        return null;
    }
    const onClickCancelHandler = () => {
        if (onClickCancel) {
            onClickCancel();
        }
        if (onClickClose) {
            onClickClose();
        }
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
    };
    (0, react_use_1.useKey)((event) => {
        return event.key === 'Enter';
    }, onClickOkHandler);
    async function passwordVerify() {
        setConfirm(true);
    }
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: confirm ? 'Password' : 'Confirm Sending', onClose: onClickClose, showExitIcon: showExitIcon, showHeader: true, okButton: {
            onClickOkHandler: () => onClickOkHandler(),
            color: BchatButton_1.BchatButtonColor.Primary,
            text: confirm ? 'Confirm' : window.i18n('send'),
            disabled: btndisable ? btndisable : false
        }, cancelButton: {
            text: cancelText,
            status: true,
            color: BchatButton_1.BchatButtonColor.Secondary,
            onClickCancelHandler: () => onClickCancelHandler(),
        } },
        react_1.default.createElement("div", { className: "bchat-modal__centered" },
            react_1.default.createElement(Text_1.SpacerMD, null),
            bchatIcon && iconSize && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(icon_1.BchatIcon, { iconType: bchatIcon, iconSize: iconSize }),
                react_1.default.createElement(Text_1.SpacerLG, null))),
            confirm ? (react_1.default.createElement("div", null,
                react_1.default.createElement("div", { className: "bchat-modal__centered-sendConfirm_content-subHeader" }, "Enter your wallet Password"),
                react_1.default.createElement(Text_1.SpacerSM, null),
                react_1.default.createElement("div", { className: "bchat-modal__centered-sendConfirm_content-passwordBox" },
                    react_1.default.createElement("input", { type: "password", autoFocus: true, placeholder: 'Enter Password', value: password, onChange: e => setPassword(e.target.value), ref: inputRef })),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement("div", { className: "bchat-modal__centered-sendConfirm_content-errorTxt" }, error),
                react_1.default.createElement(Text_1.SpacerSM, null))) : (react_1.default.createElement("article", { className: "bchat-modal__centered-sendConfirm_content" },
                react_1.default.createElement("div", { className: "senderBox box-wrapper", style: { display: 'block' } },
                    react_1.default.createElement("div", { className: "", style: { fontWeight: '600', color: 'var(--color-text)', fontSize: '16px' } },
                        "Send to  ",
                        react_1.default.createElement("div", { className: "senderBox-address senderBox-addressColor" }, address))),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement("div", { className: 'box-wrapper' },
                    react_1.default.createElement("div", { className: "senderBox " },
                        react_1.default.createElement("div", { className: "bchat-modal__centered-sendConfirm_content-probTitle" }, "Amount  "),
                        ' ',
                        react_1.default.createElement("div", { className: "senderBox-details", style: { color: '#108D32' } },
                            amount,
                            " BDX")),
                    react_1.default.createElement(Text_1.SpacerMD, null),
                    react_1.default.createElement("div", { className: "senderBox" },
                        react_1.default.createElement("div", { className: "bchat-modal__centered-sendConfirm_content-probTitle" }, "Estimated Fee  "),
                        ' ',
                        react_1.default.createElement("div", { className: "senderBox-details " },
                            fee,
                            " BDX")),
                    react_1.default.createElement(Text_1.SpacerMD, null),
                    react_1.default.createElement("div", { className: "senderBox" },
                        react_1.default.createElement("div", { className: "bchat-modal__centered-sendConfirm_content-probTitle" }, "Priority  "),
                        react_1.default.createElement("div", { className: "senderBox-details" }, Priority))),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement(Text_1.SpacerLG, null))))));
};
exports.BchatSendConfirm = BchatSendConfirm;
