"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BnsLinkDialog = void 0;
const react_1 = __importStar(require("react"));
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const BchatButton_1 = require("../basic/BchatButton");
const BchatIcon_1 = require("../icon/BchatIcon");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const utils_1 = require("../../bchat/utils");
const BnsVerification_1 = require("../conversation/BnsVerification");
const Text_1 = require("../basic/Text");
const react_redux_1 = require("react-redux");
const theme_1 = require("../../state/selectors/theme");
const BnsLinkDialog = () => {
    const [success, setSuccess] = (0, react_1.useState)(false);
    const [bnsName, setBnsName] = (0, react_1.useState)('');
    const [isVerify, setIsVerify] = (0, react_1.useState)(false);
    const [isLoading, setIsLoading] = (0, react_1.useState)(false);
    const [verifyError, setVerifyError] = (0, react_1.useState)(false);
    const ourNumber = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const regexForBnsName = /^(?!-)[A-Za-z0-9-]+(?<!-)\.bdx$/;
    const i18n = window.i18n;
    function closeDialog() {
        window.inboxStore?.dispatch((0, modalDialog_1.bnsLinkModal)(null));
        setSuccess(false);
        window.inboxStore?.dispatch((0, modalDialog_1.editProfileModal)({}));
    }
    async function verifyBns() {
        setIsLoading(true);
        const isverified = await (0, BnsVerification_1.isLinkedBchatIDWithBnsForDeamon)(bnsName);
        setIsVerify(isverified);
        setVerifyError(!isverified);
        setIsLoading(false);
    }
    const callLinkBns = async () => {
        await (0, BnsVerification_1.linkBns)(bnsName);
        setSuccess(true);
    };
    const onchange = (e) => {
        setBnsName(e);
        verifyError && setVerifyError(false);
    };
    const BnsLinkedSuccessModal = () => {
        return (react_1.default.createElement("div", { style: { textAlign: 'center' } },
            react_1.default.createElement("div", null,
                react_1.default.createElement("img", { src: darkMode ? 'images/bchat/linked_bns.gif' : 'images/bchat/linked_bns_white.gif', style: { width: '120px', height: '120px' } })),
            react_1.default.createElement("div", { className: "linked_bns" }, i18n('bnsLinkedSuccessfully'))));
    };
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { showHeader: false, onClose: closeDialog, showExitIcon: false, isloading: isLoading, okButton: {
            text: success ? i18n('ok') : i18n('cancel'),
            onClickOkHandler: closeDialog,
            color: success ? BchatButton_1.BchatButtonColor.Primary : BchatButton_1.BchatButtonColor.Secondary,
        } },
        react_1.default.createElement("div", { className: "bns_link_modal" }, !success ? (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("header", null, i18n('linkBNS')),
            react_1.default.createElement("div", { className: "id_wrapper" },
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement("div", { className: "id-label" }, window.i18n('yourBchatID')),
                react_1.default.createElement(Text_1.SpacerSM, null),
                react_1.default.createElement("p", { className: "id_content" }, ourNumber),
                react_1.default.createElement(Text_1.SpacerMD, null)),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement("div", { className: "label_input" }, i18n('bnsName')),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("div", { className: "inputBox-wrapper", style: { border: verifyError ? ' 1px solid #FF3E3E' : '' } },
                react_1.default.createElement("input", { style: { color: verifyError ? '#FF3E3E' : '#0BB70F' }, type: "text", className: "inputBox", disabled: isVerify, value: bnsName, placeholder: i18n('enterBnsName'), onChange: event => {
                        onchange(event.target.value);
                    }, maxLength: 33, "data-testid": "profile-name-input" })),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "divided-btn-wrapper" },
                !isVerify ? (react_1.default.createElement(BchatButton_1.BchatButton, { style: {
                        width: '245px',
                    }, text: i18n('verify'), disabled: !regexForBnsName.test(bnsName.toLowerCase()), buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Primary, onClick: () => verifyBns() })) : (react_1.default.createElement("div", { className: "bchat-btn-struct" },
                    react_1.default.createElement("span", { style: { marginRight: '4px' } }, i18n('verified')),
                    react_1.default.createElement("span", { style: { display: 'flex' } },
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "circleWithTick", iconSize: 16, iconColor: "#0B9E3C" })))),
                react_1.default.createElement(BchatButton_1.BchatButton, { style: {
                        width: '245px',
                        marginLeft: '10px'
                    }, text: i18n('linkBNS'), disabled: !isVerify, buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Primary, onClick: () => callLinkBns() })))) : (react_1.default.createElement(BnsLinkedSuccessModal, null)))));
};
exports.BnsLinkDialog = BnsLinkDialog;
