"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommunityGuidelinesDialog = void 0;
const react_1 = __importDefault(require("react"));
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const electron_1 = require("electron");
const CommunityGuidelinesDialog = () => {
    function closeDialog() {
        window.inboxStore?.dispatch((0, modalDialog_1.updateCommunityGuidelinesModal)(null));
    }
    const openLink = (url) => {
        void electron_1.shell.openExternal(url);
    };
    return (react_1.default.createElement("div", { className: "community-guidelines" },
        react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { showHeader: true, onClose: closeDialog, showExitIcon: false, isloading: false, title: "Community Guidelines", okButton: {
                text: window.i18n('close'),
                onClickOkHandler: closeDialog,
            } },
            react_1.default.createElement("section", null,
                react_1.default.createElement("article", null,
                    react_1.default.createElement("div", null, "BChat is a decentralized messaging platform that protects your privacy. When you're using BChat, you own your conversations and data. It does not collect or store any of your personal information. BChat is where you chat with freedom."),
                    react_1.default.createElement("div", null, "BChat is also more than a messaging application. You can send and receive BDX right from your chat box."),
                    react_1.default.createElement("div", null, "BChat is built on top of the Beldex network. Masternodes on the Beldex network store and relay encrypted messages between clients. Other projects that are currently being researched or developed by Beldex include BelNet (a decentralized VPN service), Beldex Browser (an ad-free Web3 browser), and the Beldex Privacy Protocol (to anonymize every other asset)."),
                    react_1.default.createElement("div", null,
                        "To know more, visit:",
                        react_1.default.createElement("a", { onClick: () => openLink('https://www.beldex.io'), style: { textDecoration: "underline" } }, " https://www.beldex.io")),
                    react_1.default.createElement("div", null,
                        "For collabs or marketing proposals, contact ",
                        react_1.default.createElement("a", null, "marketing@beldex.io.")),
                    react_1.default.createElement("div", null,
                        "For investments, contact ",
                        react_1.default.createElement("a", null, "invest.bchat@beldex.io")),
                    react_1.default.createElement("div", null, "To protect and preserve this community, kindly follow the group rules and guidelines."),
                    react_1.default.createElement("div", null, "Be civil. You can share your opinions and constructive criticisms but harassment is not permitted. Don't promote or shill your token/project. This group is dedicated to BChat and the Beldex ecosystem. Spammers will be banned."),
                    react_1.default.createElement("div", null, "Do not share NSFW content or use profane language."),
                    react_1.default.createElement("div", null, "Beware of scammers. Admins will not DM you first."))))));
};
exports.CommunityGuidelinesDialog = CommunityGuidelinesDialog;
