"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteAccountModal = exports.sendConfigMessageAndDeleteEverything = exports.deleteDbLocally = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const onionPath_1 = require("../../bchat/onions/onionPath");
const SNodeAPI_1 = require("../../bchat/apis/snode_api/SNodeAPI");
const syncUtils_1 = require("../../bchat/utils/syncUtils");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const BchatButton_1 = require("../basic/BchatButton");
const BchatHTMLRenderer_1 = require("../basic/BchatHTMLRenderer");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const Data = __importStar(require("../../data/data"));
const logs_1 = require("../../node/logs");
const BchatIcon_1 = require("../icon/BchatIcon");
const Text_1 = require("../basic/Text");
const deleteDbLocally = async (deleteType) => {
    window?.log?.info('last message sent successfully. Deleting everything');
    window.persistStore?.purge();
    await (0, logs_1.deleteAllLogs)();
    if (deleteType === 'oldVersion') {
        await Data.removeAllWithOutRecipient();
    }
    else {
        await Data.removeAll();
    }
    await Data.close();
    await Data.removeDB();
    await Data.removeOtherData();
    window.localStorage.setItem('restart-reason', 'delete-account');
};
exports.deleteDbLocally = deleteDbLocally;
async function sendConfigMessageAndDeleteEverything(deleteType) {
    try {
        window?.log?.info('DeleteAccount => Sending a last SyncConfiguration');
        await (0, syncUtils_1.forceSyncConfigurationNowIfNeeded)(true);
        window?.log?.info('Last configuration message sent!');
        await (0, exports.deleteDbLocally)(deleteType);
        window.restart();
    }
    catch (error) {
        window?.log?.error('Something went wrong deleting all data:', error && error.stack ? error.stack : error);
        try {
            await (0, exports.deleteDbLocally)(deleteType);
        }
        catch (e) {
            window?.log?.error(e);
        }
        finally {
            window.restart();
        }
    }
}
exports.sendConfigMessageAndDeleteEverything = sendConfigMessageAndDeleteEverything;
async function deleteEverythingAndNetworkData() {
    try {
        const potentiallyMaliciousSnodes = await (0, SNodeAPI_1.forceNetworkDeletion)();
        if (potentiallyMaliciousSnodes === null) {
            window?.log?.warn('DeleteAccount => forceNetworkDeletion failed');
            window.inboxStore?.dispatch((0, modalDialog_1.updateDeleteAccountModal)(null));
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
                title: window.i18n('dialogClearAllDataDeletionFailedTitle'),
                message: window.i18n('dialogClearAllDataDeletionFailedDesc'),
                okTheme: BchatButton_1.BchatButtonColor.Danger,
                okText: window.i18n('deviceOnly'),
                onClickOk: async () => {
                    await (0, exports.deleteDbLocally)();
                    window.restart();
                },
            }));
            return;
        }
        if (potentiallyMaliciousSnodes.length > 0) {
            const snodeStr = potentiallyMaliciousSnodes.map(onionPath_1.ed25519Str);
            window?.log?.warn('DeleteAccount => forceNetworkDeletion Got some potentially malicious snodes', snodeStr);
            window.inboxStore?.dispatch((0, modalDialog_1.updateDeleteAccountModal)(null));
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
                title: window.i18n('dialogClearAllDataDeletionFailedTitle'),
                message: window.i18n('dialogClearAllDataDeletionFailedMultiple', [
                    potentiallyMaliciousSnodes.join(', '),
                ]),
                messageSub: window.i18n('dialogClearAllDataDeletionFailedTitleQuestion'),
                okTheme: BchatButton_1.BchatButtonColor.Danger,
                okText: window.i18n('deviceOnly'),
                onClickOk: async () => {
                    await (0, exports.deleteDbLocally)();
                    window.restart();
                },
            }));
            return;
        }
        await (0, exports.deleteDbLocally)();
        window.restart();
    }
    catch (error) {
        window?.log?.error('Something went wrong deleting all data:', error && error.stack ? error.stack : error);
        try {
            await (0, exports.deleteDbLocally)();
        }
        catch (e) {
            window?.log?.error(e);
        }
        window.restart();
    }
}
const DeleteAccountModal = () => {
    const [isLoading, setIsLoading] = (0, react_1.useState)(false);
    const [deleteDeviceOnly, setDeleteDeviceOnly] = (0, react_1.useState)(false);
    const [deleteEverythingWithNetwork, setDeleteEverythingWithNetwork] = (0, react_1.useState)(false);
    const dispatch = (0, react_redux_1.useDispatch)();
    const onDeleteEverythingLocallyOnly = async () => {
        if (!isLoading) {
            setIsLoading(true);
            try {
                window.log.warn('Deleting everything on device but keeping network data');
                await sendConfigMessageAndDeleteEverything();
            }
            catch (e) {
                window.log.warn(e);
            }
            finally {
                setIsLoading(false);
            }
        }
    };
    const onDeleteEverythingAndNetworkData = async () => {
        if (!isLoading) {
            setIsLoading(true);
            try {
                window.log.warn('Deleting everything including network data');
                await deleteEverythingAndNetworkData();
            }
            catch (e) {
                window.log.warn(e);
            }
            finally {
                setIsLoading(false);
            }
        }
    };
    const onClickCancelHandler = (0, react_1.useCallback)(() => {
        dispatch((0, modalDialog_1.updateDeleteAccountModal)(null));
    }, []);
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: window.i18n('clearAllData'), okButton: {
            text: window.i18n('close'),
            onClickOkHandler: onClickCancelHandler
        }, iconShow: true, customIcon: react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "clearDataIcon", iconSize: 26 }), isloading: isLoading },
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement("div", { className: 'bchat-modal__deleteAccountModal' },
            react_1.default.createElement("div", { className: 'fontSemiBold' },
                window.i18n('deleteAccountWarning'),
                react_1.default.createElement("span", null, window.i18n('dialogClearAllDataDeletionQuestion'))),
            react_1.default.createElement("div", { className: "buttons" },
                react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('deviceOnly'), buttonColor: deleteDeviceOnly ? BchatButton_1.BchatButtonColor.Danger : BchatButton_1.BchatButtonColor.Enable, onClick: () => {
                        setDeleteDeviceOnly(true);
                        setDeleteEverythingWithNetwork(false);
                    }, style: { marginRight: '25px', minWidth: '240px', height: '55px', fontWeight: 500 }, iconType: deleteDeviceOnly ? "circle" : undefined, iconSize: "tiny" }),
                react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('entireAccount'), buttonColor: deleteEverythingWithNetwork ? BchatButton_1.BchatButtonColor.Danger : BchatButton_1.BchatButtonColor.Enable, onClick: () => {
                        setDeleteEverythingWithNetwork(true);
                        setDeleteDeviceOnly(false);
                    }, style: { marginRight: '12px', minWidth: '240px', height: '55px', fontWeight: 500 }, iconType: deleteEverythingWithNetwork ? "circle" : undefined, iconSize: "tiny" })),
            deleteEverythingWithNetwork && (react_1.default.createElement(BchatHTMLRenderer_1.BchatHtmlRenderer, { tag: "span", className: "bchat-confirm-main-message", html: window.i18n('areYouSureDeleteEntireAccount') })),
            deleteDeviceOnly && (react_1.default.createElement(BchatHTMLRenderer_1.BchatHtmlRenderer, { tag: "span", className: "bchat-confirm-main-message", html: window.i18n('areYouSureDeleteDeviceOnly') })),
            (deleteDeviceOnly || deleteEverythingWithNetwork) && (react_1.default.createElement("div", { className: "buttons", style: { marginLeft: '110px', height: "90px", marginBottom: '10px' } },
                react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('iAmSure'), buttonColor: BchatButton_1.BchatButtonColor.Primary, onClick: () => {
                        if (deleteDeviceOnly) {
                            void onDeleteEverythingLocallyOnly();
                        }
                        else if (deleteEverythingWithNetwork) {
                            void onDeleteEverythingAndNetworkData();
                        }
                    }, style: { marginRight: '25px', minWidth: '240px', height: '55px' } }))))));
};
exports.DeleteAccountModal = DeleteAccountModal;
