"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddModeratorsDialog = void 0;
const react_1 = __importStar(require("react"));
const types_1 = require("../../bchat/types");
const utils_1 = require("../../bchat/utils");
const Flex_1 = require("../basic/Flex");
const opengroupV2_1 = require("../../bchat/apis/open_group_api/opengroupV2");
const conversations_1 = require("../../bchat/conversations");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const BchatButton_1 = require("../basic/BchatButton");
const BchatSpinner_1 = require("../basic/BchatSpinner");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const BchatIcon_1 = require("../icon/BchatIcon");
const theme_1 = require("../../state/selectors/theme");
const AddModeratorsDialog = (props) => {
    const { conversationId } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const convo = (0, conversations_1.getConversationController)().get(conversationId);
    const [inputBoxValue, setInputBoxValue] = (0, react_1.useState)('');
    const [addingInProgress, setAddingInProgress] = (0, react_1.useState)(false);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const addAsModerator = async () => {
        const pubkey = types_1.PubKey.from(inputBoxValue);
        if (!pubkey) {
            window.log.info('invalid pubkey for adding as moderator:', inputBoxValue);
            utils_1.ToastUtils.pushInvalidBchatId();
            return;
        }
        window?.log?.info(`asked to add moderator: ${pubkey.key}`);
        try {
            setAddingInProgress(true);
            let isAdded;
            const roomInfos = convo.toOpenGroupV2();
            isAdded = await opengroupV2_1.ApiV2.addModerator(pubkey, roomInfos);
            if (!isAdded) {
                window?.log?.warn('failed to add moderators:', isAdded);
                dispatch((0, modalDialog_1.updateAddModeratorsModal)(null));
                utils_1.ToastUtils.pushFailedToAddAsModerator();
            }
            else {
                window?.log?.info(`${pubkey.key} added as moderator...`);
                dispatch((0, modalDialog_1.updateAddModeratorsModal)(null));
                utils_1.ToastUtils.pushUserAddedToModerators();
                setInputBoxValue('');
            }
        }
        catch (e) {
            window?.log?.error('Got error while adding moderator:', e);
        }
        finally {
            setAddingInProgress(false);
        }
    };
    const { i18n } = window;
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { showHeader: false, okButton: {
            text: i18n('add'),
            onClickOkHandler: addAsModerator,
            color: BchatButton_1.BchatButtonColor.Primary,
            disabled: addingInProgress || !inputBoxValue.length
        }, cancelButton: {
            text: window.i18n('cancel'),
            status: true,
            color: BchatButton_1.BchatButtonColor.Secondary,
            onClickCancelHandler: () => {
                dispatch((0, modalDialog_1.updateAddModeratorsModal)(null));
            }
        } },
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", alignItems: "center" },
            react_1.default.createElement("div", { className: 'moderator-addModeratorBox' },
                react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'addModeratorIcon', iconSize: 56, fillRule: "evenodd", clipRule: "evenodd", iconColor: darkMode ? '#F0F0F0' : '#333333' }),
                react_1.default.createElement("p", { className: 'addModeratortext' }, "Add Moderator")),
            react_1.default.createElement("div", { className: 'moderator-inputBox' },
                react_1.default.createElement("input", { type: "text", value: inputBoxValue, placeholder: i18n('enterBchatID'), onChange: event => {
                        setInputBoxValue(event.target.value);
                    } })),
            react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: addingInProgress }))));
};
exports.AddModeratorsDialog = AddModeratorsDialog;
