"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OnionPathModal = exports.ActionPanelOnionStatusLight = exports.ModalStatusLight = exports.OnionNodeStatusLight = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const ip2country_1 = __importDefault(require("ip2country"));
const country_code_lookup_1 = __importDefault(require("country-code-lookup"));
const onions_1 = require("../../state/selectors/onions");
const Flex_1 = require("../basic/Flex");
const useHover_1 = __importDefault(require("react-use/lib/useHover"));
const BchatSpinner_1 = require("../basic/BchatSpinner");
const icon_1 = require("../icon");
const OnionCountryDisplay = ({ index, labelText, snodeIp, }) => {
    const element = () => (react_1.default.createElement("div", { className: "onion__node__country", key: `country-${index}` },
        react_1.default.createElement("div", null, index === 1 ? 'Entry Node' : index !== 0 && index !== 4 ? 'Master Node' : labelText),
        react_1.default.createElement("span", { className: 'ip-country' }, index !== 0 && index !== 4 ? labelText + '(' + snodeIp + ')' : react_1.default.createElement("div", null))));
    const [hoverable] = (0, useHover_1.default)(element);
    return hoverable;
};
const OnionPathModalInner = () => {
    const onionPath = (0, react_redux_1.useSelector)(onions_1.getFirstOnionPath);
    const isOnline = (0, react_redux_1.useSelector)(onions_1.getIsOnline);
    const glowDuration = onionPath.length + 2;
    if (!isOnline || !onionPath || onionPath.length === 0) {
        return react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: true });
    }
    const nodes = [
        {
            label: window.i18n('device'),
        },
        ...onionPath,
        {
            label: window.i18n('destination'),
        },
    ];
    return (react_1.default.createElement("div", { className: 'hopes' },
        react_1.default.createElement("div", { className: 'layer' },
            react_1.default.createElement("div", { className: "onion__description" }, window.i18n('onionPathIndicatorDescription')),
            react_1.default.createElement("div", { className: "onion__node-list" },
                react_1.default.createElement(Flex_1.Flex, { container: true },
                    react_1.default.createElement("div", { className: "onion__node-list-lights" },
                        react_1.default.createElement("div", { className: "onion__vertical-line" }),
                        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", alignItems: "center", height: "100%" }, nodes.map((_snode, index) => {
                            return (react_1.default.createElement(exports.OnionNodeStatusLight, { glowDuration: glowDuration, glowStartDelay: index, key: `light-${index}` }));
                        }))),
                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", alignItems: "flex-start" }, nodes.map((snode, index) => {
                        let labelText = snode.label
                            ? snode.label
                            : `${country_code_lookup_1.default.byIso((0, ip2country_1.default)(snode.ip))?.country}`;
                        if (!labelText) {
                            labelText = window.i18n('unknownCountry');
                        }
                        return labelText ? (react_1.default.createElement(OnionCountryDisplay, { index: index, labelText: labelText, snodeIp: snode.ip })) : null;
                    })))))));
};
const OnionNodeStatusLight = (props) => {
    const { glowStartDelay, glowDuration } = props;
    return (react_1.default.createElement(exports.ModalStatusLight, { glowDuration: glowDuration, glowStartDelay: glowStartDelay, color: '#108D32' }));
};
exports.OnionNodeStatusLight = OnionNodeStatusLight;
const ModalStatusLight = (props) => {
    const { glowStartDelay, glowDuration, color } = props;
    return (react_1.default.createElement("div", { className: "onion__growing-icon" },
        react_1.default.createElement(icon_1.BchatIcon, { borderRadius: '50px', iconColor: color, glowDuration: glowDuration, glowStartDelay: glowStartDelay, iconType: "circle", iconSize: 'small' })));
};
exports.ModalStatusLight = ModalStatusLight;
const ActionPanelOnionStatusLight = (props) => {
    const { isSelected, handleClick, dataTestId, id, size } = props;
    const onionPathsCount = (0, react_redux_1.useSelector)(onions_1.getOnionPathsCount);
    const firstPathLength = (0, react_redux_1.useSelector)(onions_1.getFirstOnionPathLength);
    const isOnline = (0, react_redux_1.useSelector)(onions_1.getIsOnline);
    const red = 'var(--color-destructive)';
    const green = 'var(--green-color)';
    const orange = 'var(--color-warning)';
    let iconColor = red;
    if (isOnline && firstPathLength > 1) {
        iconColor = onionPathsCount >= 2 ? green : onionPathsCount >= 1 ? orange : red;
    }
    return (react_1.default.createElement(icon_1.BchatIconButton, { iconSize: size, iconType: "circle", iconColor: iconColor, onClick: handleClick, isSelected: isSelected, dataTestId: dataTestId, id: id, padding: '0' }));
};
exports.ActionPanelOnionStatusLight = ActionPanelOnionStatusLight;
const OnionPathModal = () => {
    return react_1.default.createElement(OnionPathModalInner, null);
};
exports.OnionPathModal = OnionPathModal;
