"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactListModal = void 0;
const lodash_1 = require("lodash");
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const modalDialog_1 = require("../../state/ducks/modalDialog");
const conversations_1 = require("../../state/selectors/conversations");
const Avatar_1 = require("../avatar/Avatar");
const Flex_1 = require("../basic/Flex");
const ContactName_1 = require("../conversation/ContactName");
const MessageReactions_1 = require("../conversation/message/message-content/MessageReactions");
const data_1 = require("../../data/data");
const utils_1 = require("../../bchat/utils");
const reactions_1 = require("../../util/reactions");
const icon_1 = require("../icon");
const conversations_2 = require("../../bchat/conversations");
const BchatButton_1 = require("../basic/BchatButton");
const modal_1 = require("../../state/selectors/modal");
const theme_1 = require("../../state/selectors/theme");
const StyledReactListContainer = (0, styled_components_1.default)(Flex_1.Flex) `
  // width: 376px;
`;
const StyledReactionsContainer = (0, styled_components_1.default)(Flex_1.Flex) `
  border-bottom: 1.5px solid ${props => props.bdColor};
  width: 100%;
  overflow-x: auto;
  padding: 12px 8px 8px;
`;
const StyledSendersContainer = (0, styled_components_1.default)(Flex_1.Flex) `
  width: 100%;
  // min-height: 3px;
  height: 100%;
  max-height: 261px;
  overflow-x: hidden;
  overflow-y: auto;
  padding: 14px 16px 32px;
`;
const StyledReactionBar = (0, styled_components_1.default)(Flex_1.Flex) `
  width: 100%;
  // margin: 12px 0 20px 4px;

  p {
    color: var(--color-text-subtle);
    margin: 0;
    span {
      color: var(--color-text-subtle);
    }
    span:nth-child(1) {
      margin: 0 8px;
      color: var(--color-text);
    }
    span:nth-child(2) {
      margin-right: 8px;
    }
  }
`;
const StyledReactionSender = (0, styled_components_1.default)(Flex_1.Flex) `
  width: 100%;
  margin-bottom: 12px;
  .module-avatar {
    margin-right: 12px;
  }
`;
const StyledClearButton = styled_components_1.default.button `
  font-size: var(--font-size-sm);
  color: var(--color-destructive);
  border: none;
`;
const StyledAllButton = styled_components_1.default.button `
  max-width: 100px;
  min-width: 70px;

  border-radius: 17px;
  border: ${props => (props.isSelected ? '0.5px solid #858598' : 'unset')};
  font-size: 17px;
  font-weight: 600;
  padding: 2px 10px;
  margin-right: 5px;
  background-color: ${props => (props.isSelected ? 'var(--color-emoji-panel-bg)' : 'unset')};
  span {
    color: #a7a7ba;
    font-size: 16px;
    font-weight: 400;
  }
`;
const ReactionSenders = (props) => {
    const { messageId, currentReact, me, handleClose, reactedDetailList } = props;
    const FilteredList = currentReact
        ? reactedDetailList.filter(({ emoji }) => emoji === currentReact)
        : reactedDetailList;
    const dispatch = (0, react_redux_1.useDispatch)();
    const handleAvatarClick = async (sender) => {
        const message = await (0, data_1.getMessageById)(messageId);
        if (message) {
            handleClose();
            const contact = message.findAndFormatContact(sender);
            dispatch((0, modalDialog_1.updateUserDetailsModal)({
                conversationId: sender,
                userName: contact.name || contact.profileName || sender,
                authorAvatarPath: contact.avatarPath,
            }));
        }
    };
    const handleRemoveReaction = async (currentemoji) => {
        await (0, reactions_1.sendMessageReaction)(messageId, currentemoji);
    };
    return (react_1.default.createElement(react_1.default.Fragment, null, FilteredList.map((reacted, key) => (react_1.default.createElement(StyledReactionSender, { key: key, container: true, justifyContent: 'space-between', alignItems: 'center' },
        react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: 'center' },
            react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.S, pubkey: reacted.sender, onAvatarClick: async () => {
                    await handleAvatarClick(reacted.sender);
                } }),
            reacted.sender === me ? (react_1.default.createElement("span", { style: { fontWeight: 700 } }, " You ")) : (react_1.default.createElement(ContactName_1.ContactName, { pubkey: reacted.sender, module: "module-conversation__user", shouldShowPubkey: false })),
            react_1.default.createElement("span", { style: { fontSize: '18px', marginLeft: '5px' }, role: 'img' },
                ' ',
                reacted.emoji)),
        react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: 'center' }, reacted.sender === me && (react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.BrandOutline, buttonColor: BchatButton_1.BchatButtonColor.Secondary, text: "Remove", iconType: "delete", iconSize: 14, onClick: () => handleRemoveReaction(reacted.emoji), style: {
                borderRadius: '7.529px',
                border: '0.471px solid #858598',
                color: '#A7A7BA',
                padding: '2px 10px',
                backgroundColor: 'var(--color-emoji-panel-bg)',
                fontWeight: 400,
            } }))))))));
};
const ReactListModal = (props) => {
    const [reactions, setReactions] = (0, react_1.useState)([]);
    const reactionsMap = (reactions && Object.fromEntries(reactions)) || {};
    const [currentReact, setCurrentReact] = (0, react_1.useState)('');
    const reactListModalState = (0, react_redux_1.useSelector)(modal_1.getReactListDialog);
    const dispatch = (0, react_redux_1.useDispatch)();
    const { messageId, } = props;
    const me = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const msgProps = (0, react_redux_1.useSelector)((state) => (0, conversations_1.getMessageReactsProps)(state, messageId));
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const modalRef = (0, react_1.useRef)(null);
    const reactedDetailList = (0, react_1.useMemo)(() => {
        if (!msgProps?.sortedReacts)
            return [];
        const reactedCustomData = [];
        msgProps.sortedReacts.forEach(([emoji, { senders }]) => {
            Object.keys(senders).forEach(sender => {
                reactedCustomData.push({ sender, emoji });
            });
        });
        return reactedCustomData;
    }, [msgProps?.sortedReacts]);
    const handleSelectedReaction = (emoji) => {
        return currentReact == emoji;
    };
    const handleReactionClick = (emoji) => {
        setCurrentReact(emoji);
    };
    const handleClose = () => {
        dispatch((0, modalDialog_1.updateReactListModal)(null));
    };
    const handleClearReactions = (event) => {
        event.preventDefault();
        handleClose();
        dispatch((0, modalDialog_1.updateReactClearAllModal)({ reaction: currentReact, messageId }));
    };
    (0, react_1.useEffect)(() => {
        if ((0, lodash_1.isEmpty)(reactedDetailList)) {
            handleClose();
        }
    }, [reactedDetailList]);
    (0, react_1.useEffect)(() => {
        if (msgProps?.sortedReacts && !(0, lodash_1.isEqual)(reactions, msgProps?.sortedReacts)) {
            setReactions(msgProps?.sortedReacts);
        }
        if (reactionsMap && !reactionsMap[currentReact]) {
            setCurrentReact('');
        }
    }, [msgProps?.sortedReacts, me, reactionsMap]);
    (0, react_1.useEffect)(() => {
        const handleClickOutside = (event) => {
            if (modalRef.current && !modalRef.current.contains(event.target)) {
                handleClose();
            }
        };
        document.addEventListener('mousedown', handleClickOutside);
        return () => {
            document.removeEventListener('mousedown', handleClickOutside);
        };
    }, [reactListModalState]);
    if (!msgProps) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    const { convoId, isPublic } = msgProps;
    const convo = (0, conversations_2.getConversationController)().get(convoId);
    const weAreModerator = convo.getConversationModelProps().weAreModerator;
    return (react_1.default.createElement("div", { className: "reaction-list-modal" },
        react_1.default.createElement("div", { className: "innerModal-wrapper" },
            react_1.default.createElement("div", { className: "reaction-list-innreModal show-modal", ref: modalRef },
                react_1.default.createElement(StyledReactListContainer, { container: true, flexDirection: 'column', alignItems: 'flex-start' },
                    react_1.default.createElement(StyledReactionsContainer, { container: true, flexDirection: 'row', alignItems: 'center', justifyContent: "space-between", bdColor: darkMode ? '#4b4b64' : '#ACACAC' },
                        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: 'row', alignItems: 'center' },
                            react_1.default.createElement(StyledAllButton, { onClick: () => setCurrentReact(''), isSelected: currentReact === '' },
                                "All ",
                                react_1.default.createElement("span", null, reactedDetailList.length)),
                            react_1.default.createElement(MessageReactions_1.MessageReactions, { messageId: messageId, hasReactLimit: false, inModal: true, onSelected: handleSelectedReaction, onClick: handleReactionClick, iscurrentReact: currentReact })),
                        react_1.default.createElement(icon_1.BchatIconButton, { iconType: "x", iconSize: 'large', onClick: handleClose })),
                    react_1.default.createElement(StyledSendersContainer, { container: true, flexDirection: 'column', alignItems: 'flex-start' },
                        react_1.default.createElement(StyledReactionBar, { container: true, justifyContent: 'space-between', alignItems: 'center' }, isPublic && weAreModerator && (react_1.default.createElement(StyledClearButton, { onClick: handleClearReactions }, window.i18n('clearAll')))),
                        reactedDetailList && reactedDetailList.length > 0 && (react_1.default.createElement(ReactionSenders, { messageId: messageId, currentReact: currentReact, reactedDetailList: reactedDetailList, me: me, handleClose: handleClose }))))))));
};
exports.ReactListModal = ReactListModal;
