"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateGroupNameDialog = void 0;
const react_1 = __importDefault(require("react"));
const Avatar_1 = require("../avatar/Avatar");
const Text_1 = require("../basic/Text");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const auto_bind_1 = __importDefault(require("auto-bind"));
const conversations_1 = require("../../bchat/conversations");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const BchatButton_1 = require("../basic/BchatButton");
const open_group_1 = require("../../bchat/group/open-group");
const closed_group_1 = require("../../bchat/group/closed-group");
const VisualAttachment_1 = require("../../types/attachments/VisualAttachment");
const icon_1 = require("../icon");
const utils_1 = require("../../bchat/utils");
class UpdateGroupNameDialog extends react_1.default.Component {
    convo;
    constructor(props) {
        super(props);
        (0, auto_bind_1.default)(this);
        this.convo = (0, conversations_1.getConversationController)().get(props.conversationId);
        this.state = {
            groupName: this.convo.getName(),
            oldAvatarPath: this.convo.getAvatarPath(),
            newAvatarObjecturl: null,
        };
    }
    componentDidMount() {
        window.addEventListener('keyup', this.onKeyUp);
    }
    componentWillUnmount() {
        window.removeEventListener('keyup', this.onKeyUp);
    }
    onClickOK() {
        const { groupName, newAvatarObjecturl, oldAvatarPath } = this.state;
        const trimmedGroupName = groupName?.trim();
        if (!trimmedGroupName) {
            this.onShowError(window.i18n('emptyGroupNameError'));
            return;
        }
        if (trimmedGroupName !== this.convo.getName() || newAvatarObjecturl !== oldAvatarPath) {
            if (this.convo.isPublic()) {
                void (0, open_group_1.initiateOpenGroupUpdate)(this.convo.id, trimmedGroupName, {
                    objectUrl: newAvatarObjecturl,
                });
            }
            else {
                const members = this.convo.get('members') || [];
                void (0, closed_group_1.initiateClosedGroupUpdate)(this.convo.id, trimmedGroupName, members);
            }
        }
        this.closeDialog();
    }
    render() {
        const okText = window.i18n('ok');
        const cancelText = window.i18n('cancel');
        const titleText = window.i18n('updateGroupDialogTitle', [this.convo.getName() || 'Unknown']);
        const isAdmin = this.convo.isPublic()
            ? false
            : true;
        return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: titleText, showHeader: true, showExitIcon: false, additionalClassName: "update-group-dialog", okButton: {
                text: okText,
                onClickOkHandler: () => this.onClickOK(),
                color: BchatButton_1.BchatButtonColor.Primary,
                disabled: false,
            }, cancelButton: {
                text: cancelText,
                status: true,
                color: BchatButton_1.BchatButtonColor.Secondary,
                onClickCancelHandler: () => this.closeDialog(),
            } },
            react_1.default.createElement("div", { style: { minWidth: '400px' } },
                this.renderAvatar(),
                react_1.default.createElement(Text_1.SpacerMD, null),
                isAdmin ? (react_1.default.createElement("div", { className: "groupNameBox" },
                    react_1.default.createElement("input", { type: "text", className: "profile-name-input", value: this.state.groupName, placeholder: window.i18n('groupNamePlaceholder'), onChange: this.onGroupNameChanged, tabIndex: 0, required: true, "aria-required": true, autoFocus: true, "data-testid": "group-name-input" }),
                    react_1.default.createElement(icon_1.BchatIconButton, { onClick: () => this.setState({ groupName: "" }), iconType: 'xWithCircle', iconSize: 24 }),
                    ' ')) : null),
            react_1.default.createElement(Text_1.SpacerLG, null)));
    }
    onShowError(msg) {
        utils_1.ToastUtils.pushToastError('', msg);
    }
    onKeyUp(event) {
        switch (event.key) {
            case 'Enter':
                this.onClickOK();
                break;
            case 'Esc':
            case 'Escape':
                this.closeDialog();
                break;
            default:
        }
    }
    closeDialog() {
        window.removeEventListener('keyup', this.onKeyUp);
        window.inboxStore?.dispatch((0, modalDialog_1.updateGroupNameModal)(null));
    }
    onGroupNameChanged(event) {
        const groupName = event.target.value;
        if (groupName.length <= 26) {
            this.setState(state => {
                return {
                    ...state,
                    groupName,
                };
            });
        }
    }
    renderAvatar() {
        const isPublic = this.convo.isPublic();
        const pubkey = this.convo.id;
        const { newAvatarObjecturl, oldAvatarPath } = this.state;
        if (!isPublic) {
            return undefined;
        }
        return (react_1.default.createElement("div", { className: "avatar-center", style: { marginTop: '15px' } },
            react_1.default.createElement("div", { className: "avatar-center-inner" },
                react_1.default.createElement(Avatar_1.Avatar, { forcedAvatarPath: newAvatarObjecturl || oldAvatarPath, size: Avatar_1.AvatarSize.XL, pubkey: pubkey }),
                react_1.default.createElement("div", { className: "image-upload-section", role: "button", onClick: this.fireInputEvent }))));
    }
    async fireInputEvent() {
        const scaledObjectUrl = await (0, VisualAttachment_1.pickFileForAvatar)();
        if (scaledObjectUrl) {
            this.setState({ newAvatarObjecturl: scaledObjectUrl });
        }
    }
}
exports.UpdateGroupNameDialog = UpdateGroupNameDialog;
