"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatAlertConfirmModal = void 0;
const react_1 = __importStar(require("react"));
const modalDialog_1 = require("../../state/ducks/modalDialog");
const Text_1 = require("../basic/Text");
const BchatButton_1 = require("../basic/BchatButton");
const BchatSpinner_1 = require("../basic/BchatSpinner");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const react_redux_1 = require("react-redux");
const theme_1 = require("../../state/selectors/theme");
const BchatAlertConfirmModal = (props) => {
    const { settings = false, onClickOk, onClickClose, onClickCancel, btndisable } = props;
    const [isLoading, setIsLoading] = (0, react_1.useState)(false);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const onClickOkHandler = async () => {
        if (onClickOk) {
            setIsLoading(true);
            try {
                await onClickOk();
            }
            catch (e) {
                window.log.warn(e);
            }
            finally {
                setIsLoading(false);
            }
        }
    };
    const onClickCancelHandler = () => {
        if (onClickCancel) {
            onClickCancel();
        }
        if (onClickClose) {
            onClickClose();
        }
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
    };
    return (react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: '', onClose: onClickClose, showExitIcon: false, showHeader: false, okButton: {
            text: window.i18n('ok'),
            onClickOkHandler,
            color: BchatButton_1.BchatButtonColor.Primary,
            disabled: btndisable ? btndisable : false
        }, cancelButton: {
            text: window.i18n('cancel'),
            status: true,
            color: BchatButton_1.BchatButtonColor.Secondary,
            onClickCancelHandler
        } },
        react_1.default.createElement("div", { className: "bchat-modal__centered" },
            react_1.default.createElement("div", { className: "bchat-modal-imgConfirmBox" },
                react_1.default.createElement("img", { src: darkMode ? 'images/bchat/walletinchat.svg' : 'images/bchat/Pay_as_you_chat_white.svg', width: '50px', height: '50px' }),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement("div", { className: "bchat-modal-imgConfirmBox-header" }, window.i18n('payYouChat')),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement("div", { className: "bchat-modal-imgConfirmBox-message" }, settings ? (window.i18n('warningWalletPassword')) : (react_1.default.createElement(react_1.default.Fragment, null,
                    "Enable pay as you chat from ",
                    react_1.default.createElement("span", null, "Settings -> Chat -> Pay As You Chat "),
                    "to use this option"))),
                react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: isLoading })))));
};
exports.BchatAlertConfirmModal = BchatAlertConfirmModal;
