"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatIcon = void 0;
const react_1 = __importDefault(require("react"));
const _1 = require(".");
const styled_components_1 = __importStar(require("styled-components"));
const getIconDimensionFromIconSize = (iconSize) => {
    if (typeof iconSize === 'number') {
        return iconSize;
    }
    else {
        switch (iconSize) {
            case 'tiny':
                return 12;
            case 'small':
                return 15;
            case 'medium':
                return 18;
            case 'large':
                return 22;
            case 'huge':
                return 30;
            case 'huge2':
                return 40;
            case 'max':
                return 80;
            default:
                return 20;
        }
    }
};
const rotate = (0, styled_components_1.keyframes) `
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(360deg);
  }
`;
const glow = (color, glowDuration, glowStartDelay) => {
    const dropShadow = `drop-shadow(0px 0px 6px ${color});`;
    let kf = '';
    const durationWithLoop = glowDuration + 1;
    for (let i = 0; i <= durationWithLoop; i++) {
        const percent = (100 / durationWithLoop) * i;
        if (i === glowStartDelay + 1) {
            kf += `${percent}% {
        filter: ${dropShadow}
        transform: scale(1.1);
      }`;
        }
        else {
            kf += `${percent}% {
        filter: none;
        transform: scale(0.9);
      }`;
        }
    }
    return (0, styled_components_1.keyframes) `${kf}`;
};
const animation = (props) => {
    if (props.rotateDuration) {
        return (0, styled_components_1.css) `
      ${rotate} ${props.rotateDuration}s infinite linear;
    `;
    }
    if (props.noScale) {
        return (0, styled_components_1.css) ``;
    }
    if (props.glowDuration !== undefined && props.glowStartDelay !== undefined && props.iconColor) {
        return (0, styled_components_1.css) `
      ${glow(props.iconColor, props.glowDuration, props.glowStartDelay)} ${props.glowDuration}s ease infinite;
    `;
    }
    return;
};
const Svg = react_1.default.memo(styled_components_1.default.svg `
  width: ${props => props.width};
  transform: ${props => `rotate(${props.iconRotation}deg)`};
  animation: ${props => animation(props)};
  border-radius: ${props => props.borderRadius};
  background-color: ${props => (props.backgroundColor ? props.backgroundColor : '')};
  border-radius: ${props => (props.borderRadius ? props.borderRadius : '')};
  filter: ${props => (props.noScale ? `drop-shadow(0px 0px 4px ${props.iconColor})` : '')};
  padding: ${props => (props.iconPadding ? props.iconPadding : '')};
`);
const BchatSvg = (props) => {
    const colorSvg = props.strokeColor ? 'none' : props.iconColor;
    const pathArray = props.path instanceof Array ? props.path : [props.path];
    const rules = props.fillRule ? {
        fillRule: props.fillRule,
        clipRule: props.clipRule || "inherit"
    } : {};
    const strokeDetails = props.strokeColor ? {
        stroke: props.strokeColor,
        strokeWidth: props.strokeWidth
    } : {};
    const propsToPick = {
        width: props.width,
        height: props.height,
        rotateDuration: props.rotateDuration,
        iconRotation: props.iconRotation,
        viewBox: props.viewBox,
        glowDuration: props.glowDuration,
        glowStartDelay: props.glowStartDelay,
        iconColor: props.iconColor,
        noScale: props.noScale,
        backgroundColor: props.backgroundColor,
        borderRadius: props.borderRadius,
        iconPadding: props.iconPadding,
    };
    return (react_1.default.createElement(Svg, { ...propsToPick }, pathArray.map((path, index) => {
        return react_1.default.createElement("path", { key: index, fill: colorSvg, d: path, ...rules, ...strokeDetails });
    })));
};
const BchatIcon = (props) => {
    const { iconType, iconColor, rotateDuration, glowDuration, borderRadius, glowStartDelay, noScale, backgroundColor, iconPadding, fillRule, clipRule, strokeColor, strokeWidth } = props;
    let { iconSize, iconRotation } = props;
    iconSize = iconSize || 'medium';
    iconRotation = iconRotation || 0;
    const iconDimensions = getIconDimensionFromIconSize(iconSize);
    const iconDef = _1.icons[iconType];
    const ratio = iconDef?.ratio || 1;
    return (react_1.default.createElement(BchatSvg, { viewBox: iconDef.viewBox, path: iconDef.path, width: iconDimensions * ratio, height: iconDimensions, rotateDuration: rotateDuration, glowDuration: glowDuration, glowStartDelay: glowStartDelay, noScale: noScale, borderRadius: borderRadius, iconRotation: iconRotation, iconColor: iconColor, backgroundColor: backgroundColor, iconPadding: iconPadding, fillRule: fillRule, clipRule: clipRule, strokeColor: strokeColor, strokeWidth: strokeWidth }));
};
exports.BchatIcon = BchatIcon;
