"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatNotificationCount = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const StyledCountContainer = styled_components_1.default.div `
  position: absolute;
  width: 20px;
  height: 20px;
  font-size: 18px;
  top: -4px;
  left: 17px;
  padding: 7px;
  opacity: 1;
  display: flex;
  align-items: center;
  justify-content: center;
  font-family: var(--font-default);
  border-radius: 50%;
  font-weight: 700;
  background: var(--color-destructive);
  transition: var(--default-duration);
  opacity: ${props => (props.shouldRender ? 1 : 0)};
  text-align: center;
  color: white;
  /* cursor:  */
`;
const StyledCount = styled_components_1.default.div `
  position: relative;
  font-size: ${props => (props.countOverflow ? '0.5em' : '0.6em')};
  margin-top: ${props => (props.countOverflow ? '0.35em' : '0em')};
  margin-left: ${props => (props.countOverflow ? '-0.45em' : '0em')};
`;
const StyledCountSup = styled_components_1.default.div `
  position: absolute;
  font-size: 1.3em;
  top: -0.5em;
  margin-inline-start: 0.375em;
`;
const BchatNotificationCount = (props) => {
    const { count } = props;
    const overflow = Boolean(count && count > 9);
    const shouldRender = Boolean(count && count > 0);
    if (overflow) {
        return (react_1.default.createElement(StyledCountContainer, { shouldRender: shouldRender },
            react_1.default.createElement(StyledCount, { countOverflow: overflow },
                9,
                react_1.default.createElement(StyledCountSup, null, "+"))));
    }
    return (react_1.default.createElement(StyledCountContainer, { shouldRender: shouldRender },
        react_1.default.createElement(StyledCount, { countOverflow: overflow }, count)));
};
exports.BchatNotificationCount = BchatNotificationCount;
