"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CopyIconButton = void 0;
const classnames_1 = __importDefault(require("classnames"));
const electron_1 = require("electron");
const react_1 = __importDefault(require("react"));
const Toast_1 = require("../../bchat/utils/Toast");
const lodash_1 = __importDefault(require("lodash"));
const CopyIconButtonInner = react_1.default.forwardRef((props, ref) => {
    const { iconSize, isHidden, content, margin, id, dataTestId, } = props;
    const handleCopy = () => {
        electron_1.clipboard.writeText(content, 'clipboard');
        (0, Toast_1.pushUserCopySuccess)();
    };
    const clickHandler = (e) => {
        if (props.onClick) {
            e.stopPropagation();
            handleCopy();
            props.onClick(e);
        }
    };
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-icon-button', iconSize), role: "button", ref: ref, id: id, onClick: clickHandler, style: { display: isHidden ? 'none' : 'flex', margin: margin ? margin : '', alignItems: "center" }, "data-testid": dataTestId },
        react_1.default.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", width: iconSize, height: iconSize, viewBox: "0 0 20 22", fill: "none" },
            react_1.default.createElement("path", { d: "M14.0249 12.2832V15.0332C14.0249 18.6998 12.7049 20.1665 9.4049 20.1665H6.2699C2.9699 20.1665 1.6499 18.6998 1.6499 15.0332V11.5498C1.6499 7.88317 2.9699 6.4165 6.2699 6.4165H8.7449", stroke: "#00A638", strokeWidth: "1.5", strokeLinecap: "round", strokeLinejoin: "round" }),
            react_1.default.createElement("path", { d: "M14.0251 12.2832H11.3851C9.40512 12.2832 8.74512 11.5498 8.74512 9.34984V6.4165L14.0251 12.2832Z", stroke: "#00A638", strokeWidth: "1.5", strokeLinecap: "round", strokeLinejoin: "round" }),
            react_1.default.createElement("path", { d: "M9.56982 1.8335H12.8698", stroke: "#00A638", strokeWidth: "1.5", strokeLinecap: "round", strokeLinejoin: "round" }),
            react_1.default.createElement("path", { d: "M5.7749 4.5835C5.7749 3.06183 6.8804 1.8335 8.2499 1.8335H10.4114", stroke: "#00A638", strokeWidth: "1.5", strokeLinecap: "round", strokeLinejoin: "round" }),
            react_1.default.createElement("path", { d: "M18.1498 7.3335V13.0077C18.1498 14.4285 17.1103 15.5835 15.8315 15.5835", stroke: "#00A638", strokeWidth: "1.5", strokeLinecap: "round", strokeLinejoin: "round" }),
            react_1.default.createElement("path", { d: "M18.1502 7.3335H15.6752C13.8189 7.3335 13.2002 6.646 13.2002 4.5835V1.8335L18.1502 7.3335Z", stroke: "#00A638", strokeWidth: "1.5", strokeLinecap: "round", strokeLinejoin: "round" }))));
});
exports.CopyIconButton = react_1.default.memo(CopyIconButtonInner, lodash_1.default.isEqual);
