"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomIconButton = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const lodash_1 = __importDefault(require("lodash"));
const CustomIconButtonInner = react_1.default.forwardRef((props, ref) => {
    const clickHandler = (e) => {
        if (props.onClick) {
            e.stopPropagation();
            props.onClick(e);
        }
    };
    const style = { ...props.style ?? {} };
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-icon-button', props.className), role: "button", ref: ref, onClick: clickHandler, style: style }, props.customIcon));
});
exports.CustomIconButton = react_1.default.memo(CustomIconButtonInner, lodash_1.default.isEqual);
