"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionsPanel = exports.BchatToolTip = void 0;
const react_1 = __importStar(require("react"));
const conversations_1 = require("../../bchat/conversations");
const syncUtils_1 = require("../../bchat/utils/syncUtils");
const data_1 = require("../../data/data");
const sending_1 = require("../../bchat/sending");
const react_redux_1 = require("react-redux");
const useInterval_1 = __importDefault(require("react-use/lib/useInterval"));
const useTimeoutFn_1 = __importDefault(require("react-use/lib/useTimeoutFn"));
const user_1 = require("../../state/selectors/user");
const conversations_2 = require("../../state/selectors/conversations");
const theme_1 = require("../../state/ducks/theme");
const section_1 = require("../../state/selectors/section");
const section_2 = require("../../state/ducks/section");
const DecryptedAttachmentsManager_1 = require("../../bchat/crypto/DecryptedAttachmentsManager");
const constants_1 = require("../../bchat/constants");
const conversations_3 = require("../../state/ducks/conversations");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const ModalContainer_1 = require("../dialog/ModalContainer");
const lodash_1 = require("lodash");
const BchatTheme_1 = require("../../state/ducks/BchatTheme");
const ApiUtil_1 = require("../../bchat/apis/open_group_api/opengroupV2/ApiUtil");
const OpenGroupManagerV2_1 = require("../../bchat/apis/open_group_api/opengroupV2/OpenGroupManagerV2");
const snode_api_1 = require("../../bchat/apis/snode_api");
const snodePool_1 = require("../../bchat/apis/snode_api/snodePool");
const Avatar_1 = require("../avatar/Avatar");
const CallInFullScreenContainer_1 = require("../calling/CallInFullScreenContainer");
const DraggableCallContainer_1 = require("../calling/DraggableCallContainer");
const IncomingCallDialog_1 = require("../calling/IncomingCallDialog");
const icon_1 = require("../icon");
const BchatToastContainer_1 = require("../BchatToastContainer");
const LeftPaneSectionContainer_1 = require("./LeftPaneSectionContainer");
const FileServerApiV2_1 = require("../../bchat/apis/file_server_api/FileServerApiV2");
const electron_1 = require("electron");
const utils_1 = require("../../bchat/utils");
const storage_1 = require("../../util/storage");
const settings_key_1 = require("../../data/settings-key");
const classnames_1 = __importDefault(require("classnames"));
const react_tooltip_1 = __importDefault(require("react-tooltip"));
const BchatSettings_1 = require("../settings/BchatSettings");
const search_1 = require("../../state/ducks/search");
const walletConfig_1 = require("../../state/selectors/walletConfig");
const walletConfig_2 = require("../../state/ducks/walletConfig");
const User_1 = require("../../bchat/utils/User");
const onions_1 = require("../../state/selectors/onions");
const styled_components_1 = __importDefault(require("styled-components"));
const OnionStatusPathDialog_1 = require("../dialog/OnionStatusPathDialog");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const useNetworkStatus_1 = __importDefault(require("../../hooks/useNetworkStatus"));
const theme_2 = require("../../state/selectors/theme");
const NewChatIcon_1 = __importDefault(require("../icon/NewChatIcon"));
const SecretGrpIcon_1 = __importDefault(require("../icon/SecretGrpIcon"));
const SocialGrpIcon_1 = __importDefault(require("../icon/SocialGrpIcon"));
const SubMenuConnect_1 = __importDefault(require("../icon/SubMenuConnect"));
const callHistory_1 = require("../../state/ducks/callHistory");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const Section = (props) => {
    const ourNumber = (0, react_redux_1.useSelector)(user_1.getOurNumber);
    const unreadMessageCount = (0, react_redux_1.useSelector)(conversations_2.getUnreadMessageCount);
    const dispatch = (0, react_redux_1.useDispatch)();
    const { type, isHiddenSubMenus, setIsHiddenSubMenus } = props;
    const focusedSection = (0, react_redux_1.useSelector)(section_1.getFocusedSection);
    const walletPasswordPopUp = (0, react_redux_1.useSelector)(walletConfig_1.getWalletPasswordPopUpFlag);
    const isSelected = focusedSection === props.type;
    const darkMode = (0, react_redux_1.useSelector)(theme_2.getTheme) === 'dark';
    const handleClick = async (subTypes) => {
        dispatch((0, conversations_3.closeRightPanel)());
        if (type === section_2.SectionType.Profile) {
            dispatch((0, modalDialog_1.editProfileModal)({}));
        }
        else if (subTypes === section_2.SectionType.SubMenu) {
            setIsHiddenSubMenus(false);
        }
        else if (type === section_2.SectionType.Moon) {
            const themeFromSettings = window.Events.getThemeSetting();
            const updatedTheme = themeFromSettings === 'dark' ? 'light' : 'dark';
            window.setTheme(updatedTheme);
            if (updatedTheme === 'dark') {
                (0, BchatTheme_1.switchHtmlToDarkTheme)();
            }
            else {
                (0, BchatTheme_1.switchHtmlToLightTheme)();
            }
            const newThemeObject = updatedTheme === 'dark' ? 'dark' : 'light';
            dispatch((0, theme_1.applyTheme)(newThemeObject));
        }
        else if (subTypes === section_2.SectionType.NewChat) {
            setIsHiddenSubMenus(!isHiddenSubMenus);
            dispatch((0, section_2.showLeftPaneSection)(1));
            dispatch((0, section_2.setOverlayMode)('message'));
        }
        else if (subTypes === section_2.SectionType.Closedgroup) {
            setIsHiddenSubMenus(!isHiddenSubMenus);
            dispatch((0, section_2.showLeftPaneSection)(2));
            dispatch((0, section_2.setOverlayMode)('closed-group'));
        }
        else if (subTypes === section_2.SectionType.Opengroup) {
            setIsHiddenSubMenus(!isHiddenSubMenus);
            dispatch((0, section_2.showLeftPaneSection)(3));
            dispatch((0, section_2.setOverlayMode)('open-group'));
        }
        else if (type === section_2.SectionType.CallHistory) {
            (0, callHistory_1.openCallHistory)();
            dispatch((0, section_2.showLeftPaneSection)(type));
            dispatch((0, section_2.setOverlayMode)('call-history'));
        }
        else if (type === section_2.SectionType.Wallet) {
            let emptyAddress = '';
            dispatch((0, section_2.showLeftPaneSection)(type));
            dispatch((0, section_2.setOverlayMode)('wallet'));
            dispatch((0, section_2.showSettingsSection)(BchatSettings_1.BchatSettingCategory.Wallet));
            dispatch((0, walletConfig_2.updateSendAddress)(emptyAddress));
            if (walletPasswordPopUp) {
                dispatch((0, modalDialog_1.updateBchatWalletPasswordModal)({ from: 'wallet' }));
            }
        }
        else if (type === section_2.SectionType.Settings) {
            dispatch((0, section_2.showLeftPaneSection)(type));
            dispatch((0, section_2.setOverlayMode)(undefined));
        }
        else {
            dispatch((0, search_1.clearSearch)());
            dispatch((0, section_2.setOverlayMode)(undefined));
            dispatch((0, section_2.showLeftPaneSection)(type));
        }
    };
    if (type === section_2.SectionType.Profile) {
        return (react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.XS, onAvatarClick: handleClick, pubkey: ourNumber, dataTestId: "leftpane-primary-avatar" }));
    }
    const unreadToShow = type === section_2.SectionType.Message ? unreadMessageCount : undefined;
    switch (type) {
        case section_2.SectionType.Message:
            return (react_1.default.createElement("div", { className: (0, classnames_1.default)(isSelected ? 'isSelected-icon-box' : 'icon-box') },
                react_1.default.createElement("div", { className: "btnView", onClick: () => handleClick() },
                    react_1.default.createElement(icon_1.BchatIcon, { iconSize: 31, iconType: 'chatBubble' }),
                    unreadMessageCount !== 0 ? (react_1.default.createElement("div", { className: "unreadCountChatIcon" }, unreadMessageCount <= 99 ? unreadToShow : react_1.default.createElement("span", null, "99+"))) : null),
                react_1.default.createElement("section", { className: "d-visiblity " },
                    react_1.default.createElement(DisplayTitle, { title: "All Chats", top: '186px' }))));
        case section_2.SectionType.NewChat:
            const isFocused = focusedSection === section_2.SectionType.NewChat ||
                focusedSection === section_2.SectionType.Closedgroup ||
                focusedSection === section_2.SectionType.Opengroup;
            return (react_1.default.createElement("div", { className: (0, classnames_1.default)(isFocused ? 'isSelected-icon-box' : 'icon-box', !isHiddenSubMenus && 'icon-colored-box'), onMouseOver: () => setIsHiddenSubMenus(false), onMouseLeave: () => {
                    setIsHiddenSubMenus(true);
                } },
                react_1.default.createElement("div", { className: "btnView", onClick: () => handleClick(section_2.SectionType.SubMenu) },
                    react_1.default.createElement(icon_1.BchatIcon, { iconSize: 31, iconType: 'newChat' })),
                react_1.default.createElement("div", null,
                    react_1.default.createElement(Flex_1.Flex, { container: true, className: (0, classnames_1.default)('sub-menu-box-wrapper', isHiddenSubMenus && 'sub-menu-box-wrapper-disabled') },
                        react_1.default.createElement(MarginedDiv, null,
                            react_1.default.createElement(SubMenuConnect_1.default, null)),
                        react_1.default.createElement("div", { className: 'sub-menu-box' },
                            react_1.default.createElement(SubMenuList, { container: true, padding: "17px", onClick: () => handleClick(section_2.SectionType.NewChat), isSelected: focusedSection === section_2.SectionType.NewChat },
                                react_1.default.createElement(NewChatIcon_1.default, null),
                                react_1.default.createElement(Text_1.SpacerMD, null),
                                " ",
                                react_1.default.createElement("div", { className: "menu-txt" }, "New Chat")),
                            react_1.default.createElement(Text_1.SpacerMD, null),
                            react_1.default.createElement(SubMenuList, { container: true, padding: "17px", onClick: () => handleClick(section_2.SectionType.Closedgroup), isSelected: focusedSection === section_2.SectionType.Closedgroup },
                                react_1.default.createElement(SecretGrpIcon_1.default, null),
                                react_1.default.createElement(Text_1.SpacerMD, null),
                                " ",
                                react_1.default.createElement("div", { className: "menu-txt" }, "Secret Group")),
                            react_1.default.createElement(Text_1.SpacerMD, null),
                            react_1.default.createElement(SubMenuList, { container: true, padding: "17px", onClick: () => handleClick(section_2.SectionType.Opengroup), isSelected: focusedSection === section_2.SectionType.Opengroup },
                                react_1.default.createElement(SocialGrpIcon_1.default, null),
                                react_1.default.createElement(Text_1.SpacerMD, null),
                                " ",
                                react_1.default.createElement("div", { className: "menu-txt" }, "Social Group"),
                                ' '))))));
            { }
        case section_2.SectionType.Wallet:
            return (react_1.default.createElement("div", { className: (0, classnames_1.default)(isSelected ? 'isSelected-icon-box' : 'icon-box') },
                react_1.default.createElement("div", { className: "btnView", onClick: () => handleClick(), style: { flexDirection: 'column' } },
                    react_1.default.createElement(icon_1.BchatIcon, { iconSize: 31, iconType: 'wallet' }),
                    react_1.default.createElement(Beta, null,
                        react_1.default.createElement(icon_1.BchatIcon, { iconSize: 34, iconType: 'beta', clipRule: "evenodd", fillRule: "evenodd", iconColor: darkMode ? '#A7A7BA' : '#ACACAC' }))),
                react_1.default.createElement("section", { className: "d-visiblity " },
                    react_1.default.createElement(DisplayTitle, { title: "Wallet", top: '278px' }))));
        case section_2.SectionType.Settings:
            return (react_1.default.createElement("div", { className: (0, classnames_1.default)(isSelected ? 'isSelected-icon-box' : 'icon-box') },
                react_1.default.createElement("div", { className: "btnView", onClick: () => handleClick() },
                    react_1.default.createElement(icon_1.BchatIcon, { iconSize: 31, iconType: 'gear' })),
                react_1.default.createElement("section", { className: "d-visiblity " },
                    react_1.default.createElement(DisplayTitle, { title: "Settings", top: '370px' }))));
        default:
            return null;
    }
};
const cleanUpMediasInterval = constants_1.DURATION.MINUTES * 60;
const fetchReleaseFromFileServerInterval = 1000 * 60;
const setupTheme = () => {
    const theme = window.Events.getThemeSetting();
    window.setTheme(theme);
    if (theme === 'dark') {
        (0, BchatTheme_1.switchHtmlToDarkTheme)();
    }
    else {
        (0, BchatTheme_1.switchHtmlToLightTheme)();
    }
    const newThemeObject = theme === 'dark' ? 'dark' : 'light';
    window?.inboxStore?.dispatch((0, theme_1.applyTheme)(newThemeObject));
};
const triggerSyncIfNeeded = async () => {
    await (0, conversations_1.getConversationController)()
        .get(utils_1.UserUtils.getOurPubKeyStrFromCache())
        .setDidApproveMe(true, true);
    const didWeHandleAConfigurationMessageAlready = (await (0, data_1.getItemById)(data_1.hasSyncedInitialConfigurationItem))?.value || false;
    if (didWeHandleAConfigurationMessageAlready) {
        await (0, syncUtils_1.syncConfigurationIfNeeded)();
    }
};
const removeAllV1OpenGroups = async () => {
    const allV1Convos = (await (0, data_1.getAllOpenGroupV1Conversations)()).models || [];
    for (let index = 0; index < allV1Convos.length; index++) {
        const v1Convo = allV1Convos[index];
        try {
            await (0, data_1.removeConversation)(v1Convo.id);
            window.log.info(`deleting v1convo : ${v1Convo.id}`);
            (0, conversations_1.getConversationController)().unsafeDelete(v1Convo);
            if (window.inboxStore) {
                window.inboxStore?.dispatch((0, conversations_3.conversationRemoved)(v1Convo.id));
                window.inboxStore?.dispatch((0, conversations_3.conversationChanged)({ id: v1Convo.id, data: v1Convo.getConversationModelProps() }));
            }
        }
        catch (e) {
            window.log.warn(`failed to delete opengroupv1 ${v1Convo.id}`, e);
        }
    }
};
const triggerAvatarReUploadIfNeeded = async () => {
    const lastTimeStampAvatarUpload = (await (0, data_1.getItemById)(data_1.lastAvatarUploadTimestamp))?.value || 0;
    if (Date.now() - lastTimeStampAvatarUpload > constants_1.DURATION.DAYS * 14) {
        window.log.info('Reuploading avatar...');
        await (0, conversationInteractions_1.uploadOurAvatar)();
    }
};
const doAppStartUp = () => {
    void (0, sending_1.getMessageQueue)().processAllPending();
    void setupTheme();
    void removeAllV1OpenGroups();
    void (0, data_1.generateAttachmentKeyIfEmpty)();
    void (0, OpenGroupManagerV2_1.getOpenGroupManager)().startPolling();
    void triggerSyncIfNeeded();
    void (0, snode_api_1.getSwarmPollingInstance)().start();
    void (0, ApiUtil_1.loadDefaultRooms)();
    (0, lodash_1.debounce)(triggerAvatarReUploadIfNeeded, 200);
    void askEnablingOpengroupPruningIfNeeded();
};
const CallContainer = () => {
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DraggableCallContainer_1.DraggableCallContainer, null),
        react_1.default.createElement(IncomingCallDialog_1.IncomingCallDialog, null),
        react_1.default.createElement(CallInFullScreenContainer_1.CallInFullScreenContainer, null)));
};
async function fetchReleaseFromFSAndUpdateMain() {
    try {
        window.log.info('[updater] about to fetchReleaseFromFSAndUpdateMain');
        const latest = await (0, FileServerApiV2_1.getLatestDesktopReleaseFileToFsV2)();
        window.log.info('[updater] fetched latest release from fsv2: ', latest);
        if ((0, lodash_1.isString)(latest) && !(0, lodash_1.isEmpty)(latest)) {
            electron_1.ipcRenderer.send('set-release-from-file-server', latest);
            window.readyForUpdates();
        }
    }
    catch (e) {
        window.log.warn(e);
    }
}
async function askEnablingOpengroupPruningIfNeeded() {
    if (storage_1.Storage.get(settings_key_1.SettingsKey.settingsOpengroupPruning) === undefined) {
        const setSettingsAndCloseDialog = async (valueToSetPruningTo) => {
            window.setSettingValue(settings_key_1.SettingsKey.settingsOpengroupPruning, valueToSetPruningTo);
            await window.setOpengroupPruning(valueToSetPruningTo);
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
        };
        window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
            onClickOk: async () => {
                await setSettingsAndCloseDialog(true);
            },
            onClickClose: async () => {
                await setSettingsAndCloseDialog(false);
            },
            onClickCancel: async () => {
                await setSettingsAndCloseDialog(false);
            },
            title: window.i18n('pruningSocialgroupDialogTitle'),
            message: window.i18n('pruningSocialgroupDialogMessage'),
            messageSub: window.i18n('pruningSocialgroupDialogSubMessage'),
            okText: window.i18n('enable'),
            cancelText: window.i18n('keepDisabled'),
        }));
        return;
    }
}
const BchatToolTip = (props) => (react_1.default.createElement(react_tooltip_1.default, { className: "tooltipDesign", delayShow: 500, place: props.place, effect: props.effect }));
exports.BchatToolTip = BchatToolTip;
const DisplayTitle = (props) => (react_1.default.createElement(StyledTitleWrapper, { container: true, alignItems: "center", top: props.top },
    react_1.default.createElement(SubMenuConnect_1.default, null),
    react_1.default.createElement("div", { className: 'sub-menu-box' },
        react_1.default.createElement("div", { className: "menu-txt" }, props.title))));
const ActionsPanel = () => {
    const [startCleanUpMedia, setStartCleanUpMedia] = (0, react_1.useState)(false);
    const [isHiddenSubMenus, setIsHiddenSubMenus] = (0, react_1.useState)(true);
    const ourPrimaryConversation = (0, react_redux_1.useSelector)(User_1.getOurPubKeyStrFromCache);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(ourPrimaryConversation);
    const dispatch = (0, react_redux_1.useDispatch)();
    const pathCon = (0, react_redux_1.useSelector)(onions_1.getIsOnline);
    const isOnline = (0, useNetworkStatus_1.default)();
    const darkMode = (0, react_redux_1.useSelector)(theme_2.getTheme) === 'dark';
    const imgsrc = darkMode
        ? 'images/bchat/connect_wallet_dark.gif'
        : 'images/bchat/connect_wallet_white.gif';
    (0, react_1.useEffect)(() => {
        void doAppStartUp();
    }, []);
    (0, react_1.useEffect)(() => {
        const timeout = setTimeout(() => setStartCleanUpMedia(true), cleanUpMediasInterval);
        return () => clearTimeout(timeout);
    }, []);
    (0, useInterval_1.default)(DecryptedAttachmentsManager_1.cleanUpOldDecryptedMedias, startCleanUpMedia ? cleanUpMediasInterval : null);
    (0, useInterval_1.default)(() => {
        void fetchReleaseFromFSAndUpdateMain();
    }, fetchReleaseFromFileServerInterval);
    if (!ourPrimaryConversation) {
        window?.log?.warn('ActionsPanel: ourPrimaryConversation is not set');
        return null;
    }
    (0, useInterval_1.default)(() => {
        void (0, syncUtils_1.syncConfigurationIfNeeded)();
    }, constants_1.DURATION.DAYS * 2);
    (0, useInterval_1.default)(() => {
        void (0, snodePool_1.forceRefreshRandomSnodePool)();
    }, constants_1.DURATION.HOURS * 1);
    (0, useTimeoutFn_1.default)(() => {
        void (0, snodePool_1.forceRefreshRandomSnodePool)();
    }, constants_1.DURATION.MINUTES * 5);
    (0, useInterval_1.default)(() => {
        void triggerAvatarReUploadIfNeeded();
    }, constants_1.DURATION.DAYS * 1);
    const themeChanger = (theme) => {
        const themeFromSettings = window.Events.getThemeSetting();
        window.setTheme(theme);
        dispatch((0, theme_1.applyTheme)(theme));
        if (themeFromSettings !== theme) {
            if (theme === 'dark') {
                (0, BchatTheme_1.switchHtmlToDarkTheme)();
            }
            else {
                (0, BchatTheme_1.switchHtmlToLightTheme)();
            }
        }
    };
    const IsOnline = () => {
        const isOnline = (0, react_redux_1.useSelector)(onions_1.getIsOnline);
        const status = isOnline ? 'Online' : 'Offline';
        return (react_1.default.createElement(Hops, { "data-tip": status, "data-offset": "{'right':30}", "data-place": "bottom" },
            react_1.default.createElement(OnionStatusPathDialog_1.ActionPanelOnionStatusLight, { isSelected: false, handleClick: () => { }, id: '', size: "small" })));
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(ModalContainer_1.ModalContainer, null),
        react_1.default.createElement(CallContainer, null),
        react_1.default.createElement(LeftPaneSectionContainer_1.LeftPaneSectionContainer, { "data-testid": "leftpane-section-container" },
            react_1.default.createElement("div", { className: "profile-box", style: { marginTop: '10px', height: '60px', position: 'relative' } },
                react_1.default.createElement(IsOnline, null),
                react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.L, onAvatarClick: () => dispatch((0, modalDialog_1.editProfileModal)({})), pubkey: (0, User_1.getOurPubKeyStrFromCache)(), dataTestId: "leftpane-primary-avatar", isBnsHolder: isBnsHolder })),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement("div", { style: { overflow: 'auto', width: '65%', height: 'calc(100vh - 250px)' } },
                react_1.default.createElement(Section, { type: section_2.SectionType.NewChat, isHiddenSubMenus: isHiddenSubMenus, setIsHiddenSubMenus: (e) => setIsHiddenSubMenus(e) }),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement(Section, { type: section_2.SectionType.Message }),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement(Section, { type: section_2.SectionType.Wallet }),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement(Section, { type: section_2.SectionType.Settings })),
            react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "flex-end" },
                react_1.default.createElement("div", { className: "theme-Wrapper " },
                    react_1.default.createElement("div", { className: (0, classnames_1.default)('icon-wrapper', !darkMode && 'selected'), onClick: () => themeChanger('light') },
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: 'sun', iconSize: 24, iconColor: darkMode ? '#F0F0F0' : '#333333' })),
                    react_1.default.createElement("div", { className: (0, classnames_1.default)('icon-wrapper', darkMode && 'selected'), onClick: () => themeChanger('dark') },
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: 'moon', iconSize: 24, iconColor: darkMode ? '#F0F0F0' : '#A7A7BA' })))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "appVersion" },
                "V ",
                window.getVersion()),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement(exports.BchatToolTip, { effect: "solid" }),
            react_1.default.createElement(BchatToastContainer_1.BchatToastContainer, null),
            react_1.default.createElement(NetWorkStatusWrapper, null,
                !isOnline && !pathCon && (react_1.default.createElement("div", { className: "offline-msg" },
                    react_1.default.createElement(icon_1.BchatIcon, { iconType: 'warning', iconSize: 'huge', iconColor: '#FF3C3C' }),
                    react_1.default.createElement("span", { className: "txt" }, "You are not connected to the Hop. Check your internet connection or Restart the app!"))),
                !pathCon && isOnline && (react_1.default.createElement("div", { className: "offline-msg connection-Wrapper " },
                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center", width: "350px", justifyContent: "space-between" },
                        react_1.default.createElement("div", { style: { display: 'flex', flexDirection: 'row' } },
                            react_1.default.createElement("div", { className: "dotIcon" },
                                react_1.default.createElement(icon_1.BchatIcon, { iconSize: 'small', iconType: "circle" })),
                            react_1.default.createElement("div", null, "Connecting..")),
                        react_1.default.createElement("div", null,
                            react_1.default.createElement("img", { src: imgsrc, style: { width: '30px', height: '30px', display: 'flex' } })))))))));
};
exports.ActionsPanel = ActionsPanel;
const Hops = styled_components_1.default.div `
  position: absolute;
  right: -7px;
  top: -4px;
  z-index: 1;
  border: 4px solid var(--color-inbox-background);
  border-radius: 40px;
`;
const NetWorkStatusWrapper = styled_components_1.default.div `
  position: absolute;
  bottom: 10px;
  width: 338px;
  left: 141px;
  z-index: 99;
`;
const Beta = styled_components_1.default.div `
  svg {
    height: 14px !important;
  }
`;
const MarginedDiv = styled_components_1.default.div `
  margin-top: 30px;
`;
const SubMenuList = (0, styled_components_1.default)(Flex_1.Flex) `
  ${props => props.isSelected && 'background-color: var(--color-hop-bg);'}
  cursor:pointer;
  border-radius: 16px;
  &:hover {
    background-color: var(--color-theme-selected-bg);
  }
`;
const StyledTitleWrapper = (0, styled_components_1.default)(Flex_1.Flex) `
  position: fixed;
  left: 102px;
  top: ${props => props.top};
  z-index: 9;
  .sub-menu-box {
    padding: 21px 25px;
    background-color: var(--color-modal-bg);
    border-radius: 16px;
  }
`;
