"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactListItem = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const useParamSelector_1 = require("../../hooks/useParamSelector");
const Avatar_1 = require("../avatar/Avatar");
const Emojify_1 = require("../conversation/Emojify");
const AvatarItem = (props) => {
    const { pubkey } = props;
    return react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.S, pubkey: pubkey });
};
const ContactListItem = (props) => {
    const { onClick, pubkey } = props;
    const name = (0, useParamSelector_1.useConversationUsername)(pubkey);
    const isMe = (0, useParamSelector_1.useIsMe)(pubkey);
    const isGroup = !(0, useParamSelector_1.useIsPrivate)(pubkey);
    const title = name ? name : pubkey;
    const displayName = isMe ? window.i18n('you') : title;
    return (react_1.default.createElement("div", { role: "button", onClick: onClick, className: (0, classnames_1.default)('module-contact-list-item', onClick ? 'module-contact-list-item--with-click-handler' : null) },
        react_1.default.createElement(AvatarItem, { pubkey: pubkey }),
        react_1.default.createElement("div", { className: "module-contact-list-item__text" },
            react_1.default.createElement("div", { className: "module-contact-list-item__text__name" },
                react_1.default.createElement(Emojify_1.Emojify, { text: displayName, sizeClass: "small", isGroup: isGroup })))));
};
exports.ContactListItem = ContactListItem;
