"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeftPaneMessageSection = void 0;
const react_1 = __importDefault(require("react"));
const ConversationListItem_1 = require("./conversation-list-item/ConversationListItem");
const SearchResults_1 = require("../search/SearchResults");
const auto_bind_1 = __importDefault(require("auto-bind"));
const MessageRequestsBanner_1 = require("./MessageRequestsBanner");
const BchatSearchInput_1 = require("../BchatSearchInput");
const OverlayOpenGroup_1 = require("./overlay/OverlayOpenGroup");
const OverlayMessageRequest_1 = require("./overlay/OverlayMessageRequest");
const OverlayMessage_1 = require("./overlay/OverlayMessage");
const OverlayClosedGroup_1 = require("./overlay/OverlayClosedGroup");
const section_1 = require("../../state/ducks/section");
const Text_1 = require("../basic/Text");
const classnames_1 = __importDefault(require("classnames"));
class LeftPaneMessageSection extends react_1.default.Component {
    constructor(props) {
        super(props);
        (0, auto_bind_1.default)(this);
    }
    renderRow = (item, key) => {
        const conversation = item;
        if (!conversation) {
            throw new Error('renderRow: conversations selector returned element containing falsy value.');
        }
        return react_1.default.createElement(ConversationListItem_1.MemoConversationListItemWithDetails, { key: key, ...conversation });
    };
    renderList() {
        const { conversations, searchResults } = this.props;
        if (searchResults) {
            return react_1.default.createElement(SearchResults_1.SearchResults, { ...searchResults });
        }
        if (!conversations) {
            throw new Error('render: must provided conversations if no search results are provided');
        }
        const listKey = 0;
        const list = (react_1.default.createElement("div", { className: "module-left-pane__list", key: listKey }, conversations.map((item, key) => this.renderRow(item, key))));
        return [list];
    }
    render() {
        const { overlayMode } = this.props;
        const { conversations, conversationRequestsUnread, directContact } = this.props;
        const convolen = conversations?.length === 0 && conversationRequestsUnread === 0 && directContact.length === 0;
        return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-left-pane-section-content', convolen && 'd-none') }, overlayMode ? this.renderClosableOverlay() : this.renderConversations()));
    }
    renderConversations() {
        const { searchResults } = this.props;
        return (react_1.default.createElement("div", { className: "module-conversations-list-content" },
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement(BchatSearchInput_1.BchatSearchInput, null),
            !searchResults && (react_1.default.createElement(MessageRequestsBanner_1.MessageRequestsBanner, { handleOnClick: () => {
                    window.inboxStore?.dispatch((0, section_1.setOverlayMode)('message-requests'));
                } })),
            this.renderList()));
    }
    renderClosableOverlay() {
        const { overlayMode } = this.props;
        switch (overlayMode) {
            case 'open-group':
                return react_1.default.createElement(OverlayOpenGroup_1.OverlayOpenGroup, null);
            case 'closed-group':
                return react_1.default.createElement(OverlayClosedGroup_1.OverlayClosedGroup, null);
            case 'message':
                return react_1.default.createElement(OverlayMessage_1.OverlayMessage, null);
            case 'message-requests':
                return react_1.default.createElement(OverlayMessageRequest_1.OverlayMessageRequest, { leftPane: true });
            default:
                return null;
        }
    }
}
exports.LeftPaneMessageSection = LeftPaneMessageSection;
