"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StyledLeftPaneBanner = exports.StyledBannerTitle = exports.LeftPaneBanner = exports.LeftPaneSectionHeader = void 0;
const react_1 = __importStar(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const react_redux_1 = require("react-redux");
const userConfig_1 = require("../../state/ducks/userConfig");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const Flex_1 = require("../basic/Flex");
const section_1 = require("../../state/selectors/section");
const section_2 = require("../../state/ducks/section");
const BchatButton_1 = require("../basic/BchatButton");
const icon_1 = require("../icon");
const storage_1 = require("../../util/storage");
const Avatar_1 = require("../avatar/Avatar");
const user_1 = require("../../state/selectors/user");
const modalDialog_2 = require("../../state/ducks/modalDialog");
const BchatTheme_1 = require("../../state/ducks/BchatTheme");
const ActionsPanel_1 = require("./ActionsPanel");
const theme_1 = require("../../state/ducks/theme");
const search_1 = require("../../state/ducks/search");
const User_1 = require("../../bchat/utils/User");
const useNetworkStatus_1 = __importDefault(require("../../hooks/useNetworkStatus"));
const bnsConfig_1 = require("../../state/selectors/bnsConfig");
const BnsVerification_1 = require("../conversation/BnsVerification");
const onion_1 = require("../../state/ducks/onion");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const LeftPaneSectionHeader = () => {
    const focusedSection = (0, react_redux_1.useSelector)(section_1.getFocusedSection);
    const overlayMode = (0, react_redux_1.useSelector)(section_1.getOverlayMode);
    const bChatId = (0, react_redux_1.useSelector)(user_1.getOurNumber);
    const isOnline = (0, useNetworkStatus_1.default)();
    const dispatch = (0, react_redux_1.useDispatch)();
    let label;
    const isMessageSection = focusedSection === section_2.SectionType.Message;
    const isMessageRequestOverlay = overlayMode === 'message-requests';
    const IsVerifyBnsCalled = (0, react_redux_1.useSelector)(bnsConfig_1.getIsVerifyBnsCalled);
    const showBackButton = isMessageRequestOverlay && isMessageSection;
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)((0, User_1.getOurPubKeyStrFromCache)());
    (0, react_1.useEffect)(() => {
        if (isOnline && !IsVerifyBnsCalled) {
            (0, BnsVerification_1.isLinkedBchatIDWithBnsForDeamon)();
        }
        if (!isOnline) {
            clearStatus();
        }
    }, [isOnline]);
    const clearStatus = async () => {
        window.inboxStore?.dispatch((0, onion_1.updateIsOnline)(false));
    };
    switch (focusedSection) {
        case section_2.SectionType.Contact:
            label = window.i18n('contactsHeader');
            break;
        case section_2.SectionType.Settings:
            label = window.i18n('settingsHeader');
            break;
        case section_2.SectionType.Wallet:
            label = window.i18n('wallet');
            break;
        case section_2.SectionType.Message:
            label = isMessageRequestOverlay
                ? window.i18n('messageRequests')
                :
                    'BChat';
            break;
        default:
            label = 'BChat';
    }
    function handleClick() {
        const themeFromSettings = window.Events.getThemeSetting();
        const updatedTheme = themeFromSettings === 'dark' ? 'light' : 'dark';
        window.setTheme(updatedTheme);
        dispatch((0, theme_1.applyTheme)(updatedTheme));
        if (updatedTheme === 'dark') {
            (0, BchatTheme_1.switchHtmlToDarkTheme)();
        }
        else {
            (0, BchatTheme_1.switchHtmlToLightTheme)();
        }
    }
    function verifyScreens() {
        if (section_2.SectionType.Settings !== focusedSection) {
            return (react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, onAvatarClick: () => dispatch((0, modalDialog_2.editProfileModal)({})), pubkey: bChatId, dataTestId: "leftpane-primary-avatar", isBnsHolder: isBnsHolder }));
        }
        else {
            return (react_1.default.createElement("div", { className: "module-left-pane__header_gearIcon" },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: 'gear', iconSize: 'large' })));
        }
    }
    function Moon() {
        return (react_1.default.createElement("div", { className: "dayAndNightIcon", onClick: handleClick, "data-tip": "Themes", "data-offset": "{'right':43}", "data-place": "bottom" }));
    }
    function Settings() {
        return (react_1.default.createElement("span", { style: { marginRight: '15px' } },
            react_1.default.createElement(icon_1.BchatIconButton, { iconSize: "large", iconType: "walletSetting", iconColor: "#2879fb", onClick: () => {
                    dispatch((0, search_1.clearSearch)());
                    dispatch((0, section_2.showLeftPaneSection)(3));
                    dispatch((0, section_2.setOverlayMode)(undefined));
                } })));
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(Flex_1.Flex, { flexDirection: "column" },
            react_1.default.createElement("div", { className: "module-left-pane__header", style: section_2.SectionType.Settings == focusedSection ? { boxShadow: 'none' } : {} },
                showBackButton && (react_1.default.createElement(icon_1.BchatIconButton, { onClick: () => {
                        dispatch((0, section_2.setOverlayMode)(undefined));
                    }, iconType: "chevron", iconRotation: 90, iconSize: "medium", margin: "0 0 var(--margins-xs) var(--margins-xs)" })),
                react_1.default.createElement("div", { className: "" }, verifyScreens()),
                react_1.default.createElement("div", { className: "module-left-pane__header__title" }, label),
                react_1.default.createElement(Moon, null),
                react_1.default.createElement(Settings, null)),
            react_1.default.createElement(ActionsPanel_1.BchatToolTip, { effect: "solid" }))));
};
exports.LeftPaneSectionHeader = LeftPaneSectionHeader;
const BannerInner = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const showRecoveryPhraseModal = () => {
        dispatch((0, userConfig_1.disableRecoveryPhrasePrompt)());
        dispatch((0, modalDialog_1.recoveryPhraseModal)({}));
    };
    return (react_1.default.createElement(StyledBannerInner, null,
        react_1.default.createElement("p", null, window.i18n('recoveryPhraseRevealMessage')),
        react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Default, text: window.i18n('recoveryPhraseRevealButtonText'), onClick: showRecoveryPhraseModal, dataTestId: "reveal-recovery-phrase" })));
};
const LeftPaneBanner = () => {
    const section = (0, react_redux_1.useSelector)(section_1.getFocusedSection);
    const isSignInWithRecoveryPhrase = (0, storage_1.isSignWithRecoveryPhrase)();
    if (section !== section_2.SectionType.Message || isSignInWithRecoveryPhrase) {
        return null;
    }
    return (react_1.default.createElement(exports.StyledLeftPaneBanner, null,
        react_1.default.createElement(StyledProgressBarContainer, null,
            react_1.default.createElement(StyledProgressBarInner, null)),
        react_1.default.createElement(exports.StyledBannerTitle, null,
            window.i18n('recoveryPhraseSecureTitle'),
            " ",
            react_1.default.createElement("span", null, "90%")),
        react_1.default.createElement(Flex_1.Flex, { flexDirection: "column", justifyContent: "space-between", padding: 'var(--margins-sm)' },
            react_1.default.createElement(BannerInner, null))));
};
exports.LeftPaneBanner = LeftPaneBanner;
const StyledProgressBarContainer = styled_components_1.default.div `
  width: 100%;
  height: 5px;
  flex-direction: row;
  background: var(--color-bchat-border);
`;
const StyledProgressBarInner = styled_components_1.default.div `
  background: var(--color-accent);
  width: 90%;
  transition: width 0.5s ease-in;
  height: 100%;
`;
exports.StyledBannerTitle = styled_components_1.default.div `
  line-height: 1.3;
  font-size: var(--font-size-md);
  font-weight: bold;
  margin: var(--margins-sm) var(--margins-sm) 0 var(--margins-sm);

  span {
    color: var(--color-text-accent);
  }
`;
exports.StyledLeftPaneBanner = styled_components_1.default.div `
  background: var(--color-recovery-phrase-banner-background);
  display: flex;
  flex-direction: column;
  border-bottom: var(--bchat-border);
`;
const StyledBannerInner = styled_components_1.default.div `
  p {
    margin: 0;
  }

  .left-pane-banner___phrase {
    margin-top: var(--margins-md);
  }

  .bchat-button {
    margin-top: var(--margins-sm);
  }
`;
