"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeftPaneSettingSection = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const react_redux_1 = require("react-redux");
const section_1 = require("../../state/ducks/section");
const section_2 = require("../../state/selectors/section");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const icon_1 = require("../icon");
const BchatSettings_1 = require("../settings/BchatSettings");
const userConfig_1 = require("../../state/ducks/userConfig");
const Text_1 = require("../basic/Text");
const theme_1 = require("../../state/selectors/theme");
const getCategories = [
    {
        id: BchatSettings_1.BchatSettingCategory.Chat,
        title: window.i18n('Chat'),
        icon: 'chat',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.WalletSettings,
        title: window.i18n('WalletSettingsTitle'),
        icon: 'wallet',
        extraId: 'BETA',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.Privacy,
        title: window.i18n('privacySettingsTitle'),
        icon: 'privacy',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.Appearance,
        title: window.i18n('appearanceSettingsTitle'),
        icon: 'appeareance',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.Notifications,
        title: window.i18n('notificationsSettingsTitle'),
        icon: 'notification',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.Blocked,
        title: window.i18n('blockedSettingsTitle'),
        icon: 'blockedContact',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.RecoverySeed,
        title: window.i18n('showRecoveryPhrase'),
        icon: 'recoverykey',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.MessageRequests,
        title: window.i18n('openMessageRequestInbox'),
        icon: 'messageRequest',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.Hops,
        title: 'Hops',
        icon: 'hops',
    },
    {
        id: BchatSettings_1.BchatSettingCategory.ClearData,
        title: 'Clear Data',
        icon: 'clearData',
    },
];
const LeftPaneSettingsCategoryRow = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const focusedSettingsSection = (0, react_redux_1.useSelector)(section_2.getFocusedSettingsSection);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const dataTestId = `settings-menu-item`;
    const iconColor = darkMode ? '#E0E0E0' : '#3E4A53';
    return (react_1.default.createElement(react_1.default.Fragment, null, getCategories.map((item) => (react_1.default.createElement("div", { key: item.id, "data-testid": dataTestId, className: (0, classnames_1.default)('left-pane-setting-category-list-item', item.id === focusedSettingsSection ? 'active' : ''), role: "link", onClick: () => {
            if (item.id !== BchatSettings_1.BchatSettingCategory.ClearData) {
                dispatch((0, section_1.showSettingsSection)(item.id));
                item.id === BchatSettings_1.BchatSettingCategory.Blocked && dispatch((0, userConfig_1.hideMultipleSelection)());
            }
            else {
                dispatch((0, modalDialog_1.updateDeleteAccountModal)({}));
            }
        } },
        react_1.default.createElement("i", { className: "left-pane-setting-category-list-item-icons" },
            react_1.default.createElement(icon_1.BchatIcon, { iconSize: 20, iconType: item.icon, iconColor: item.id === BchatSettings_1.BchatSettingCategory.ClearData ? '#FF3E3E' : iconColor })),
        react_1.default.createElement("span", { className: 'left-pane-setting-category-list-item-span', style: { color: item.id === BchatSettings_1.BchatSettingCategory.ClearData ? '#FF3E3E' : iconColor } }, item.title),
        item.extraId && react_1.default.createElement("span", { className: "beta" }, "BETA"))))));
};
const LeftPaneSettingsCategories = () => {
    if (0) {
        LeftPaneSettingsCategoryRow;
    }
    return (react_1.default.createElement("div", { className: "module-left-pane__list", key: 0 },
        react_1.default.createElement("div", { className: "left-pane-setting-category-list" },
            react_1.default.createElement(LeftPaneSettingsCategoryRow, null))));
};
const LeftPaneSettingSection = () => {
    return (react_1.default.createElement("div", { className: "left-pane-setting-section" },
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("h6", null, window.i18n('settingsHeader')),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", null,
            react_1.default.createElement(LeftPaneSettingsCategories, null))));
};
exports.LeftPaneSettingSection = LeftPaneSettingSection;
