"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationListItemHeaderItem = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const data_1 = require("../../../data/data");
const useParamSelector_1 = require("../../../hooks/useParamSelector");
const utils_1 = require("../../../bchat/utils");
const conversations_1 = require("../../../state/ducks/conversations");
const section_1 = require("../../../state/ducks/section");
const search_1 = require("../../../state/selectors/search");
const section_2 = require("../../../state/selectors/section");
const icon_1 = require("../../icon");
const ConversationListItem_1 = require("./ConversationListItem");
const UserItem_1 = require("./UserItem");
const NotificationSettingIcon = (props) => {
    const convoId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const convoSetting = (0, useParamSelector_1.useConversationPropsById)(convoId)?.currentNotificationSetting;
    if (!props.isMessagesSection) {
        return null;
    }
    switch (convoSetting) {
        case 'all':
            return null;
        case 'disabled':
            return react_1.default.createElement(icon_1.BchatIcon, { iconType: "mute", iconColor: '#A7A7BA', iconSize: "medium" });
        case 'mentions_only':
            return react_1.default.createElement(icon_1.BchatIcon, { iconType: "bell", iconColor: 'var(--color-text-subtle)', iconSize: "medium" });
        default:
            return null;
    }
};
const StyledConversationListItemIconWrapper = styled_components_1.default.div `
  svg {
    margin: 0px 2px;
  }

  display: flex;
  flex-direction: row;
`;
const PinWrapper = styled_components_1.default.div `
  position: absolute;
  top: -7px;
  right: 0px;
  padding:1px 2px;
  background-color: #2f8fff;
  border-radius: 12px;
`;
function useHeaderItemProps(conversationId) {
    const convoProps = (0, useParamSelector_1.useConversationPropsById)(conversationId);
    if (!convoProps) {
        return null;
    }
    return {
        isPinned: !!convoProps.isPinned,
        mentionedUs: convoProps.mentionedUs || false,
        unreadCount: convoProps.unreadCount || 0,
        activeAt: convoProps.activeAt,
    };
}
const ListItemIcons = () => {
    const isMessagesSection = (0, react_redux_1.useSelector)(section_2.getFocusedSection) === section_1.SectionType.Message;
    const conversationId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isPinned = (0, useParamSelector_1.useIsPinned)(conversationId);
    const pinIcon = isMessagesSection && isPinned ? (react_1.default.createElement(PinWrapper, null,
        react_1.default.createElement(icon_1.BchatIcon, { iconType: "pin", iconColor: '#F0F0F0', iconSize: 14 }))) : null;
    return (react_1.default.createElement(StyledConversationListItemIconWrapper, null,
        pinIcon,
        react_1.default.createElement(NotificationSettingIcon, { isMessagesSection: isMessagesSection })));
};
const MentionAtSymbol = styled_components_1.default.span `
  background-color: var(--color-accent);

  color: black;
  text-align: center;
  margin-top: 0px;
  margin-bottom: 0px;
  padding-top: 1px;
  padding-inline-start: 3px;
  padding-inline-end: 3px;

  position: static;
  margin-inline-start: 5px;

  font-weight: 300;
  font-size: 11px;
  letter-spacing: 0.25px;

  height: 16px;
  min-width: 16px;
  border-radius: 8px;
  /* transition: filter 0.25s linear; */
  cursor: pointer;

  :hover {
    filter: grayscale(0.7);
  }
`;
const ConversationListItemHeaderItem = () => {
    const conversationId = (0, react_1.useContext)(ConversationListItem_1.ContextConversationId);
    const isSearchingMode = (0, react_redux_1.useSelector)(search_1.isSearching);
    const convoProps = useHeaderItemProps(conversationId);
    const openConvoToLastMention = (0, react_1.useCallback)(async (e) => {
        e.stopPropagation();
        e.preventDefault();
        if (e.button === 0) {
            const oldestMessageUnreadWithMention = (await (0, data_1.getFirstUnreadMessageWithMention)(conversationId, utils_1.UserUtils.getOurPubKeyStrFromCache())) || null;
            if (oldestMessageUnreadWithMention) {
                await (0, conversations_1.openConversationToSpecificMessage)({
                    conversationKey: conversationId,
                    messageIdToNavigateTo: oldestMessageUnreadWithMention,
                    shouldHighlightMessage: true,
                });
            }
            else {
                window.log.info('cannot open to latest mention as no unread mention are found');
                await (0, conversations_1.openConversationWithMessages)({
                    conversationKey: conversationId,
                    messageId: null,
                });
            }
        }
    }, [conversationId]);
    if (!convoProps) {
        return null;
    }
    const { unreadCount, mentionedUs, } = convoProps;
    let atSymbol = null;
    let unreadCountDiv = null;
    if (unreadCount > 0) {
        atSymbol = mentionedUs ? (react_1.default.createElement(MentionAtSymbol, { title: "Open to latest mention", onMouseDown: openConvoToLastMention }, "@")) : null;
        unreadCountDiv = (react_1.default.createElement("p", { className: "module-conversation-list-item__unread-count" }, unreadCount > 99 ? '99+' : unreadCount));
    }
    return (react_1.default.createElement("div", { className: "module-conversation-list-item__header" },
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-conversation-list-item__header__name', unreadCount > 0 ? 'module-conversation-list-item__header__name--with-unread' : null) },
            react_1.default.createElement(UserItem_1.UserItem, null)),
        react_1.default.createElement("div", { className: "module-conversation-list-item_unread-count_wrapper" },
            react_1.default.createElement(ListItemIcons, null),
            atSymbol,
            unreadCountDiv),
        !isSearchingMode && (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-conversation-list-item__header__date', unreadCount > 0 ? 'module-conversation-list-item__header__date--has-unread' : null) }))));
};
exports.ConversationListItemHeaderItem = ConversationListItemHeaderItem;
