"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverlayHeader = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const section_1 = require("../../../state/ducks/section");
const icon_1 = require("../../icon");
const Avatar_1 = require("./../../avatar/Avatar");
const user_1 = require("../../../state/selectors/user");
const modalDialog_1 = require("../../../state/ducks/modalDialog");
const styled_components_1 = __importDefault(require("styled-components"));
const OverlayHeader = ({ subtitle, title, hideExit }) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const ourNumber = (0, react_redux_1.useSelector)(user_1.getOurNumber);
    const Header = styled_components_1.default.div `
   width: 100%;
   display: flex;
   flex-direction: row;
   padding: 10px 0 0 0;
   align-items: baseline;
   font-family:$bchat-font-poppin-semibold;
   padding:10px 10px;
  `;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(Header, null,
            hideExit ? "" :
                react_1.default.createElement("div", { className: "exit" },
                    react_1.default.createElement(icon_1.BchatIconButton, { iconSize: "small", iconType: "chevron", iconRotation: 90, onClick: () => {
                            dispatch((0, section_1.setOverlayMode)(undefined));
                        } })),
            react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, onAvatarClick: () => dispatch((0, modalDialog_1.editProfileModal)({})), pubkey: ourNumber, dataTestId: "leftpane-primary-avatar" }),
            react_1.default.createElement("h2", { style: { marginLeft: "10px" } }, title)),
        react_1.default.createElement("h3", null,
            subtitle,
            react_1.default.createElement("hr", { className: "green-border" })),
        react_1.default.createElement("hr", { className: "white-border" })));
};
exports.OverlayHeader = OverlayHeader;
