"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverlayMessage = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const BchatIdEditable_1 = require("../../basic/BchatIdEditable");
const BchatSpinner_1 = require("../../basic/BchatSpinner");
const section_1 = require("../../../state/ducks/section");
const types_1 = require("../../../bchat/types");
const conversation_1 = require("../../../models/conversation");
const snode_api_1 = require("../../../bchat/apis/snode_api");
const conversations_1 = require("../../../bchat/conversations");
const conversations_2 = require("../../../state/ducks/conversations");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const user_1 = require("../../../state/selectors/user");
const utils_1 = require("../../../bchat/utils");
const SmileSymbolIcon_1 = __importDefault(require("../../icon/SmileSymbolIcon"));
const BchatButton_1 = require("../../basic/BchatButton");
const Text_1 = require("../../basic/Text");
const Avatar_1 = require("../../avatar/Avatar");
const CopyIconButton_1 = require("../../icon/CopyIconButton");
const icon_1 = require("../../icon");
const EditProfileDialog_1 = require("../../dialog/EditProfileDialog");
const Flex_1 = require("../../basic/Flex");
const classnames_1 = __importDefault(require("classnames"));
const BchatWrapperModal_1 = require("../../BchatWrapperModal");
const OverlayMessage = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    function closeOverlay() {
        dispatch((0, section_1.showLeftPaneSection)(0));
        dispatch((0, section_1.setOverlayMode)(undefined));
    }
    (0, useKey_1.default)('Escape', closeOverlay);
    const [pubkeyOrOns, setPubkeyOrOns] = (0, react_1.useState)('');
    const [loading, setLoading] = (0, react_1.useState)(false);
    const [dispalyQR, setDispalyQR] = (0, react_1.useState)(false);
    const ourNumber = (0, react_redux_1.useSelector)(user_1.getOurNumber);
    const ourconvo = (0, conversations_1.getConversationController)().get(ourNumber);
    const walletAddress = localStorage.getItem('userAddress');
    const placeholder = window.i18n('enterBchatIDOrBNSName');
    async function handleMessageButtonClick() {
        const pubkeyorOnsTrimmed = pubkeyOrOns.trim();
        if (!pubkeyorOnsTrimmed) {
            utils_1.ToastUtils.pushToastError('invalidPubKey', 'please enter the Id or BNS');
            return;
        }
        if (types_1.PubKey.validateWithError(pubkeyorOnsTrimmed) &&
            !pubkeyOrOns.toLowerCase().endsWith('.bdx')) {
            utils_1.ToastUtils.pushToastError('invalidPubKey', window.i18n('invalidNumberError'));
            return;
        }
        if (!types_1.PubKey.validateWithError(pubkeyorOnsTrimmed)) {
            await (0, conversations_1.getConversationController)().getOrCreateAndWait(pubkeyorOnsTrimmed, conversation_1.ConversationTypeEnum.PRIVATE);
            await (0, conversations_2.openConversationWithMessages)({ conversationKey: pubkeyorOnsTrimmed, messageId: null });
            closeOverlay();
        }
        else {
            setLoading(true);
            try {
                const resolvedBchatID = await snode_api_1.SNodeAPI.getBchatIDForOnsName(pubkeyorOnsTrimmed);
                if (types_1.PubKey.validateWithError(resolvedBchatID)) {
                    throw new Error('Got a resolved BNS but the returned entry is not a valid bchatID');
                }
                await (0, conversations_1.getConversationController)().getOrCreateAndWait(resolvedBchatID, conversation_1.ConversationTypeEnum.PRIVATE);
                await (0, conversations_2.openConversationWithMessages)({
                    conversationKey: resolvedBchatID,
                    messageId: null,
                    bns: pubkeyorOnsTrimmed,
                });
                closeOverlay();
            }
            catch (e) {
                window?.log?.warn('failed to resolve bns name', pubkeyorOnsTrimmed, e);
                utils_1.ToastUtils.pushToastError('invalidPubKey', window.i18n('failedResolveOns'));
            }
            finally {
                setLoading(false);
            }
        }
    }
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-left-pane-overlay') },
        react_1.default.createElement("p", { className: "module-left-pane__chatHeader" },
            ' ',
            window.i18n('startConversation'),
            " ",
            react_1.default.createElement(SmileSymbolIcon_1.default, null)),
        react_1.default.createElement("section", null,
            react_1.default.createElement("article", { className: "bchatId_input_wrapper" },
                react_1.default.createElement(BchatIdEditable_1.BchatIdEditable, { editable: !loading, placeholder: placeholder, onChange: setPubkeyOrOns, maxLength: 66, dataTestId: "new-bchat-conversation" }),
                loading && (react_1.default.createElement(BchatWrapperModal_1.Loader, null,
                    react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: true }))),
                react_1.default.createElement(Text_1.SpacerSM, null),
                react_1.default.createElement(BchatButton_1.BchatButton, { text: 'Let’s Bchat', buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: BchatButton_1.BchatButtonColor.Primary, onClick: () => handleMessageButtonClick() })),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("article", { className: "ourDetails_wrapper" },
                react_1.default.createElement("p", { className: "module-left-pane__subHeader", style: { marginBottom: '10px' } }, "Your ID"),
                react_1.default.createElement(Text_1.SpacerLG, null),
                !dispalyQR ? (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement("div", { className: "avatar-Wrapper" },
                        react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.XL, pubkey: ourconvo.id, isBnsHolder: ourconvo.attributes.isBnsHolder }),
                        react_1.default.createElement("div", { className: "profile-name" },
                            " ",
                            ourconvo.getProfileName() || '')),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement("label", { className: "label-txt" }, "your BChat ID"),
                    react_1.default.createElement(Text_1.SpacerXS, null),
                    react_1.default.createElement("div", { className: "id-Wrapper" },
                        react_1.default.createElement("p", null, ourconvo.id),
                        react_1.default.createElement(CopyIconButton_1.CopyIconButton, { content: ourconvo.id, iconSize: 22, onClick: () => { } })),
                    react_1.default.createElement(Text_1.SpacerMD, null),
                    react_1.default.createElement("label", { className: "label-txt" }, "Beldex Address"),
                    react_1.default.createElement(Text_1.SpacerXS, null),
                    react_1.default.createElement("div", { className: "id-Wrapper" },
                        react_1.default.createElement("p", { className: "blue-color" }, walletAddress),
                        react_1.default.createElement(CopyIconButton_1.CopyIconButton, { content: walletAddress, iconSize: 22, onClick: () => { } })),
                    react_1.default.createElement(Text_1.SpacerMD, null),
                    react_1.default.createElement(BchatButton_1.BchatButton, { buttonColor: BchatButton_1.BchatButtonColor.Secondary, buttonType: BchatButton_1.BchatButtonType.Default, text: 'Show QR', disabled: false, iconType: "qr", iconSize: 24, onClick: () => setDispalyQR(true) }))) : (react_1.default.createElement("div", null,
                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center" },
                        react_1.default.createElement(icon_1.BchatIconButton, { iconSize: "huge", iconType: "KeyboardBackspaceArrow", iconPadding: "5px", iconColor: "#A9AEBA", onClick: () => setDispalyQR(false) }),
                        react_1.default.createElement("span", { className: "back-btn-txt" }, "Your QR")),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", justifyContent: "center", alignItems: "center", width: "100%" },
                        react_1.default.createElement("span", { className: "qr-wrapper" },
                            react_1.default.createElement(EditProfileDialog_1.QRView, { bchatID: ourconvo.id })),
                        react_1.default.createElement(Text_1.SpacerXS, null),
                        react_1.default.createElement("span", { className: "qr-txt " }, "Scan QR to start the Chat")),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement(Text_1.SpacerLG, null)))))));
};
exports.OverlayMessage = OverlayMessage;
