"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverlayOpenGroup = void 0;
const react_1 = __importStar(require("react"));
const BchatJoinableDefaultRooms_1 = require("./BchatJoinableDefaultRooms");
const BchatIdEditable_1 = require("../../basic/BchatIdEditable");
const BchatSpinner_1 = require("../../basic/BchatSpinner");
const react_redux_1 = require("react-redux");
const section_1 = require("../../../state/ducks/section");
const JoinOpenGroupV2_1 = require("../../../bchat/apis/open_group_api/opengroupV2/JoinOpenGroupV2");
const OpenGroupUtils_1 = require("../../../bchat/apis/open_group_api/utils/OpenGroupUtils");
const utils_1 = require("../../../bchat/utils");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const styled_components_1 = __importDefault(require("styled-components"));
const Text_1 = require("../../basic/Text");
const BchatButton_1 = require("../../basic/BchatButton");
async function joinSocialGroup(serverUrl) {
    if (serverUrl.match(OpenGroupUtils_1.openGroupV2CompleteURLRegex)) {
        const groupCreated = await (0, JoinOpenGroupV2_1.joinOpenGroupV2WithUIEvents)(serverUrl, true, false);
        return groupCreated;
    }
    else {
        utils_1.ToastUtils.pushToastError('invalidSocialGroupUrl', window.i18n('invalidSocialGroupUrl'));
        window.log.warn('Invalid opengroupv2 url');
        return false;
    }
}
const SocialGrpWrapper = styled_components_1.default.div `
  height: calc(100% - 115px);
  padding: 15px;
  overflow-y: auto;
`;
const OverlayOpenGroup = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const [loading, setLoading] = (0, react_1.useState)(false);
    const [groupUrl, setGroupUrl] = (0, react_1.useState)('');
    function closeOverlay() {
        dispatch((0, section_1.setOverlayMode)(undefined));
        dispatch((0, section_1.showLeftPaneSection)(0));
    }
    async function onEnterPressed() {
        try {
            if (loading) {
                return;
            }
            setLoading(true);
            const groupCreated = await joinSocialGroup(groupUrl);
            if (groupCreated) {
                closeOverlay();
            }
        }
        catch (e) {
            window.log.warn(e);
        }
        finally {
            setLoading(false);
        }
    }
    (0, useKey_1.default)('Escape', closeOverlay);
    const title = window.i18n('joinSocialGroup');
    const buttonText = window.i18n('next');
    const subtitle = window.i18n('openSocialURL');
    const placeholder = window.i18n('enterAnSocialGroupURL');
    return (react_1.default.createElement("div", { className: "module-left-pane-overlay" },
        react_1.default.createElement(SocialGrpWrapper, null,
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "module-left-pane-overlay-closed--header" }, title),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "module-left-pane-overlay-closed--subHeader" }, subtitle),
            react_1.default.createElement(Text_1.SpacerXS, null),
            react_1.default.createElement("div", { className: "create-group-name-input" },
                react_1.default.createElement(BchatIdEditable_1.BchatIdEditable, { editable: true, placeholder: placeholder, value: groupUrl, isGroup: true, maxLength: 300, onChange: setGroupUrl, onPressEnter: onEnterPressed })),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("div", { className: "module-left-pane-overlay-openhint-message" }, "Social groups are similar to public groups. however, you need an invite link to join. Join a social group using the group's URL."),
            react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: loading }),
            react_1.default.createElement(BchatJoinableDefaultRooms_1.BchatJoinableRooms, { onRoomClicked: closeOverlay })),
        react_1.default.createElement("div", { className: "buttonBox" },
            react_1.default.createElement(BchatButton_1.BchatButton, { buttonColor: BchatButton_1.BchatButtonColor.Primary, buttonType: BchatButton_1.BchatButtonType.Brand, text: buttonText, dataTestId: "next-button", onClick: onEnterPressed, disabled: !groupUrl.startsWith('http://social.beldex.io/') }))));
};
exports.OverlayOpenGroup = OverlayOpenGroup;
