"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lightbox = exports.LightboxObject = void 0;
const react_1 = __importStar(require("react"));
const useUnmount_1 = __importDefault(require("react-use/lib/useUnmount"));
const react_redux_1 = require("react-redux");
const useDisableDrag_1 = require("../../hooks/useDisableDrag");
const useEncryptedFileFetch_1 = require("../../hooks/useEncryptedFileFetch");
const conversations_1 = require("../../state/ducks/conversations");
const util_1 = require("../../util");
const icon_1 = require("../icon");
const MIME = __importStar(require("../../types/MIME"));
const lodash_1 = require("lodash");
const Colors = {
    TEXT_SECONDARY: '#bbb',
    ICON_SECONDARY: '#ccc',
};
const colorSVG = (url, color) => {
    return {
        WebkitMask: `url(${url}) no-repeat center`,
        WebkitMaskSize: '100%',
        backgroundColor: color,
    };
};
const CONTROLS_WIDTH = 50;
const CONTROLS_SPACING = 10;
const styles = {
    container: {
        display: 'flex',
        flexDirection: 'column',
        position: 'fixed',
        width: '100vw',
        height: '100vh',
        left: 0,
        zIndex: 31,
        right: 0,
        top: 0,
        bottom: 0,
        backgroundColor: 'rgba(0, 0, 0, 0.8)',
    },
    mainContainer: {
        display: 'flex',
        flexDirection: 'row',
        flexGrow: 1,
        paddingTop: 40,
        paddingLeft: 40,
        paddingRight: 40,
        paddingBottom: 0,
        minHeight: 0,
        overflow: 'hidden',
        minWidth: 0,
    },
    objectContainer: {
        position: 'relative',
        flexGrow: 1,
        display: 'inline-flex',
        justifyContent: 'center',
    },
    objectParentContainer: {
        flexGrow: 1,
        textAlign: 'center',
        margin: 'auto',
    },
    object: {
        flexGrow: 1,
        flexShrink: 0,
        maxWidth: '80vw',
        maxHeight: '80vh',
        objectFit: 'contain',
    },
    caption: {
        position: 'absolute',
        bottom: 0,
        left: 0,
        right: 0,
        textAlign: 'center',
        color: 'black',
        padding: '1em',
        paddingLeft: '3em',
        paddingRight: '3em',
        backgroundColor: 'rgba(192, 192, 192, .40)',
    },
    controlsOffsetPlaceholder: {
        width: CONTROLS_WIDTH,
        marginRight: CONTROLS_SPACING,
        flexShrink: 0,
    },
    headers: {
        display: 'flex',
        justifyContent: 'end',
        marginBottom: '15px',
        width: '98%',
    },
    controls: {
        width: '80px',
        flexShrink: 0,
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginRight: '15px',
    },
    navigationContainer: {
        flexShrink: 0,
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'center',
        padding: 10,
        position: 'absolute',
        right: '23px',
        top: '50%',
    },
    saveButton: {
        marginTop: 10,
    },
    iconButtonPlaceholder: {
        display: 'inline-block',
        width: 50,
        height: 50,
    },
};
const IconButton = ({ onClick, type }) => {
    const clickHandler = () => {
        if (!onClick) {
            return;
        }
        onClick();
    };
    let iconRotation = 0;
    let iconType;
    let iconColor = 'white';
    let iconSize = 'huge';
    switch (type) {
        case 'next':
            iconType = 'forwardArrow';
            iconSize = 58;
            iconColor = '#108D32';
            break;
        case 'previous':
            iconType = 'forwardArrow';
            iconRotation = 180;
            iconSize = 58;
            break;
        case 'close':
            iconType = 'exit';
            iconSize = 40;
            iconColor = '#BABABA';
            break;
        case 'save':
            iconType = 'upload';
            iconSize = 40;
            iconColor = '#00b200';
            break;
        default:
            throw new TypeError(`Invalid button type: ${type}`);
    }
    return (react_1.default.createElement(icon_1.BchatIconButton, { iconType: iconType, iconSize: iconSize, iconRotation: iconRotation, iconColor: iconColor, onClick: clickHandler, clipRule: "evenodd", fillRule: "evenodd" }));
};
const IconButtonPlaceholder = () => react_1.default.createElement("div", { style: styles.iconButtonPlaceholder });
const Icon = ({ onClick, url, }) => (react_1.default.createElement("div", { style: {
        ...styles.object,
        ...colorSVG(url, Colors.ICON_SECONDARY),
        maxWidth: 200,
    }, onClick: onClick, role: "button" }));
const LightboxObject = ({ objectURL, contentType, renderedRef, onObjectClick, }) => {
    const { urlToLoad } = (0, useEncryptedFileFetch_1.useEncryptedFileFetch)(objectURL, contentType, false);
    const isImageTypeSupported = util_1.GoogleChrome.isImageTypeSupported(contentType);
    (0, useUnmount_1.default)(() => {
        if (!renderedRef?.current) {
            return;
        }
        renderedRef.current.pause.pause();
    });
    const disableDrag = (0, useDisableDrag_1.useDisableDrag)();
    if (isImageTypeSupported) {
        return (react_1.default.createElement("img", { style: styles.object, onDragStart: disableDrag, alt: window.i18n('lightboxImageAlt'), src: urlToLoad, ref: renderedRef }));
    }
    const isVideoTypeSupported = util_1.GoogleChrome.isVideoTypeSupported(contentType);
    if (isVideoTypeSupported) {
        if (urlToLoad) {
            if (renderedRef?.current?.paused) {
                void renderedRef?.current?.play();
            }
        }
        return (react_1.default.createElement("video", { role: "button", ref: renderedRef, controls: true, style: styles.object, key: urlToLoad },
            react_1.default.createElement("source", { src: urlToLoad })));
    }
    const isUnsupportedImageType = !isImageTypeSupported && MIME.isImage(contentType);
    const isUnsupportedVideoType = !isVideoTypeSupported && MIME.isVideo(contentType);
    if (isUnsupportedImageType || isUnsupportedVideoType) {
        const iconUrl = isUnsupportedVideoType ? 'images/video.svg' : 'images/image.svg';
        return react_1.default.createElement(Icon, { url: iconUrl, onClick: onObjectClick });
    }
    return react_1.default.createElement(Icon, { onClick: onObjectClick, url: "images/file.svg" });
};
exports.LightboxObject = LightboxObject;
const Lightbox = (props) => {
    const renderedRef = (0, react_1.useRef)(null);
    const dispatch = (0, react_redux_1.useDispatch)();
    const { caption, contentType, objectURL, onNext, onPrevious, onSave } = props;
    const onObjectClick = (event) => {
        event.stopPropagation();
        dispatch((0, conversations_1.showLightBox)(undefined));
    };
    const onContainerClick = (event) => {
        if (renderedRef && event.target === renderedRef.current) {
            return;
        }
        dispatch((0, conversations_1.showLightBox)(undefined));
    };
    return (react_1.default.createElement("div", { style: styles.container, role: "dialog", onClick: onContainerClick },
        react_1.default.createElement("div", { style: styles.mainContainer },
            react_1.default.createElement("div", { style: { position: 'absolute', top: '50%' } }, onPrevious ? (react_1.default.createElement(IconButton, { type: "previous", onClick: onPrevious })) : (react_1.default.createElement(IconButtonPlaceholder, null))),
            react_1.default.createElement("div", { style: styles.objectParentContainer, role: "button" },
                react_1.default.createElement("div", { style: styles.headers },
                    react_1.default.createElement("div", { style: styles.controls },
                        onSave ? (react_1.default.createElement(IconButton, { type: "save", onClick: onSave, style: styles.saveButton })) : null,
                        react_1.default.createElement("div", { style: { marginLeft: '10px' } },
                            ' ',
                            react_1.default.createElement(IconButton, { type: "close", onClick: () => {
                                    dispatch((0, conversations_1.showLightBox)(undefined));
                                } })))),
                react_1.default.createElement("div", { style: styles.objectContainer },
                    !(0, lodash_1.isUndefined)(contentType) ? (react_1.default.createElement(exports.LightboxObject, { objectURL: objectURL, contentType: contentType, renderedRef: renderedRef, onObjectClick: onObjectClick })) : null,
                    caption ? react_1.default.createElement("div", { style: styles.caption }, caption) : null)),
            react_1.default.createElement("div", { style: styles.navigationContainer },
                react_1.default.createElement("div", null, onNext ? react_1.default.createElement(IconButton, { type: "next", onClick: onNext }) : react_1.default.createElement(IconButtonPlaceholder, null))))));
};
exports.Lightbox = Lightbox;
