"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LightboxGallery = void 0;
const react_1 = __importStar(require("react"));
const Lightbox_1 = require("./Lightbox");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../state/ducks/conversations");
const conversations_2 = require("../../state/selectors/conversations");
const attachmentsUtil_1 = require("../../util/attachmentsUtil");
const LightboxGallery = (props) => {
    const { media } = props;
    const [currentIndex, setCurrentIndex] = (0, react_1.useState)(-1);
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_2.getSelectedConversationKey);
    const dispatch = (0, react_redux_1.useDispatch)();
    (0, react_1.useEffect)(() => {
        setCurrentIndex(props.selectedIndex);
    }, []);
    const selectedMedia = media[currentIndex];
    const firstIndex = 0;
    const lastIndex = media.length - 1;
    const hasPrevious = currentIndex > firstIndex;
    const hasNext = currentIndex < lastIndex;
    const onPrevious = (0, react_1.useCallback)(() => {
        setCurrentIndex(Math.max(currentIndex - 1, 0));
    }, [currentIndex]);
    const onNext = (0, react_1.useCallback)(() => {
        setCurrentIndex(Math.min(currentIndex + 1, lastIndex));
    }, [currentIndex, lastIndex]);
    const handleSave = (0, react_1.useCallback)(() => {
        const mediaItem = media[currentIndex];
        void (0, attachmentsUtil_1.saveAttachmentToDisk)({ ...mediaItem, conversationId: selectedConversation });
    }, [currentIndex, media]);
    (0, useKey_1.default)('ArrowRight', () => {
        onNext?.();
    }, undefined, [currentIndex]);
    (0, useKey_1.default)('ArrowLeft', () => {
        onPrevious?.();
    }, undefined, [currentIndex]);
    (0, useKey_1.default)('Escape', () => {
        dispatch((0, conversations_1.showLightBox)(undefined));
    }, undefined, [currentIndex]);
    if (currentIndex === -1) {
        return null;
    }
    const objectURL = selectedMedia?.objectURL || 'images/alert-outline.svg';
    const { attachment } = selectedMedia;
    const caption = attachment?.caption;
    return (react_1.default.createElement(Lightbox_1.Lightbox, { onPrevious: hasPrevious ? onPrevious : undefined, onNext: hasNext ? onNext : undefined, onSave: handleSave, objectURL: objectURL, caption: caption, contentType: selectedMedia.contentType }));
};
exports.LightboxGallery = LightboxGallery;
