"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationHeaderMenu = void 0;
const react_1 = __importDefault(require("react"));
const react_contexify_1 = require("react-contexify");
const Menu_1 = require("./Menu");
const ConversationListItem_1 = require("../leftpane/conversation-list-item/ConversationListItem");
const conversations_1 = require("../../state/selectors/conversations");
const react_redux_1 = require("react-redux");
const ConversationHeaderMenu = (props) => {
    const { triggerId } = props;
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    if (!selectedConversation) {
        throw new Error('selectedConversation must be set for a header to be visible!');
    }
    return (react_1.default.createElement(ConversationListItem_1.ContextConversationId.Provider, { value: selectedConversation },
        react_1.default.createElement(react_contexify_1.Menu, { id: triggerId, animation: react_contexify_1.animation.fade },
            react_1.default.createElement(Menu_1.AcceptMenuItem, null),
            react_1.default.createElement(Menu_1.DeclineMenuItem, null),
            react_1.default.createElement(Menu_1.DisappearingMessageMenuItem, null),
            react_1.default.createElement(Menu_1.NotificationForConvoMenuItem, null),
            react_1.default.createElement(Menu_1.PinConversationMenuItem, null),
            react_1.default.createElement(Menu_1.BlockMenuItem, null),
            react_1.default.createElement(Menu_1.CopyMenuItem, null),
            react_1.default.createElement(Menu_1.MarkAllReadMenuItem, null),
            react_1.default.createElement(Menu_1.ChangeNicknameMenuItem, null),
            react_1.default.createElement(Menu_1.ClearNicknameMenuItem, null),
            react_1.default.createElement(Menu_1.DeleteMessagesMenuItem, null),
            react_1.default.createElement(Menu_1.AddModeratorsMenuItem, null),
            react_1.default.createElement(Menu_1.RemoveModeratorsMenuItem, null),
            react_1.default.createElement(Menu_1.BanMenuItem, null),
            react_1.default.createElement(Menu_1.UnbanMenuItem, null),
            react_1.default.createElement(Menu_1.UpdateGroupNameMenuItem, null),
            react_1.default.createElement(Menu_1.LeaveGroupMenuItem, null),
            react_1.default.createElement(Menu_1.InviteContactMenuItem, null),
            react_1.default.createElement(Menu_1.DeleteContactMenuItem, null))));
};
exports.ConversationHeaderMenu = ConversationHeaderMenu;
