"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegistrationStages = exports.RegistrationContext = exports.LeftImage = exports.RegistrationPhase = exports.signInWithLinking = exports.signInWithRecovery = exports.signUp = exports.resetRegistration = exports.MAX_USERNAME_LENGTH = void 0;
const react_1 = __importStar(require("react"));
const SignUpTab_1 = require("./SignUpTab");
const SignInTab_1 = require("./SignInTab");
const data_1 = require("../../data/data");
const snode_api_1 = require("../../bchat/apis/snode_api");
const conversations_1 = require("../../bchat/conversations");
const utils_1 = require("../../bchat/utils");
const Promise_1 = require("../../bchat/utils/Promise");
const events_1 = require("../../shims/events");
const accountManager_1 = require("../../util/accountManager");
const storage_1 = require("../../util/storage");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const AccentText_1 = require("./AccentText");
const TermsAndConditions_1 = require("./TermsAndConditions");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
exports.MAX_USERNAME_LENGTH = 26;
async function resetRegistration() {
    await (0, data_1.removeAll)();
    storage_1.Storage.reset();
    await storage_1.Storage.fetch();
    (0, conversations_1.getConversationController)().reset();
    await (0, conversations_1.getConversationController)().load();
}
exports.resetRegistration = resetRegistration;
const displayNameIsValid = (displayName) => {
    const trimName = displayName.trim();
    if (!trimName) {
        window?.log?.warn('invalid trimmed name for registration');
        utils_1.ToastUtils.pushToastError('invalidDisplayName', window.i18n('displayNameEmpty'));
        return undefined;
    }
    return trimName;
};
async function signUp(signUpDetails) {
    const { displayName, generatedRecoveryPhrase } = signUpDetails;
    window?.log?.info('SIGNING UP');
    const trimName = displayNameIsValid(displayName);
    if (!trimName) {
        return;
    }
    try {
        await resetRegistration();
        let deamonHeight = await wallet_rpc_1.wallet.getLatestHeight();
        await (0, accountManager_1.registerSingleDevice)(generatedRecoveryPhrase, 'english', trimName, deamonHeight ? deamonHeight : 0);
        await (0, data_1.createOrUpdateItem)({
            id: 'hasSyncedInitialConfigurationItem',
            value: true,
            timestamp: Date.now(),
        });
        await (0, storage_1.setSignWithRecoveryPhrase)(false);
        (0, events_1.trigger)('openInbox');
    }
    catch (e) {
        await resetRegistration();
        utils_1.ToastUtils.pushToastError('registrationError', `Error: ${e.message || 'Something went wrong'}`);
        window?.log?.warn('exception during registration:', e);
    }
}
exports.signUp = signUp;
async function signInWithRecovery(signInDetails) {
    const { displayName, password, userRecoveryPhrase, refreshDetails } = signInDetails;
    const trimName = displayNameIsValid(displayName);
    if (!trimName) {
        return;
    }
    try {
        const restoreWallet = await wallet_rpc_1.wallet.restoreWallet(displayName, password, userRecoveryPhrase, refreshDetails);
        localStorage.setItem('userAddress', restoreWallet.result.address);
        const deamonHeight = await wallet_rpc_1.wallet.getHeigthFromDateAndUserInput(refreshDetails);
        await resetRegistration();
        await (0, accountManager_1.registerSingleDevice)(userRecoveryPhrase, 'english', trimName, deamonHeight);
        await (0, storage_1.setSignWithRecoveryPhrase)(true);
        (0, events_1.trigger)('openInbox');
    }
    catch (e) {
        await resetRegistration();
        utils_1.ToastUtils.pushToastError('registrationError', `Error: ${e.message || 'Something went wrong'}`);
        window?.log?.warn('exception during registration:', e);
    }
}
exports.signInWithRecovery = signInWithRecovery;
async function signInWithLinking(signInDetails) {
    const { userRecoveryPhrase } = signInDetails;
    window?.log?.info('LINKING DEVICE');
    try {
        await resetRegistration();
        await (0, accountManager_1.signInByLinkingDevice)(userRecoveryPhrase, 'english');
        let displayNameFromNetwork = '';
        await (0, snode_api_1.getSwarmPollingInstance)().start();
        await utils_1.PromiseUtils.waitForTask(done => {
            window.Whisper.events.on('configurationMessageReceived', async (displayName) => {
                window.Whisper.events.off('configurationMessageReceived');
                await (0, storage_1.setSignInByLinking)(false);
                await (0, storage_1.setSignWithRecoveryPhrase)(true);
                done(displayName);
                displayNameFromNetwork = displayName;
            });
        }, 60000);
        if (displayNameFromNetwork.length) {
            window?.log?.info('We got a displayName from network: ');
        }
        else {
            window?.log?.info('Got a config message from network but without a displayName...');
            throw new Error('Got a config message from network but without a displayName...');
        }
        (0, events_1.trigger)('openInbox');
    }
    catch (e) {
        await resetRegistration();
        if (e instanceof Promise_1.TaskTimedOutError) {
            utils_1.ToastUtils.pushToastError('registrationError', 'Could not find your display name. Please Sign In by Restoring Your Account instead.');
        }
        else {
            utils_1.ToastUtils.pushToastError('registrationError', `Error: ${e.message || 'Something went wrong'}`);
        }
        window?.log?.warn('exception during registration:', e);
    }
}
exports.signInWithLinking = signInWithLinking;
var RegistrationPhase;
(function (RegistrationPhase) {
    RegistrationPhase[RegistrationPhase["Start"] = 0] = "Start";
    RegistrationPhase[RegistrationPhase["SignIn"] = 1] = "SignIn";
    RegistrationPhase[RegistrationPhase["SignUp"] = 2] = "SignUp";
})(RegistrationPhase = exports.RegistrationPhase || (exports.RegistrationPhase = {}));
var LeftImage;
(function (LeftImage) {
    LeftImage[LeftImage["registration"] = 0] = "registration";
    LeftImage[LeftImage["password"] = 1] = "password";
    LeftImage[LeftImage["address"] = 2] = "address";
    LeftImage[LeftImage["recoveryseed"] = 3] = "recoveryseed";
})(LeftImage = exports.LeftImage || (exports.LeftImage = {}));
exports.RegistrationContext = (0, react_1.createContext)({
    registrationPhase: RegistrationPhase.Start,
    signInMode: SignInTab_1.SignInMode.Default,
    signUpMode: SignUpTab_1.SignUpMode.Default,
    setRegistrationPhase: () => undefined,
    setSignUpMode: () => undefined,
    setSignInMode: () => undefined,
});
const RegistrationStages = () => {
    const [registrationPhase, setRegistrationPhase] = (0, react_1.useState)(RegistrationPhase.Start);
    const [signInMode, setSignInMode] = (0, react_1.useState)(SignInTab_1.SignInMode.Default);
    const [signUpMode, setSignUpMode] = (0, react_1.useState)(SignUpTab_1.SignUpMode.Default);
    const [accent, setAccent] = (0, react_1.useState)(true);
    const [imageCount, setImageCount] = (0, react_1.useState)(0);
    (0, react_1.useEffect)(() => {
        void generateMnemonicAndKeyPairaa();
        void resetRegistration();
    }, []);
    const generateMnemonicAndKeyPairaa = async () => {
        await wallet_rpc_1.wallet.startWallet();
    };
    const imageValidator = (e) => {
        setImageCount(e);
    };
    const displayImg = () => {
        let path;
        if (imageCount === LeftImage.recoveryseed) {
            path = 'images/bchat/loginPageSeed.png';
        }
        else if (imageCount === LeftImage.password) {
            path = 'images/bchat/loginPagePassword.png';
        }
        else if (imageCount === LeftImage.address) {
            path = 'images/bchat/loginPageAddress.png';
        }
        else {
            path = 'images/bchat/loginpage.png';
        }
        return path;
    };
    return (react_1.default.createElement("div", { className: "bchat-registration-container" },
        react_1.default.createElement(Flex_1.Flex, { flexDirection: "row", container: true, height: "100%", width: "100%" },
            react_1.default.createElement(Flex_1.Flex, { className: "bchat-content-left", alignItems: "center", flexDirection: "row", container: true, height: "100%", width: "45%", justifyContent: "flex-end" },
                react_1.default.createElement("img", { src: displayImg(), width: '86%', height: '80%' })),
            react_1.default.createElement(Flex_1.Flex, { className: "bchat-content", alignItems: "center", flexDirection: "column", container: true, height: "100%", width: "55%", justifyContent: "center" },
                react_1.default.createElement("div", { style: { width: '470px' } },
                    react_1.default.createElement(exports.RegistrationContext.Provider, { value: {
                            registrationPhase,
                            signInMode,
                            signUpMode,
                            setSignInMode,
                            setSignUpMode,
                            setRegistrationPhase,
                        } },
                        accent && react_1.default.createElement(AccentText_1.AccentText, null),
                        (registrationPhase === RegistrationPhase.Start ||
                            registrationPhase === RegistrationPhase.SignUp) && (react_1.default.createElement(SignUpTab_1.SignUpTab, { assent: (value) => setAccent(value), imageValidator: (e) => imageValidator(e) })),
                        (registrationPhase === RegistrationPhase.Start ||
                            registrationPhase === RegistrationPhase.SignIn) && (react_1.default.createElement(SignInTab_1.SignInTab, { assent: (value) => setAccent(value), imageValidator: (e) => imageValidator(e) })),
                        react_1.default.createElement(Text_1.SpacerLG, null),
                        accent && react_1.default.createElement(TermsAndConditions_1.TermsAndConditions, null)))))));
};
exports.RegistrationStages = RegistrationStages;
