"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegistrationUserDetails = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const BchatInput_1 = require("../basic/BchatInput");
const RegistrationStages_1 = require("./RegistrationStages");
const DisplayNameInput = (props) => {
    return (react_1.default.createElement(BchatInput_1.BchatInput, { autoFocus: props.stealAutoFocus || false, type: "text", placeholder: window.i18n('enterDisplayName'), value: props.displayName, maxLength: RegistrationStages_1.MAX_USERNAME_LENGTH, onValueChanged: (value => {
            props.onDisplayNameChanged(value.replace(/\s/g, ''));
        }), onEnterPressed: props.handlePressEnter, inputDataTestId: "display-name-input" }));
};
const RecoveryPhraseInput = (props) => {
    return (react_1.default.createElement(BchatInput_1.BchatInput, { label: window.i18n('recoveryPhrase'), type: "password", value: props.recoveryPhrase, autoFocus: props.stealAutoFocus || false, placeholder: window.i18n('enterRecoveryPhrase'), enableShowHide: true, onValueChanged: props.onSeedChanged, onEnterPressed: props.handlePressEnter, inputDataTestId: "recovery-phrase-input" }));
};
const RegistrationUserDetails = (props) => {
    if (props.showSeedField && (props.recoveryPhrase === undefined || !props.onSeedChanged)) {
        throw new Error('if show seed is true, we need callback + value');
    }
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-registration__entry-fields') },
        props.showSeedField && (react_1.default.createElement(RecoveryPhraseInput, { recoveryPhrase: props.recoveryPhrase, handlePressEnter: props.handlePressEnter, onSeedChanged: props.onSeedChanged, stealAutoFocus: props.stealAutoFocus })),
        react_1.default.createElement("div", { className: "inputfields" }, props.showDisplayNameField && (react_1.default.createElement(DisplayNameInput, { stealAutoFocus: !props.showSeedField && props.stealAutoFocus, displayName: props.displayName, handlePressEnter: props.handlePressEnter, onDisplayNameChanged: props.onDisplayNameChanged })))));
};
exports.RegistrationUserDetails = RegistrationUserDetails;
