"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignInTab = exports.SignInMode = void 0;
const react_1 = __importStar(require("react"));
const String_1 = require("../../bchat/utils/String");
const BchatButton_1 = require("../basic/BchatButton");
const RegistrationStages_1 = require("./RegistrationStages");
const SignUpTab_1 = require("./SignUpTab");
const BchatInput_1 = require("../basic/BchatInput");
const DisplaySeed_1 = require("./DisplaySeed");
const mnemonic_1 = require("../../bchat/crypto/mnemonic");
const utils_1 = require("../../bchat/utils");
const WalletPass_1 = require("./WalletPass");
const Flex_1 = require("../basic/Flex");
const moment_1 = __importDefault(require("moment"));
const BchatIcon_1 = require("../icon/BchatIcon");
const BchatConfirm_1 = require("../dialog/BchatConfirm");
const { clipboard } = require('electron');
var SignInMode;
(function (SignInMode) {
    SignInMode[SignInMode["Default"] = 0] = "Default";
    SignInMode[SignInMode["UsingRecoveryPhrase"] = 1] = "UsingRecoveryPhrase";
    SignInMode[SignInMode["LinkDevice"] = 2] = "LinkDevice";
})(SignInMode = exports.SignInMode || (exports.SignInMode = {}));
const RestoreUsingRecoveryPhraseButton = (props) => {
    return (react_1.default.createElement("div", { className: "signIn-btn" },
        react_1.default.createElement(BchatButton_1.BchatButton, { onClick: props.onRecoveryButtonClicked, buttonType: BchatButton_1.BchatButtonType.DefaultOutline, buttonColor: BchatButton_1.BchatButtonColor.Primary, text: window.i18n('signIn'), dataTestId: "restore-using-recovery" })));
};
const ContinueYourBchatButton = (props) => {
    return (react_1.default.createElement(BchatButton_1.BchatButton, { onClick: props.handleContinueYourBchatClick, buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: BchatButton_1.BchatButtonColor.Primary, text: window.i18n('restore'), disabled: props.disabled, dataTestId: "continue-Bchat-button" }));
};
const SignInContinueButton = (props) => {
    if (props.signInMode === SignInMode.Default) {
        return null;
    }
    return (react_1.default.createElement(ContinueYourBchatButton, { handleContinueYourBchatClick: props.handleContinueYourBchatClick, disabled: props.disabled }));
};
const SignInButtons = (props) => {
    if (props.signInMode !== SignInMode.Default) {
        return null;
    }
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(RestoreUsingRecoveryPhraseButton, { onRecoveryButtonClicked: props.onRecoveryButtonClicked })));
};
const SignInTab = (props) => {
    const { setRegistrationPhase, signInMode, setSignInMode } = (0, react_1.useContext)(RegistrationStages_1.RegistrationContext);
    const today = (0, moment_1.default)().format('YYYY-MM-DD');
    const [password, setPassword] = (0, react_1.useState)('');
    const [repassword, setRepassword] = (0, react_1.useState)('');
    const [recoveryPhrase, setRecoveryPhrase] = (0, react_1.useState)('');
    const [displayName, setDisplayName] = (0, react_1.useState)('');
    const [displayNameError, setDisplayNameError] = (0, react_1.useState)('');
    const [loading, setIsLoading] = (0, react_1.useState)(false);
    const isRecovery = signInMode === SignInMode.UsingRecoveryPhrase;
    const isLinking = signInMode === SignInMode.LinkDevice;
    const [screenName, setScreenName] = (0, react_1.useState)(1);
    const [blockheight, setBlockheight] = (0, react_1.useState)('');
    const [restoreDate, setRestoreDate] = (0, react_1.useState)('');
    const [confirmModalOpen, setConfirmModalOpen] = (0, react_1.useState)(false);
    const displayNameOK = (isRecovery && !displayNameError && !!displayName) || isLinking;
    const activateContinueButton = displayNameOK && !loading;
    const confirmProps = {
        title: 'Blockheight will be set to Zero(0)',
        message: 'Do you want to proceed Restore by syncing from Blockheight value 0?',
        okText: 'Proceed',
        cancelText: 'Cancel',
        showExitIcon: false,
        iconShow: true,
        customIcon: react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "blockSync", iconSize: 58, fillRule: 'evenodd', clipRule: 'evenodd' }),
        okTheme: BchatButton_1.BchatButtonColor.Primary,
        onClickOk: () => { setConfirmModalOpen(false), continueYourBchat(); },
        onClickCancel: () => {
            setConfirmModalOpen(false);
        },
    };
    localStorage.setItem('walletUserName', displayName);
    const validationForConfirmPopup = () => {
        if (!restoreDate && !blockheight) {
            setConfirmModalOpen(true);
        }
        else {
            continueYourBchat();
        }
    };
    const continueYourBchat = async () => {
        if (isRecovery) {
            setIsLoading(true);
            let refreshDetails = !restoreDate
                ? { refresh_start_timestamp_or_height: blockheight, refresh_type: 'height' }
                : { refresh_start_timestamp_or_height: restoreDate, refresh_type: 'date' };
            await (0, RegistrationStages_1.signInWithRecovery)({
                displayName,
                password,
                userRecoveryPhrase: recoveryPhrase,
                refreshDetails,
            });
            setIsLoading(false);
        }
        else if (isLinking) {
            setIsLoading(true);
            await (0, RegistrationStages_1.signInWithLinking)({
                userRecoveryPhrase: recoveryPhrase,
            });
            setIsLoading(false);
        }
    };
    const passValid = () => {
        if (!password || !repassword) {
            return utils_1.ToastUtils.pushToastError('passwordFieldEmpty', window.i18n('passwordFieldEmpty'));
        }
        if (password !== repassword) {
            window?.log?.warn('invalid password');
            return utils_1.ToastUtils.pushToastError('invalidPassword', 'Please Enter Same Password !');
        }
        if ((password.length < 4 && repassword.length < 4) ||
            (password.length > 13 && repassword.length > 13)) {
            return utils_1.ToastUtils.pushToastError('walletPasswordLengthError', window.i18n('walletPasswordLengthError'));
        }
        setScreenName(3);
        props.imageValidator(RegistrationStages_1.LeftImage.recoveryseed);
    };
    async function assignSeed() {
        const recoverySeed = clipboard.readText();
        setRecoveryPhrase(recoverySeed);
    }
    const seedValidation = () => {
        if (!recoveryPhrase) {
            return utils_1.ToastUtils.pushToastError('registrationError', `Please enter the seed`);
        }
        else {
            try {
                (0, mnemonic_1.mn_decode)(recoveryPhrase, 'english');
                setScreenName(2);
                props.imageValidator(RegistrationStages_1.LeftImage.password);
            }
            catch (e) {
                setScreenName(1);
                utils_1.ToastUtils.pushToastError('registrationError', `Error: ${e.message || 'Something went wrong'}`);
                window?.log?.warn('exception during registration:', e);
            }
        }
    };
    if (signInMode !== SignInMode.Default && screenName === 1) {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(DisplaySeed_1.DisplaySeed, { backArrow: () => {
                    props.assent(true);
                    setScreenName(1);
                    setBlockheight('');
                    setRestoreDate('');
                    props.imageValidator(RegistrationStages_1.LeftImage.registration);
                }, paste: () => assignSeed(), assignRecoveryPhase: (seed) => {
                    setRecoveryPhrase(seed);
                }, onNext: () => {
                    seedValidation();
                }, recoveryPhrase: recoveryPhrase })));
    }
    const handleInputChange = (setter, e) => {
        const newValue = e.replace(/\s+/g, '');
        setter(newValue);
    };
    if (screenName === 2) {
        return (react_1.default.createElement(WalletPass_1.WalletPassword, { password: password, repassword: repassword, setPassword: (e) => handleInputChange(setPassword, e), setRepassword: (e) => handleInputChange(setRepassword, e), backArrow: () => {
                setScreenName(1);
                props.imageValidator(RegistrationStages_1.LeftImage.recoveryseed);
                setPassword('');
                setRepassword(''), props.assent(true);
            }, submit: passValid }));
    }
    const LoaderGif = () => {
        return (react_1.default.createElement("div", { className: "bchat-registration-loadingGif" },
            react_1.default.createElement("div", { style: {
                    background: 'url(images/bchat/Load_animation.gif) no-repeat',
                    width: '120px',
                    height: '120px',
                    margin: '0px auto',
                    backgroundSize: '102px',
                } })));
    };
    return (react_1.default.createElement("div", { className: "bchat-registration__content" },
        screenName === 3 && (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(Flex_1.Flex, { flexDirection: "row", container: true, alignItems: "center", padding: "20px 0px" },
                react_1.default.createElement("div", { className: "bchat-registration-goback-icon" },
                    react_1.default.createElement(SignUpTab_1.GoBackMainMenuButton, { assent: () => {
                            props.assent(true);
                            setScreenName(1);
                            setPassword('');
                            setRepassword('');
                            setBlockheight('');
                            setRestoreDate('');
                            props.imageValidator(RegistrationStages_1.LeftImage.registration);
                        } })),
                react_1.default.createElement(Flex_1.Flex, { className: "bchat-registration__welcome-bchat" }, window.i18n('restoreFromSeed'))),
            react_1.default.createElement(BchatInput_1.BchatInput, { autoFocus: true, type: "text", placeholder: window.i18n('enterDisplayName'), value: displayName, maxLength: RegistrationStages_1.MAX_USERNAME_LENGTH, onValueChanged: (name) => {
                    const sanitizedName = (0, String_1.sanitizeBchatUsername)(name);
                    const trimName = sanitizedName.trim();
                    setDisplayName(sanitizedName);
                    setDisplayNameError(!trimName ? window.i18n('displayNameEmpty') : undefined);
                }, onEnterPressed: validationForConfirmPopup, inputDataTestId: "display-name-input" }),
            react_1.default.createElement("div", null,
                react_1.default.createElement("hr", { className: "bchat-registration-hr" }),
                react_1.default.createElement("p", { className: "bchat-restore-seed-textbox-message" }, "If you dont know the restore blockheight, you can skip it."),
                react_1.default.createElement(BchatInput_1.BchatInput, { autoFocus: true, type: "text", placeholder: 'Restore from Blockheight', value: blockheight, maxLength: 10, onValueChanged: e => {
                        let checkHeight = /^[\d ]*$/.test(e);
                        if (!checkHeight)
                            return;
                        setBlockheight(e);
                    }, onEnterPressed: props.handlePressEnter, inputDataTestId: "display-name-input" })),
            react_1.default.createElement("div", { className: "bchat-restore-seed-or" }, " OR "),
            react_1.default.createElement("div", { style: { marginBottom: '25px' } },
                react_1.default.createElement("p", { className: "bchat-restore-seed-textbox-message" }, "If you dont know the restore Date, you can skip it."),
                react_1.default.createElement(BchatInput_1.BchatInput, { autoFocus: true, type: "date", max: today, placeholder: 'Restore from Date', value: restoreDate, maxLength: RegistrationStages_1.MAX_USERNAME_LENGTH, onValueChanged: e => setRestoreDate(e), onEnterPressed: props.handlePressEnter, inputDataTestId: "display-name-input", min: "2020-01-01" })),
            react_1.default.createElement("div", { style: { width: '450px' } },
                react_1.default.createElement(SignInContinueButton, { signInMode: signInMode, handleContinueYourBchatClick: validationForConfirmPopup, disabled: !activateContinueButton })))),
        react_1.default.createElement(SignInButtons, { signInMode: signInMode, onRecoveryButtonClicked: () => {
                setRegistrationPhase(RegistrationStages_1.RegistrationPhase.SignIn);
                setSignInMode(SignInMode.UsingRecoveryPhrase);
                setRecoveryPhrase('');
                setDisplayName('');
                setIsLoading(false);
                props.assent(false);
                props.imageValidator(RegistrationStages_1.LeftImage.recoveryseed);
            }, onLinkDeviceButtonClicked: () => {
                setRegistrationPhase(RegistrationStages_1.RegistrationPhase.SignIn);
                setSignInMode(SignInMode.LinkDevice);
                setRecoveryPhrase('');
                setDisplayName('');
                setIsLoading(false);
            } }),
        loading && react_1.default.createElement(LoaderGif, null),
        confirmModalOpen && react_1.default.createElement(BchatConfirm_1.BchatConfirm, { ...confirmProps })));
};
exports.SignInTab = SignInTab;
