"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchResults = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const ConversationListItem_1 = require("../leftpane/conversation-list-item/ConversationListItem");
const MessageSearchResults_1 = require("./MessageSearchResults");
const StyledSeparatorSection = styled_components_1.default.div `
  height: 36px;
  line-height: 36px;

  margin-inline-start: 16px;

  color: var(--color-text);

  font-size: 13px;
  font-weight: 400;
  letter-spacing: 0;
`;
const SearchResultsContainer = styled_components_1.default.div `
  overflow-y: auto;
  max-height: 100%;
  color: var(--color-text);
  flex-grow: 1;
  width: -webkit-fill-available;
  overflow-x:hidden;
`;
const NoResults = styled_components_1.default.div `
  margin-top: 27px;
  width: 100%;
  text-align: center;
`;
const SearchResults = (props) => {
    const { contactsAndGroups, messages, searchTerm } = props;
    const haveContactsAndGroup = Boolean(contactsAndGroups?.length);
    const haveMessages = Boolean(messages?.length);
    const noResults = !haveContactsAndGroup && !haveMessages;
    return (react_1.default.createElement(SearchResultsContainer, null,
        noResults ? react_1.default.createElement(NoResults, null, window.i18n('noSearchResults', [searchTerm])) : null,
        haveContactsAndGroup ? (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(StyledSeparatorSection, null, window.i18n('conversationsHeader')),
            contactsAndGroups.map(contactOrGroup => (react_1.default.createElement(ConversationListItem_1.MemoConversationListItemWithDetails, { ...contactOrGroup, mentionedUs: false, isBlocked: false, key: `search-result-convo-${contactOrGroup.id}` }))))) : null,
        haveMessages && (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(StyledSeparatorSection, null, `${window.i18n('messagesHeader')}: ${messages.length}`),
            messages.map(message => (react_1.default.createElement(MessageSearchResults_1.MessageSearchResult, { key: `search-result-message-${message.id}`, ...message })))))));
};
exports.SearchResults = SearchResults;
