"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatNotificationGroupSettings = void 0;
const react_1 = __importStar(require("react"));
const BchatSettingListItem_1 = require("./BchatSettingListItem");
const bchat_1 = require("../../bchat");
const icon_1 = require("../icon");
const settings_key_1 = require("../../data/settings-key");
const react_use_1 = require("react-use");
const Settings_1 = require("../../types/Settings");
const styled_components_1 = __importDefault(require("styled-components"));
const Text_1 = require("../basic/Text");
const BchatButton_1 = require("../basic/BchatButton");
const notifications_1 = require("../../util/notifications");
const StyledButtonContainer = styled_components_1.default.div `
  display: flex;
  width: min-content;
  flex-direction: column;
  padding-inline-start: var(--margins-lg);
  justify-content: center;
  align-items: center;
  width: 100%;
`;
const BchatNotificationGroupSettings = (props) => {
    const initialItem = window.getSettingValue('notification-setting') || 'message';
    const initialAudioNotificationEnabled = window.getSettingValue(settings_key_1.SettingsKey.settingsAudioNotification) || false;
    const forceUpdate = (0, react_use_1.useUpdate)();
    const [selected, setSelected] = (0, react_1.useState)(initialItem);
    if (props.hasPassword === null) {
        return null;
    }
    const items = [
        {
            label: window.i18n('nameAndMessage'),
            value: 'message',
        },
        {
            label: window.i18n('nameOnly'),
            value: 'name',
        },
        {
            label: window.i18n('noNameOrMessage'),
            value: 'count',
        },
    ];
    function notificationOption(item) {
        window.setSettingValue('notification-setting', item.value);
        setSelected(item.value);
    }
    function toggle() {
        if (selected === 'off') {
            window.setSettingValue('notification-setting', 'message');
            setSelected('message');
        }
        else {
            window.setSettingValue('notification-setting', 'off');
            setSelected('off');
        }
    }
    const onClickPreview = () => {
        if (selected === 'off') {
            return;
        }
        notifications_1.Notifications.addPreviewNotification({
            conversationId: `preview-notification-${Date.now()}`,
            message: items.find(m => m.value === selected)?.label ||
                window?.i18n?.('messageBody') ||
                'Message body',
            title: window.i18n('notificationPreview'),
            iconUrl: null,
            isExpiringMessage: false,
            messageSentAt: Date.now(),
        });
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: "notification-setting" },
            ' ',
            react_1.default.createElement("div", { className: "notify-option-wrapper" },
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: () => {
                        toggle();
                    }, title: window.i18n('notificationSettingsDialog'), active: selected !== 'off', iconType: "notifySet" }),
                selected !== 'off' &&
                    items.map((item, i) => (react_1.default.createElement("div", { className: "bchat-settings-item-notification", key: i, onClick: () => notificationOption(item) },
                        react_1.default.createElement("div", { className: selected !== item.value ? 'bchat-settings-item-notification-circle' : 'selected' }, selected === item.value && (react_1.default.createElement(icon_1.BchatIcon, { iconType: "circle", iconSize: 10, iconColor: bchat_1.Constants.UI.COLORS.GREEN }))),
                        react_1.default.createElement("div", { className: "bchat-settings-item-notification-title" }, item.label))))),
            react_1.default.createElement(Text_1.SpacerMD, null),
            selected !== 'off' && (0, Settings_1.isAudioNotificationSupported)() && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: async () => {
                        window.setSettingValue(settings_key_1.SettingsKey.settingsAudioNotification, !initialAudioNotificationEnabled);
                        forceUpdate();
                    }, title: window.i18n('notificationSound'), active: window.getSettingValue(settings_key_1.SettingsKey.settingsAudioNotification), iconType: "speaker" }),
                react_1.default.createElement(StyledButtonContainer, null,
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('notificationPreview'), onClick: () => onClickPreview(), buttonColor: BchatButton_1.BchatButtonColor.Primary, buttonType: BchatButton_1.BchatButtonType.Brand })))))));
};
exports.BchatNotificationGroupSettings = BchatNotificationGroupSettings;
