"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoMessageRequestListSetting = exports.ContextConversationId = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const Avatar_1 = require(".././avatar/Avatar");
const react_dom_1 = require("react-dom");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const ConversationListItemContextMenu_1 = require("../menu/ConversationListItemContextMenu");
const HeaderItem_1 = require("../../components/leftpane/conversation-list-item/HeaderItem");
const MessageItem_1 = require("../../components/leftpane/conversation-list-item/MessageItem");
const lodash_1 = __importDefault(require("lodash"));
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const conversations_1 = require("../../bchat/conversations");
const BchatButton_1 = require("../basic/BchatButton");
const Text_1 = require("../basic/Text");
const DeclineMessageRequest_1 = __importDefault(require("../icon/DeclineMessageRequest"));
exports.ContextConversationId = react_1.default.createContext('');
const Portal = ({ children }) => {
    return (0, react_dom_1.createPortal)(children, document.querySelector('.inbox.index'));
};
const AvatarItem = () => {
    const conversationId = (0, react_1.useContext)(exports.ContextConversationId);
    const userName = (0, useParamSelector_1.useConversationUsername)(conversationId);
    const isPrivate = (0, useParamSelector_1.useIsPrivate)(conversationId);
    const avatarPath = (0, useParamSelector_1.useAvatarPath)(conversationId);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(conversationId);
    const dispatch = (0, react_redux_1.useDispatch)();
    function onPrivateAvatarClick() {
        dispatch((0, modalDialog_1.updateUserDetailsModal)({
            conversationId: conversationId,
            userName: userName || '',
            authorAvatarPath: avatarPath,
        }));
    }
    return (react_1.default.createElement("div", { className: "module-conversation-list-item__avatar-container" },
        react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, pubkey: conversationId, onAvatarClick: isPrivate ? onPrivateAvatarClick : undefined, isBnsHolder: isBnsHolder })));
};
const MessageRequestListSetting = (props) => {
    const { id: conversationId, style, isMessageRequest, profileName } = props;
    const key = `conversation-item-${conversationId}`;
    const triggerId = `${key}-ctxmenu`;
    const handleAcceptConversationRequest = async () => {
        const convo = (0, conversations_1.getConversationController)().get(conversationId);
        await convo.setDidApproveMe(true);
        await convo.addOutgoingApprovalMessage(Date.now());
        await (0, conversationInteractions_1.approveConvoAndSendResponse)(conversationId, true);
    };
    const handleDeclineConversationRequest = () => {
        const customIcon = react_1.default.createElement(DeclineMessageRequest_1.default, { iconSize: 30 });
        (0, conversationInteractions_1.declineConversationWithConfirm)(conversationId, true, customIcon);
    };
    return (react_1.default.createElement(exports.ContextConversationId.Provider, { value: conversationId },
        react_1.default.createElement("div", { key: key },
            react_1.default.createElement("div", { style: style, className: (0, classnames_1.default)('bchat-settings-messageRequest-list-item') },
                react_1.default.createElement(AvatarItem, null),
                react_1.default.createElement("div", { className: "module-conversation-list-item__content" },
                    react_1.default.createElement(HeaderItem_1.ConversationListItemHeaderItem, null),
                    react_1.default.createElement("div", { className: 'bchat-settings-messageRequest-profileName' }, profileName),
                    react_1.default.createElement(MessageItem_1.MessageItem, { isMessageRequest: Boolean(isMessageRequest) })),
                react_1.default.createElement(BchatButton_1.BchatButton, { style: { minWidth: '115px', height: '45px', fontWeight: '400', fontSize: '16px' }, buttonColor: BchatButton_1.BchatButtonColor.Danger, buttonType: BchatButton_1.BchatButtonType.Brand, text: window.i18n('decline'), onClick: handleDeclineConversationRequest, dataTestId: "accept-button-settings-screen" }),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement(BchatButton_1.BchatButton, { style: { minWidth: '115px', height: '45px', fontWeight: '400', fontSize: '16px' }, buttonColor: BchatButton_1.BchatButtonColor.Primary, buttonType: BchatButton_1.BchatButtonType.Brand, text: window.i18n('accept'), onClick: handleAcceptConversationRequest, dataTestId: "accept-button-settings-screen" })),
            react_1.default.createElement(Portal, null,
                react_1.default.createElement(ConversationListItemContextMenu_1.MemoConversationListItemContextMenu, { triggerId: triggerId })))));
};
exports.MemoMessageRequestListSetting = react_1.default.memo(MessageRequestListSetting, lodash_1.default.isEqual);
