"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsCategoryChat = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const useUpdate_1 = __importDefault(require("react-use/lib/useUpdate"));
const channelsItem_1 = require("../../../data/channelsItem");
const data_1 = require("../../../data/data");
const settings_key_1 = require("../../../data/settings-key");
const modalDialog_1 = require("../../../state/ducks/modalDialog");
const userConfig_1 = require("../../../state/ducks/userConfig");
const userConfig_2 = require("../../../state/selectors/userConfig");
const BchatButton_1 = require("../../basic/BchatButton");
const BchatSettingListItem_1 = require("../BchatSettingListItem");
const ChangeChatFontSetting_1 = require("../ChangeChatFontSetting");
const walletConfig_1 = require("../../../state/ducks/walletConfig");
const icon_1 = require("../../icon");
const SettingsCategoryChat = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const forceUpdate = (0, useUpdate_1.default)();
    const audioAutoPlay = (0, react_redux_1.useSelector)(userConfig_2.getAudioAutoplay);
    const chatwithWallet = window.getSettingValue(settings_key_1.SettingsKey.settingsChatWithWallet) || false;
    const isLinkPreviewsOn = Boolean(window.getSettingValue(settings_key_1.SettingsKey.settingsLinkPreview));
    if (props.hasPassword !== null) {
        async function toggleLinkPreviews() {
            const newValue = !window.getSettingValue(settings_key_1.SettingsKey.settingsLinkPreview);
            if (!newValue) {
                window.setSettingValue(settings_key_1.SettingsKey.settingsLinkPreview, newValue);
                await (0, channelsItem_1.createOrUpdateItem)({ id: data_1.hasLinkPreviewPopupBeenDisplayed, value: false });
            }
            else {
                window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
                    title: window.i18n('linkPreviewsTitle'),
                    message: window.i18n('linkPreviewsConfirmMessage'),
                    okTheme: BchatButton_1.BchatButtonColor.Primary,
                    onClickOk: () => {
                        window.setSettingValue(settings_key_1.SettingsKey.settingsLinkPreview, newValue);
                        forceUpdate();
                    },
                    iconShow: true,
                    customIcon: react_1.default.createElement(icon_1.BchatIcon, { iconType: "linkPreview", iconSize: 26 })
                }));
            }
        }
        function chatWithWallet() {
            window.setSettingValue(settings_key_1.SettingsKey.settingsChatWithWallet, !chatwithWallet);
            let data = false;
            dispatch((0, walletConfig_1.updatewalletSyncBarShowInChat)(data));
            forceUpdate();
        }
        function dispatchConfirmModal() {
            if (!chatwithWallet) {
                dispatch((0, modalDialog_1.updateBchatAlertConfirmModal)({
                    settings: true,
                    onClickOk: async () => {
                        chatWithWallet();
                        dispatch((0, modalDialog_1.updateBchatAlertConfirmModal)(null));
                    },
                    onClickCancel: () => dispatch((0, modalDialog_1.updateBchatAlertConfirmModal)(null)),
                }));
            }
            else {
                chatWithWallet();
            }
        }
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { className: 'bgWrapper' },
                ' ',
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: () => dispatchConfirmModal(), title: window.i18n('chatWithWallet'), description: window.i18n('chatWithWalletDisc'), active: chatwithWallet, iconType: 'chatWithLogo' }),
                react_1.default.createElement(ChangeChatFontSetting_1.ChangeChatFontSetting, null),
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: () => {
                        dispatch((0, userConfig_1.toggleAudioAutoplay)());
                        forceUpdate();
                    }, title: window.i18n('audioMessageAutoplayTitle'), description: window.i18n('audioMessageAutoplayDescription'), active: audioAutoPlay, iconType: "microphone" }),
                react_1.default.createElement(BchatSettingListItem_1.BchatToggleWithDescription, { onClickToggle: async () => {
                        await toggleLinkPreviews();
                        forceUpdate();
                    }, title: window.i18n('linkPreviewsTitle'), description: window.i18n('linkPreviewDescription'), active: isLinkPreviewsOn, iconType: "chainLink" }))));
    }
    return null;
};
exports.SettingsCategoryChat = SettingsCategoryChat;
