"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletBalanceSection = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const utils_1 = require("../../bchat/utils");
const walletConfig_1 = require("../../state/selectors/walletConfig");
const Text_1 = require("../basic/Text");
const BchatIcon_1 = require("../icon/BchatIcon");
const ActionsPanel_1 = require("../leftpane/ActionsPanel");
const settings_key_1 = require("../../data/settings-key");
const Flex_1 = require("../basic/Flex");
const icon_1 = require("../icon");
const { clipboard } = require('electron');
const WalletBalanceSection = () => {
    const walletDetails = (0, react_redux_1.useSelector)((state) => state.wallet);
    const walletAddress = localStorage.getItem('userAddress');
    const currency = window.getSettingValue(settings_key_1.walletSettingsKey.settingsFiatCurrency);
    const fiatBalance = Number((0, react_redux_1.useSelector)(walletConfig_1.getFiatBalance));
    const [amountVisible, setAmountVisible] = (0, react_1.useState)(window.getSettingValue('balancevisibility'));
    let decimalValue = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDecimal) || '2 - Two (0.00)';
    decimalValue = decimalValue.charAt(0);
    const handlePaste = () => {
        clipboard.writeText(walletAddress, 'clipboard');
        utils_1.ToastUtils.pushCopiedToClipBoard();
    };
    function disableBalac(values) {
        if (amountVisible) {
            return values;
        }
        let txt = String(values);
        let sliptStr = txt.split('');
        let dataArray = '';
        sliptStr.length > 0 &&
            sliptStr.map((item) => {
                if (item === '.') {
                    dataArray = dataArray + '.';
                    return;
                }
                dataArray = dataArray + '*';
            });
        return dataArray;
    }
    return (react_1.default.createElement("div", { className: "wallet-squarBox-bala" },
        react_1.default.createElement("div", { className: "innerWrapper" },
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", justifyContent: "space-between" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement("div", { className: "flexCenter" },
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: 24, iconType: "wallet" }),
                        react_1.default.createElement("div", { className: "wallet-left-balance-Sec-balanceTxt marginLeft" },
                            disableBalac((walletDetails.balance / 1e9).toFixed(decimalValue)),
                            ' ',
                            react_1.default.createElement("span", { className: "marginRight", style: { color: '#128b17' } }, "BDX")),
                        react_1.default.createElement("span", { onClick: () => {
                                setAmountVisible(!amountVisible);
                                window.setSettingValue('balancevisibility', !amountVisible);
                            }, style: { cursor: 'pointer', marginBottom: '6px' } },
                            react_1.default.createElement(icon_1.BchatIconButton, { iconSize: 18, iconType: !amountVisible ? 'eye' : 'eye_closed', clipRule: 'evenodd', fillRule: 'evenodd' }))),
                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center", className: "wallet-left-balance-Sec", margin: '5px 0 0 0' },
                        react_1.default.createElement("div", { className: "currencyExt" }, currency),
                        react_1.default.createElement("div", { className: "currencyVal" },
                            disableBalac((fiatBalance / 1e9).toFixed(decimalValue)),
                            ' '))),
                react_1.default.createElement("div", { className: "wallet-right-Button-Sec-unlockbal-box" },
                    react_1.default.createElement("div", null,
                        react_1.default.createElement("span", { className: "wallet-right-Button-Sec-unlockbal-box--Text" }, "Unlocked Balance")),
                    react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "flex-end" },
                        react_1.default.createElement("span", { className: "unBalance" },
                            disableBalac((walletDetails.unlocked_balance / 1e9).toFixed(decimalValue)),
                            " BDX")))),
            react_1.default.createElement(Text_1.SpacerXS, null),
            react_1.default.createElement(Text_1.SpacerSM, null),
            react_1.default.createElement("div", { className: "wallet-myAddress-Box" },
                react_1.default.createElement("div", { className: "wallet-myAddress-Box-content" },
                    react_1.default.createElement("div", { className: 'addres-title' }, "Beldex Address"),
                    react_1.default.createElement("div", { className: 'address-txt' }, walletAddress)),
                react_1.default.createElement("div", { className: "wallet-myAddress-Box-copyIcon-box", "data-tip": "Copy", "data-place": "right", "data-offset": "{'top':30,'left':15}", onClick: handlePaste },
                    react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "copy", iconSize: 20, iconColor: '#00A638', clipRule: "evenodd", fillRule: "evenodd" })),
                react_1.default.createElement(ActionsPanel_1.BchatToolTip, { place: "top", effect: "solid" })))));
};
exports.WalletBalanceSection = WalletBalanceSection;
