"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChangePassword = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const utils_1 = require("../../bchat/utils");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const icon_1 = require("../icon");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const react_use_1 = require("react-use");
const BchatButton_1 = require("../basic/BchatButton");
const styled_components_1 = __importDefault(require("styled-components"));
const ChangePassword = () => {
    const [oldPassword, setOldPassword] = (0, react_1.useState)('');
    const [newPassword, setNewPassword] = (0, react_1.useState)('');
    const [confirmPassword, setConfirmNewPassword] = (0, react_1.useState)('');
    const [oldPasswordVisible, setOldPasswordVisible] = (0, react_1.useState)(true);
    const [newPasswordVisible, setNewPasswordVisible] = (0, react_1.useState)(true);
    const [confirmPasswordVisible, setConfirmNewPasswordVisible] = (0, react_1.useState)(true);
    const [loading, setLoading] = (0, react_1.useState)(false);
    const dispatch = (0, react_redux_1.useDispatch)();
    function onClickCancelHandler() {
        setLoading(false);
        dispatch((0, modalDialog_1.ChangePasswordModal)(null));
    }
    const passValid = async () => {
        if (!oldPassword || !newPassword || !confirmPassword) {
            return utils_1.ToastUtils.pushToastError('passwordFieldEmpty', window.i18n('passwordFieldEmpty'));
        }
        if (newPassword !== confirmPassword) {
            return utils_1.ToastUtils.pushToastError('invalidPassword', 'Passwords do not match');
        }
        if (oldPassword == newPassword) {
            window?.log?.warn('invalid password');
            return utils_1.ToastUtils.pushToastError('oldPasswordSame', `Cannot use old password. Set a different password.`);
        }
        if ((newPassword.length < 4 && confirmPassword.length < 4) ||
            (newPassword.length > 13 && confirmPassword.length > 13)) {
            return utils_1.ToastUtils.pushToastError('walletPasswordLengthError', window.i18n('walletPasswordLengthError'));
        }
        setLoading(true);
        const changePassword = await wallet_rpc_1.wallet.changeWalletPassword(oldPassword, newPassword);
        if (changePassword.hasOwnProperty('error')) {
            setLoading(false);
            return utils_1.ToastUtils.pushToastError('changePasswordError', changePassword.error.message);
        }
        wallet_rpc_1.wallet.wallet_state.password_hash = wallet_rpc_1.wallet.passwordEncrypt(newPassword);
        setLoading(false);
        utils_1.ToastUtils.pushToastSuccess('changePasswordSuccess', 'Password successfully changed.');
        return onClickCancelHandler();
    };
    (0, react_use_1.useKey)((event) => {
        return event.key === 'Enter';
    }, passValid);
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: window.i18n('changePassword'), onClose: () => onClickCancelHandler(), showExitIcon: false, headerReverse: false, showHeader: true, okButton: {
                text: window.i18n('save'),
                onClickOkHandler: passValid,
                color: BchatButton_1.BchatButtonColor.Primary,
            }, cancelButton: {
                status: true,
                text: window.i18n('cancel'),
                onClickCancelHandler,
            }, isloading: loading },
            react_1.default.createElement("div", { className: "bchat-modal__centered changepass", style: { width: '475px', alignItems: 'start' } },
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: 'row', alignItems: "center", width: "100%", className: "changepass-oldpassInput" },
                    react_1.default.createElement("span", null,
                        react_1.default.createElement("input", { value: oldPassword, onChange: e => {
                                setOldPassword(e.target.value);
                            }, type: oldPasswordVisible ? 'password' : 'text', placeholder: window.i18n('currentPassword'), maxLength: 13 })),
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: !oldPasswordVisible ? 'eye_closed' : 'eye', iconSize: 'medium', fillRule: "evenodd", clipRule: "evenodd", onClick: () => setOldPasswordVisible(!oldPasswordVisible) })),
                react_1.default.createElement(Text_1.SpacerMD, null),
                react_1.default.createElement(NewPasswordLabel, null, window.i18n('newwalletPassword')),
                react_1.default.createElement(Text_1.SpacerSM, null),
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: 'row', alignItems: "center", width: "100%", className: "changepass-newPassInput" },
                    react_1.default.createElement("span", null,
                        react_1.default.createElement("input", { value: newPassword, onChange: e => {
                                setNewPassword(e.target.value);
                            }, placeholder: window.i18n('enterNewPassword'), type: newPasswordVisible ? 'password' : 'text', maxLength: 13 })),
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: !newPasswordVisible ? 'eye_closed' : 'eye', iconSize: 'medium', fillRule: "evenodd", clipRule: "evenodd", onClick: () => setNewPasswordVisible(!newPasswordVisible) })),
                react_1.default.createElement(Text_1.SpacerSM, null),
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: 'row', alignItems: "center", width: "100%", className: "changepass-newPassInput" },
                    react_1.default.createElement("span", null,
                        react_1.default.createElement("input", { value: confirmPassword, onChange: e => {
                                setConfirmNewPassword(e.target.value);
                            }, placeholder: window.i18n('confirmPassword'), type: confirmPasswordVisible ? 'password' : 'text', maxLength: 13 })),
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: !confirmPasswordVisible ? 'eye_closed' : 'eye', iconSize: 'medium', fillRule: "evenodd", clipRule: "evenodd", onClick: () => setConfirmNewPasswordVisible(!confirmPasswordVisible) }))),
            react_1.default.createElement(Text_1.SpacerMD, null),
            react_1.default.createElement(Text_1.SpacerMD, null))));
};
exports.ChangePassword = ChangePassword;
const NewPasswordLabel = styled_components_1.default.div `
  font-size: 16px;
  font-style: normal;
  font-weight: 400;
  line-height: normal;
`;
