"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InsufficientBalanceModal = void 0;
const react_1 = __importDefault(require("react"));
const Text_1 = require("../basic/Text");
const BchatWrapperModal_1 = require("../BchatWrapperModal");
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const theme_1 = require("../../state/selectors/theme");
const styled_components_1 = __importDefault(require("styled-components"));
const BchatButton_1 = require("../basic/BchatButton");
const InsufficientBalanceModal = (props) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(BchatWrapperModal_1.BchatWrapperModal, { title: '', onClose: props.onClose, showExitIcon: false, headerReverse: true, showHeader: false, okButton: {
                text: 'OK',
                color: BchatButton_1.BchatButtonColor.Primary,
                onClickOkHandler: () => {
                    dispatch((0, modalDialog_1.updateInsufficientBalanceModal)(null));
                },
                disabled: false,
            } },
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "bchat-modal__centered" },
                react_1.default.createElement("div", { style: { width: "430px", height: '155px' } },
                    react_1.default.createElement("div", { style: { marginTop: '10px' } },
                        react_1.default.createElement("img", { src: darkMode ? 'images/bchat/insufficientBalance.svg' : 'images/bchat/insufficientBalanceWhite.svg', style: { width: '70px', height: '70px' } })),
                    react_1.default.createElement(TxnInit, null, "Insufficient Balance!"),
                    react_1.default.createElement(Subtxt, null, "You have insufficient funds to make a transaction"))),
            react_1.default.createElement(Text_1.SpacerMD, null))));
};
exports.InsufficientBalanceModal = InsufficientBalanceModal;
const TxnInit = styled_components_1.default.div `
//   color: #108d32;
  text-align: center;
  font-family: Poppins;
  font-size: 20px;
  font-style: normal;
  font-weight: 700;
  line-height: normal;
  width: 475px;
  margin-top: 15px;

`;
const Subtxt = styled_components_1.default.div `
  color: #A7A7BA;
  margin-top: 5px;
  line-height: 17px;`;
