"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalDeamon = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const BchatButton_1 = require("../basic/BchatButton");
const BchatWalletHelper_1 = require("../../wallet/BchatWalletHelper");
const settings_key_1 = require("../../data/settings-key");
const utils_1 = require("../../bchat/utils");
const BchatIcon_1 = require("../icon/BchatIcon");
const react_use_1 = require("react-use");
const react_redux_1 = require("react-redux");
const walletConfig_1 = require("../../state/ducks/walletConfig");
const wallet_1 = require("../../state/ducks/wallet");
function LocalDeamon() {
    const localDeamonHost = '127.0.0.1';
    const [localDeamonPort, setLocalDeamonPort] = (0, react_1.useState)('');
    const [testNotify, setTestNotify] = (0, react_1.useState)('');
    const [verifyDeamon, setvSerifyDeamon] = (0, react_1.useState)({});
    const dispatch = (0, react_redux_1.useDispatch)();
    async function validationForDeamon() {
        let data = { host: localDeamonHost, port: localDeamonPort, active: 1, type: 'Local' };
        const confirmation = await (0, BchatWalletHelper_1.workingStatusForDeamon)(data, 'daemonValidation');
        if (confirmation && confirmation.status === 'OK') {
            setvSerifyDeamon(data);
            setTestNotify(`Success`);
            return;
        }
        setTestNotify(`Error`);
    }
    (0, react_use_1.useKey)((event) => {
        if (event.key === 'Enter') {
            if (localDeamonPort) {
                validationForDeamon();
            }
            if (Object.keys(verifyDeamon).length !== 0) {
                addDeamonNet();
            }
        }
        return event.key === 'Enter';
    });
    function addDeamonNet() {
        let data = verifyDeamon;
        if (Object.keys(data).length === 0) {
            return;
        }
        const currentDaemon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon);
        if (currentDaemon.host == data.host) {
            return utils_1.ToastUtils.pushToastInfo('localAlreadyAdded', `Local daemon already connected.`);
        }
        let rescan = true;
        let Transactions = '';
        let wallHeight = 0;
        dispatch((0, wallet_1.updateBalance)({
            balance: 0,
            unlocked_balance: 0,
            transacations: [],
        }));
        dispatch((0, walletConfig_1.updateWalletRescaning)(rescan));
        dispatch((0, walletConfig_1.updateFiatBalance)(Transactions));
        window.setSettingValue('syncStatus', false);
        dispatch((0, walletConfig_1.updateWalletHeight)(wallHeight));
        setLocalDeamonPort('');
        setTestNotify('');
        setvSerifyDeamon({});
        window.setSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon, verifyDeamon);
        return utils_1.ToastUtils.pushToastSuccess('successfully-added-daemon', `Successfully ${data.host}:${data.port} daemon added.`);
    }
    function portValidation(value) {
        const regex = /^[0-9\b]+$/;
        if (value === '' || regex.test(value)) {
            setLocalDeamonPort(value);
            setTestNotify('');
            setvSerifyDeamon({});
        }
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: (0, classnames_1.default)('wallet-settings-nodeSetting-remoteContentBox-content-hidden-Box'), style: { display: 'block' } },
            react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between" },
                react_1.default.createElement("article", { className: "wallet-settings-nodeSetting-remoteContentBox" },
                    react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-labelTxt" }, window.i18n('localNodeHost')),
                    react_1.default.createElement("input", { value: localDeamonHost, placeholder: "Enter your IP address", className: "wallet-settings-nodeSetting-remoteContentBox-inputBox", disabled: true })),
                react_1.default.createElement("article", { className: "wallet-settings-nodeSetting-remoteContentBox" },
                    react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-labelTxt" }, window.i18n('localNodePort')),
                    react_1.default.createElement("input", { value: localDeamonPort, className: "wallet-settings-nodeSetting-remoteContentBox-inputBox-input", onChange: (e) => {
                            portValidation(e.target.value);
                        }, placeholder: "Enter your port", maxLength: 5 }))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-FlexBox wallet-settings-nodeSetting-remoteContentBox-btnBox" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: !localDeamonPort ? BchatButton_1.BchatButtonColor.Secondary : BchatButton_1.BchatButtonColor.Primary, text: window.i18n('test'), onClick: () => localDeamonPort && validationForDeamon(), style: { cursor: !localDeamonPort ? 'default' : 'pointer' } })),
                react_1.default.createElement("div", { style: { marginRight: '20px' } }),
                react_1.default.createElement("div", null,
                    react_1.default.createElement(BchatButton_1.BchatButton, { buttonColor: Object.keys(verifyDeamon).length === 0
                            ? BchatButton_1.BchatButtonColor.Secondary
                            : BchatButton_1.BchatButtonColor.Primary, buttonType: BchatButton_1.BchatButtonType.Brand, text: window.i18n('save'), onClick: () => Object.keys(verifyDeamon).length !== 0 && addDeamonNet(), style: { cursor: Object.keys(verifyDeamon).length === 0 ? 'default' : 'pointer' } }))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            testNotify && (react_1.default.createElement("div", { className: "wallet-settings-nodeSetting-remoteContentBox-warning-box" },
                react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement("span", { className: "result" }, window.i18n('NodeTestResult')),
                    testNotify === 'Success' ? (react_1.default.createElement("span", { className: "result-msg" }, testNotify)) : (react_1.default.createElement("span", { className: "result-msg" },
                        "Connection : ",
                        react_1.default.createElement("span", { className: "error-msg" }, testNotify))),
                    react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: testNotify === 'Success' ? 'tickCircle' : 'warning', iconSize: 20, iconColor: testNotify === 'Success' ? 'green' : 'red', iconPadding: '0 0 0 3px' })))))));
}
exports.LocalDeamon = LocalDeamon;
