"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SendForm = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const walletConfig_1 = require("../../state/selectors/walletConfig");
const BchatButton_1 = require("../basic/BchatButton");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const utils_1 = require("../../bchat/utils");
const data_1 = require("../../data/data");
const settings_key_1 = require("../../data/settings-key");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const walletConfig_2 = require("../../state/ducks/walletConfig");
const react_use_1 = require("react-use");
const modal_1 = require("../../state/selectors/modal");
const icon_1 = require("../icon");
const SendForm = (props) => {
    const sendAddress = (0, react_redux_1.useSelector)(walletConfig_1.getWalletSendAddress);
    const syncStatus = (0, react_redux_1.useSelector)(walletConfig_1.getRescaning);
    const dispatch = (0, react_redux_1.useDispatch)();
    const [address, setAddress] = (0, react_1.useState)(sendAddress);
    const priority = window.getSettingValue(settings_key_1.walletSettingsKey.settingsPriority) || 'Flash';
    let decimalValue = (0, react_redux_1.useSelector)(walletConfig_1.getwalletDecimalValue);
    const walletDetails = (0, react_redux_1.useSelector)((state) => state.wallet);
    const BchatSendConfirmState = (0, react_redux_1.useSelector)(modal_1.getwalletSendConfirmModal);
    const zoomLevel = window.getSettingValue('zoom-factor-setting');
    const validZoomLevel = window.screen.width <= 1920 && zoomLevel > 100;
    function clearStateValue() {
        props.setAmount('');
        setAddress('');
        props.setNotes('');
        let emtStr = '';
        dispatch((0, walletConfig_2.updateSendAddress)(emtStr));
    }
    const modalRef = (0, react_1.useRef)(null);
    (0, react_1.useEffect)(() => {
        document.addEventListener('click', handleClick);
        setAddress(sendAddress);
        return () => {
            document.removeEventListener('click', handleClick);
        };
    }, [sendAddress]);
    const handleClick = (e) => {
        if (!modalRef.current?.contains(e.target)) {
        }
    };
    (0, react_use_1.useKey)((event) => {
        if (props.amount && address && syncStatus && event.key === 'Enter') {
            addressValidation();
        }
        return event.key === 'Enter';
    });
    async function addressValidation() {
        if (!window.globalOnlineStatus) {
            utils_1.ToastUtils.pushToastError('internetConnectionError', 'Please check your internet connection');
            return;
        }
        if (props.amount > walletDetails.unlocked_balance / 1e9) {
            return utils_1.ToastUtils.pushToastError('notEnoughBalance', 'Not enough unlocked balance');
        }
        if ((address.length > 106 || address.length < 95) && !address.toLowerCase().endsWith('.bdx')) {
            return utils_1.ToastUtils.pushToastError('invalidAddress', 'Invalid address');
        }
        if (props.amount == 0) {
            return utils_1.ToastUtils.pushToastError('zeroAmount', 'Amount must be greater than zero');
        }
        let addressValidate = await wallet_rpc_1.wallet.validateAddres(address);
        if (!address.toLowerCase().endsWith('.bdx') && !addressValidate) {
            return utils_1.ToastUtils.pushToastError('invalidAddress', 'Invalid address');
        }
        !BchatSendConfirmState && sendConfirmModal();
    }
    function sendConfirmModal() {
        dispatch((0, modalDialog_1.updateSendConfirmModal)({
            okTheme: BchatButton_1.BchatButtonColor.Green,
            address: address,
            amount: props.amount,
            fee: priority === 'Flash' ? 0.0042 : 0.0014,
            Priority: priority,
            onClickOk: async () => {
                await send();
            },
            onClickClose: () => {
                dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
            },
        }));
    }
    async function send() {
        const isSweepAll = props.amount == (walletDetails.unlocked_balance / 1e9).toFixed(decimalValue.charAt(0));
        dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
        dispatch((0, modalDialog_1.updateTransactionInitModal)({}));
        let data = await wallet_rpc_1.wallet.transfer(address, props.amount * 1e9, priority === 'Flash' ? 0 : 1, isSweepAll);
        if (data.result) {
            const TransactionHistory = {
                tx_hash: data.result.tx_hash_list[0],
                address: address,
            };
            let getSettingvalue = window.getSettingValue(settings_key_1.walletSettingsKey.settingSaveRecipient);
            if (getSettingvalue) {
                await (0, data_1.saveRecipientAddress)(TransactionHistory);
            }
            clearStateValue();
            dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
            dispatch((0, modalDialog_1.updateTransactionInitModal)(null));
            utils_1.ToastUtils.pushToastSuccess('successfully-sended', `Your transaction was successful.`);
        }
        else {
            clearStateValue();
            dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
            dispatch((0, modalDialog_1.updateTransactionInitModal)(null));
            if (data.error) {
                return utils_1.ToastUtils.pushToastError('invalidAddress', data.error.message);
            }
        }
    }
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: "wallet-sendForm" },
            react_1.default.createElement("span", { className: "wallet-sendForm-label" }, window.i18n('amount')),
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", justifyContent: "space-between", alignItems: "center", flexWrap: validZoomLevel ? 'wrap' : 'nowrap' },
                react_1.default.createElement("div", { className: "wallet-sendForm-inputBox", style: { width: '90%' } },
                    react_1.default.createElement("input", { value: props.amount, onChange: (e) => {
                            props.setAmount(e.target.value);
                        }, placeholder: window.i18n('enterAmount'), type: "text", maxLength: 16 }),
                    react_1.default.createElement(BchatButton_1.BchatButton, { text: "All", buttonType: BchatButton_1.BchatButtonType.Medium, buttonColor: BchatButton_1.BchatButtonColor.Success, style: { minWidth: '50px', height: '30px' }, onClick: () => props.fillAmount() })),
                react_1.default.createElement("div", { ref: modalRef },
                    react_1.default.createElement("div", { className: "wallet-sendForm-priorty-wrapper", style: { marginTop: validZoomLevel ? '15px' : '' } },
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: 'lightning', iconSize: 16 }),
                        react_1.default.createElement("span", { className: "txt" }, priority)))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", null,
                react_1.default.createElement("span", { className: "wallet-sendForm-label" }, "Address or BNS Name"),
                react_1.default.createElement("div", { className: "wallet-sendForm-inputBox" },
                    react_1.default.createElement("textarea", { value: address, placeholder: "Enter Beldex address or BNS Name", className: "wallet-sendForm-textArea", onChange: (e) => {
                            setAddress(e.target.value);
                        }, maxLength: 120 }))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", null,
                react_1.default.createElement("span", { className: "wallet-sendForm-label" }, window.i18n('notes')),
                react_1.default.createElement("div", { className: "wallet-sendForm-inputBox" },
                    react_1.default.createElement("textarea", { value: props.notes, onChange: (e) => {
                            props.setNotes(e.target.value);
                        }, placeholder: "Add notes (optional)", className: "wallet-sendForm-textArea" }))),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement("div", { className: "wallet-sendForm-sendBtnBox" },
                react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('send'), onClick: () => addressValidation(), buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Primary, disabled: !(props.amount && address && syncStatus && props.amount >= 0.1) })))));
};
exports.SendForm = SendForm;
