"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletSettings = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const settings_key_1 = require("../../data/settings-key");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const walletConfig_1 = require("../../state/ducks/walletConfig");
const walletConfig_2 = require("../../state/selectors/walletConfig");
const wallet_rpc_1 = require("../../wallet/wallet-rpc");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const BchatIcon_1 = require("../icon/BchatIcon");
const BchatWalletNodeSetting_1 = require("./BchatWalletNodeSetting");
const WalletSettings = () => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const decimalValue = (0, react_redux_1.useSelector)(walletConfig_2.getwalletDecimalValue);
    const priority = window.getSettingValue(settings_key_1.walletSettingsKey.settingsPriority) || "Flash";
    const [priorityStatus, setPriorityStatus] = (0, react_1.useState)(priority);
    const [saveRecipient, setSaveRecipient] = (0, react_1.useState)(window.getSettingValue(settings_key_1.walletSettingsKey.settingSaveRecipient));
    const [nodeSetting, setNodeSetting] = (0, react_1.useState)(false);
    const syncProDone = window.getSettingValue('syncStatus');
    const [fiatCurrency, setFiatCurrency] = (0, react_1.useState)(window.getSettingValue(settings_key_1.walletSettingsKey.settingsFiatCurrency));
    const connectedDeamon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon);
    const currenyExt = [
        'AUD',
        'BRL',
        'CAD',
        'CHF',
        'CNY',
        'CZK',
        'EUR',
        'DKK',
        'GBP',
        'HKD',
        'HUF',
        'IDR',
        'ILS',
        'INR',
        'JPY',
        'KRW',
        'MXN',
        'MYR',
        'NOK',
        'NZD',
        'PHP',
        'PLN',
        'RUB',
        'SEK',
        'SGD',
        'THB',
        'USD',
        'VEF',
        'ZAR',
    ];
    const decimal = ['0 - Zero (0)', '2 - Two (0.00)', '3 - Three (0.000)', '4 - Four (0.0000)'];
    function changepass() {
        if (syncProDone) {
            dispatch((0, modalDialog_1.ChangePasswordModal)({}));
        }
    }
    function enbaleOrdisableSaveRecipient() {
        window.setSettingValue(settings_key_1.walletSettingsKey.settingSaveRecipient, !saveRecipient);
        setSaveRecipient(!saveRecipient);
    }
    if (nodeSetting) {
        return react_1.default.createElement("div", { className: 'wallet' },
            react_1.default.createElement(BchatWalletNodeSetting_1.NodeSetting, { onClick: () => setNodeSetting(false) }));
    }
    return (react_1.default.createElement("div", { className: "" },
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "wallet-settings-tabBox-title" }, window.i18n('node')),
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement("div", { className: "wallet-settings-tabBox" },
            react_1.default.createElement("div", { className: "subBox" },
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", padding: "10px 0", cursor: "pointer", onClick: () => setNodeSetting(true) },
                    react_1.default.createElement("div", { className: "wallet-settings-tabBox-subtle" },
                        react_1.default.createElement("span", { style: { marginRight: '10px' } },
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "currentRpcNodeIcon", iconSize: 18 })),
                        window.i18n('nCurrentRPCTxt')),
                    react_1.default.createElement("div", { style: { cursor: 'pointer' } },
                        react_1.default.createElement("span", { className: "wallet-settings-tabBox-disableText" }, connectedDeamon ? `${connectedDeamon?.host}:${connectedDeamon?.port}` : "Please check your internet connection"),
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: "medium", iconType: "chevron", iconRotation: 270 }))))),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "wallet-settings-tabBox-title" }, window.i18n('WalletSettingsTitle')),
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement("div", { className: "wallet-settings-tabBox" },
            react_1.default.createElement("div", { className: "subBox" },
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", padding: "10px 0", cursor: "pointer", onClick: () => dispatch((0, modalDialog_1.walletSettingMiniModal)({
                        headerName: window.i18n('priority'),
                        content: ["Flash", 'Slow'],
                        currency: priorityStatus,
                        onClose: () => dispatch((0, modalDialog_1.walletSettingMiniModal)(null)),
                        onClick: (e) => {
                            dispatch((0, modalDialog_1.walletSettingMiniModal)(null));
                            window.setSettingValue(settings_key_1.walletSettingsKey.settingsPriority, e);
                            setPriorityStatus(e);
                        },
                    })) },
                    react_1.default.createElement("div", { className: "wallet-settings-tabBox-subtle" },
                        react_1.default.createElement("span", { style: { marginRight: '10px' } },
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "priorityIcon", iconSize: 18 })),
                        window.i18n('priority')),
                    react_1.default.createElement("div", { style: { cursor: 'pointer' } },
                        react_1.default.createElement("span", { className: "wallet-settings-tabBox-disableText" }, priorityStatus),
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: "medium", iconType: "chevron", iconRotation: 270 })))),
            react_1.default.createElement("div", { className: "subBox" },
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", padding: "10px 0", cursor: "pointer", onClick: () => dispatch((0, modalDialog_1.walletSettingMiniModal)({
                        headerName: window.i18n('decimals'),
                        content: decimal,
                        currency: decimalValue,
                        onClose: () => dispatch((0, modalDialog_1.walletSettingMiniModal)(null)),
                        onClick: (e) => {
                            dispatch((0, modalDialog_1.walletSettingMiniModal)(null));
                            window.inboxStore?.dispatch((0, walletConfig_1.updateDecimalValue)(e));
                            window.setSettingValue(settings_key_1.walletSettingsKey.settingsDecimal, e);
                        },
                    })) },
                    react_1.default.createElement("div", { className: "wallet-settings-tabBox-subtle" },
                        react_1.default.createElement("span", { style: { marginRight: '10px' } },
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "decimalsIcon", iconSize: 18 })),
                        window.i18n('decimals')),
                    react_1.default.createElement("div", { style: { cursor: 'pointer' } },
                        react_1.default.createElement("span", { className: "wallet-settings-tabBox-disableText" }, decimalValue),
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: "medium", iconType: "chevron", iconRotation: 270 })))),
            react_1.default.createElement("div", { className: "subBox" },
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", padding: "10px 0", cursor: "pointer", onClick: () => dispatch((0, modalDialog_1.walletSettingMiniModal)({
                        headerName: window.i18n('displayCurrency'),
                        content: currenyExt,
                        currency: fiatCurrency,
                        needSearch: true,
                        onClose: () => dispatch((0, modalDialog_1.walletSettingMiniModal)(null)),
                        onClick: (e) => {
                            window.setSettingValue(settings_key_1.walletSettingsKey.settingsFiatCurrency, e);
                            wallet_rpc_1.wallet.getFiatBalance(e);
                            setFiatCurrency(e);
                            dispatch((0, modalDialog_1.walletSettingMiniModal)(null));
                        },
                    })) },
                    react_1.default.createElement("div", { className: "wallet-settings-tabBox-subtle" },
                        react_1.default.createElement("span", { style: { marginRight: '10px' } },
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "displayCurrency", iconSize: 18 })),
                        window.i18n('displayCurrency')),
                    react_1.default.createElement("div", { style: { cursor: 'pointer' } },
                        react_1.default.createElement("span", { className: "wallet-settings-tabBox-disableText" }, window.getSettingValue(settings_key_1.walletSettingsKey.settingsFiatCurrency)),
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: "medium", iconType: "chevron", iconRotation: 270 })))),
            react_1.default.createElement("div", { className: "subBox" },
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", padding: "10px 0", cursor: "pointer", onClick: () => enbaleOrdisableSaveRecipient() },
                    react_1.default.createElement("div", { className: "wallet-settings-tabBox-subtle" },
                        react_1.default.createElement("span", { style: { marginRight: '10px' } },
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "saveRecipientAddress", iconSize: 18 })),
                        window.i18n('saveRecipientAddress')),
                    react_1.default.createElement("div", { style: { display: 'flex', alignItems: 'center' } }, saveRecipient ? (react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "tickCircle", iconColor: "#FFF", iconSize: 16, iconPadding: '3px', backgroundColor: '#159B24', borderRadius: '5px' })) : (react_1.default.createElement("div", { className: "wallet-settings-tabBox-checkBox" })))))),
        react_1.default.createElement(Text_1.SpacerLG, null),
        react_1.default.createElement("div", { className: "wallet-settings-tabBox-title" }, window.i18n('personal')),
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement("div", { className: "wallet-settings-tabBox" },
            react_1.default.createElement("div", { className: "subBox" },
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", padding: "10px 0", cursor: syncProDone ? 'pointer' : 'not-allowed', onClick: () => changepass() },
                    react_1.default.createElement("div", { className: "wallet-settings-tabBox-subtle" },
                        react_1.default.createElement("span", { style: { marginRight: '10px' } },
                            react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "changePasswordIcon", iconSize: 18 })),
                        window.i18n('changePassword')),
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconSize: "medium", iconType: "chevron", iconRotation: 270 })))))));
};
exports.WalletSettings = WalletSettings;
