"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMessageCountByType = exports.getUnreadCountByConversation = exports.getUnreadByConversation = exports.getMessageBySenderAndTimestamp = exports.filterAlreadyFetchedOpengroupMessage = exports.getMessageBySenderAndSentAt = exports.getMessageById = exports.getMessageIdsFromServerIds = exports._removeMessages = exports.removeMessage = exports.saveMessages = exports.saveMessage = exports.updateLastHash = exports.saveSeenMessageHashes = exports.cleanLastHashes = exports.cleanSeenMessages = exports.searchMessagesInConversation = exports.searchMessages = exports.searchConversations = exports.getAllGroupsInvolvingId = exports.getPubkeysInPublicConversation = exports.getAllOpenGroupV1Conversations = exports.getAllConversations = exports.removeConversation = exports.updateWalletAddressInConversation = exports.updateConversationAddress = exports.updateConversation = exports.getConversationById = exports.saveConversation = exports.removeAllClosedGroupEncryptionKeyPairs = exports.addClosedGroupEncryptionKeyPair = exports.getLatestClosedGroupEncryptionKeyPair = exports.getAllEncryptionKeyPairsForGroup = exports.updateSwarmNodesForPubkey = exports.getSwarmNodesForPubkey = exports.generateAttachmentKeyIfEmpty = exports.updateGuardNodes = exports.getGuardNodes = exports.getPasswordHash = exports.removeDB = exports.close = exports.shutdown = exports.hasLinkPreviewPopupBeenDisplayed = exports.lastAvatarUploadTimestamp = exports.hasSyncedInitialConfigurationItem = exports.Data = exports.removeItemById = exports.getItemById = exports.getAllItems = exports.createOrUpdateItem = void 0;
exports.getLRUCache = exports.setLRUCache = exports.getRecipientAddress = exports.saveRecipientAddress = exports.fillWithTestData = exports.removeOneOpenGroupV1Message = exports.updateSnodePoolOnDb = exports.getSnodePoolFromDb = exports.SNODE_POOL_ITEM_ID = exports.getMessagesWithFileAttachments = exports.getMessagesWithVisualMediaAttachments = exports.removeOtherData = exports.cleanupOrphanedAttachments = exports.removeAllConversations = exports.removeAllWithOutRecipient = exports.removeAll = exports.removeAllAttachmentDownloadJobs = exports.removeAttachmentDownloadJob = exports.resetAttachmentDownloadPending = exports.setAttachmentDownloadJobPending = exports.saveAttachmentDownloadJob = exports.getNextAttachmentDownloadJobs = exports.removeAllUnprocessed = exports.removeUnprocessed = exports.updateUnprocessedWithData = exports.updateUnprocessedAttempts = exports.saveUnprocessed = exports.getUnprocessedById = exports.getAllUnprocessed = exports.getUnprocessedCount = exports.getNextExpiringMessage = exports.getOutgoingWithoutExpiresAt = exports.getExpiredMessages = exports.getMessagesBySentAt = exports.removeAllMessagesInConversation = exports.getSeenMessagesByHashList = exports.getLastHashBySnode = exports.hasConversationOutgoingMessage = exports.getFirstUnreadMessageWithMention = exports.getFirstUnreadMessageIdInConversation = exports.getMessageCount = exports.getOldestMessageInConversation = exports.getLastMessageInConversation = exports.getLastMessageIdInConversation = exports.getLastMessagesByConversation = exports.getCallMessagesByConversation = exports.getMessagesByConversation = void 0;
const lodash_1 = __importDefault(require("lodash"));
const conversation_1 = require("../models/conversation");
const message_1 = require("../models/message");
const conversations_1 = require("../bchat/conversations");
const crypto_1 = require("../bchat/crypto");
const expiringMessages_1 = require("../util/expiringMessages");
const storage_1 = require("../util/storage");
const channels_1 = require("./channels");
const channelsItem_1 = require("./channelsItem");
Object.defineProperty(exports, "createOrUpdateItem", { enumerable: true, get: function () { return channelsItem_1.createOrUpdateItem; } });
Object.defineProperty(exports, "getAllItems", { enumerable: true, get: function () { return channelsItem_1.getAllItems; } });
Object.defineProperty(exports, "getItemById", { enumerable: true, get: function () { return channelsItem_1.getItemById; } });
Object.defineProperty(exports, "removeItemById", { enumerable: true, get: function () { return channelsItem_1.removeItemById; } });
const dataInit = __importStar(require("./dataInit"));
const ERASE_SQL_KEY = 'erase-sql-key';
const ERASE_ATTACHMENTS_KEY = 'erase-attachments';
const CLEANUP_ORPHANED_ATTACHMENTS_KEY = 'cleanup-orphaned-attachments';
exports.Data = {
    shutdown,
    close,
    removeDB,
    getPasswordHash,
    createOrUpdateItem: channelsItem_1.createOrUpdateItem,
    getItemById: channelsItem_1.getItemById,
    getAllItems: channelsItem_1.getAllItems,
    removeItemById: channelsItem_1.removeItemById,
    getGuardNodes,
    updateGuardNodes,
    generateAttachmentKeyIfEmpty,
    getSwarmNodesForPubkey,
    updateSwarmNodesForPubkey,
    getAllEncryptionKeyPairsForGroup,
    getLatestClosedGroupEncryptionKeyPair,
    addClosedGroupEncryptionKeyPair,
    removeAllClosedGroupEncryptionKeyPairs,
    saveConversation,
    getConversationById,
    removeConversation,
    getAllConversations,
    getPubkeysInPublicConversation,
    searchConversations,
    searchMessages,
    searchMessagesInConversation,
    cleanSeenMessages,
    cleanLastHashes,
    saveSeenMessageHashes,
    updateLastHash,
    saveMessage,
    saveMessages,
    removeMessage,
    _removeMessages,
    getMessageIdsFromServerIds,
    getMessageById,
    getMessageBySenderAndSentAt,
    getMessageByServerId,
    filterAlreadyFetchedOpengroupMessage,
    getMessageBySenderAndTimestamp,
    getUnreadByConversation,
    getUnreadCountByConversation,
    getMessageCountByType,
    getMessagesByConversation,
    getLastMessagesByConversation,
    getLastMessageIdInConversation,
    getLastMessageInConversation,
    getOldestMessageInConversation,
    getMessageCount,
    getFirstUnreadMessageIdInConversation,
    getFirstUnreadMessageWithMention,
    hasConversationOutgoingMessage,
    getLastHashBySnode,
    getSeenMessagesByHashList,
    removeAllMessagesInConversation,
    getMessagesBySentAt,
    getExpiredMessages,
    getOutgoingWithoutExpiresAt,
    getNextExpiringMessage,
    getUnprocessedCount,
    getAllUnprocessed,
    getUnprocessedById,
    saveUnprocessed,
    updateUnprocessedAttempts,
    updateUnprocessedWithData,
    removeUnprocessed,
    removeAllUnprocessed,
    getNextAttachmentDownloadJobs,
    saveAttachmentDownloadJob,
    setAttachmentDownloadJobPending,
    resetAttachmentDownloadPending,
    removeAttachmentDownloadJob,
    removeAllAttachmentDownloadJobs,
    removeAll,
    removeAllConversations,
    cleanupOrphanedAttachments,
    removeOtherData,
    getMessagesWithVisualMediaAttachments,
    getMessagesWithFileAttachments,
    getSnodePoolFromDb,
    updateSnodePoolOnDb,
    fillWithTestData,
};
exports.hasSyncedInitialConfigurationItem = 'hasSyncedInitialConfigurationItem';
exports.lastAvatarUploadTimestamp = 'lastAvatarUploadTimestamp';
exports.hasLinkPreviewPopupBeenDisplayed = 'hasLinkPreviewPopupBeenDisplayed';
function _cleanData(data) {
    const keys = Object.keys(data);
    for (let index = 0, max = keys.length; index < max; index += 1) {
        const key = keys[index];
        const value = data[key];
        if (value === null || value === undefined) {
            continue;
        }
        if (lodash_1.default.isFunction(value.toNumber)) {
            data[key] = value.toNumber();
        }
        else if (lodash_1.default.isFunction(value)) {
            delete data[key];
        }
        else if (Array.isArray(value)) {
            data[key] = value.map(_cleanData);
        }
        else if (lodash_1.default.isObject(value) && value instanceof File) {
            data[key] = { name: value.name, path: value.path, size: value.size, type: value.type };
        }
        else if (lodash_1.default.isObject(value) && value instanceof ArrayBuffer) {
            window.log.error('Trying to save an ArrayBuffer to the db is most likely an error. This specific field should be removed before the cleanData call');
            continue;
        }
        else if (lodash_1.default.isObject(value)) {
            data[key] = _cleanData(value);
        }
        else if (lodash_1.default.isBoolean(value)) {
            data[key] = value ? 1 : 0;
        }
        else if (typeof value !== 'string' &&
            typeof value !== 'number' &&
            typeof value !== 'boolean') {
            window?.log?.info(`_cleanData: key ${key} had type ${typeof value}`);
        }
    }
    return data;
}
async function shutdown() {
    await dataInit._shutdown();
    await close();
}
exports.shutdown = shutdown;
async function close() {
    await channels_1.channels.close();
}
exports.close = close;
async function removeDB() {
    await channels_1.channels.removeDB();
}
exports.removeDB = removeDB;
async function getPasswordHash() {
    return channels_1.channels.getPasswordHash();
}
exports.getPasswordHash = getPasswordHash;
async function getGuardNodes() {
    return channels_1.channels.getGuardNodes();
}
exports.getGuardNodes = getGuardNodes;
async function updateGuardNodes(nodes) {
    return channels_1.channels.updateGuardNodes(nodes);
}
exports.updateGuardNodes = updateGuardNodes;
async function generateAttachmentKeyIfEmpty() {
    const existingKey = await (0, channelsItem_1.getItemById)('local_attachment_encrypted_key');
    if (!existingKey) {
        const sodium = await (0, crypto_1.getSodiumRenderer)();
        const encryptingKey = sodium.to_hex(sodium.randombytes_buf(32));
        await (0, channelsItem_1.createOrUpdateItem)({
            id: 'local_attachment_encrypted_key',
            value: encryptingKey,
        });
        await storage_1.Storage.put('local_attachment_encrypted_key', encryptingKey);
    }
}
exports.generateAttachmentKeyIfEmpty = generateAttachmentKeyIfEmpty;
async function getSwarmNodesForPubkey(pubkey) {
    return channels_1.channels.getSwarmNodesForPubkey(pubkey);
}
exports.getSwarmNodesForPubkey = getSwarmNodesForPubkey;
async function updateSwarmNodesForPubkey(pubkey, snodeEdKeys) {
    await channels_1.channels.updateSwarmNodesForPubkey(pubkey, snodeEdKeys);
}
exports.updateSwarmNodesForPubkey = updateSwarmNodesForPubkey;
async function getAllEncryptionKeyPairsForGroup(groupPublicKey) {
    const pubkey = groupPublicKey.key || groupPublicKey;
    return channels_1.channels.getAllEncryptionKeyPairsForGroup(pubkey);
}
exports.getAllEncryptionKeyPairsForGroup = getAllEncryptionKeyPairsForGroup;
async function getLatestClosedGroupEncryptionKeyPair(groupPublicKey) {
    return channels_1.channels.getLatestClosedGroupEncryptionKeyPair(groupPublicKey);
}
exports.getLatestClosedGroupEncryptionKeyPair = getLatestClosedGroupEncryptionKeyPair;
async function addClosedGroupEncryptionKeyPair(groupPublicKey, keypair) {
    await channels_1.channels.addClosedGroupEncryptionKeyPair(groupPublicKey, keypair);
}
exports.addClosedGroupEncryptionKeyPair = addClosedGroupEncryptionKeyPair;
async function removeAllClosedGroupEncryptionKeyPairs(groupPublicKey) {
    return channels_1.channels.removeAllClosedGroupEncryptionKeyPairs(groupPublicKey);
}
exports.removeAllClosedGroupEncryptionKeyPairs = removeAllClosedGroupEncryptionKeyPairs;
async function saveConversation(data) {
    const cleaned = lodash_1.default.omit(data, 'isOnline');
    await channels_1.channels.saveConversation(cleaned);
}
exports.saveConversation = saveConversation;
async function getConversationById(id) {
    const data = await channels_1.channels.getConversationById(id);
    if (data) {
        return new conversation_1.ConversationModel(data);
    }
    return undefined;
}
exports.getConversationById = getConversationById;
async function updateConversation(data) {
    const cleanedData = _cleanData(data);
    await channels_1.channels.updateConversation(cleanedData);
}
exports.updateConversation = updateConversation;
async function updateConversationAddress(data) {
    const cleanedData = _cleanData(data);
    await channels_1.channels.updateConversationAddress(cleanedData);
}
exports.updateConversationAddress = updateConversationAddress;
async function updateWalletAddressInConversation(data) {
    const cleanedData = _cleanData(data);
    await channels_1.channels.updateWalletAddressInConversation(cleanedData);
}
exports.updateWalletAddressInConversation = updateWalletAddressInConversation;
async function removeConversation(id) {
    const existing = await getConversationById(id);
    if (existing) {
        await channels_1.channels.removeConversation(id);
        await existing.cleanup();
    }
}
exports.removeConversation = removeConversation;
async function getAllConversations() {
    const conversations = await channels_1.channels.getAllConversations();
    const collection = new conversation_1.ConversationCollection();
    collection.add(conversations);
    return collection;
}
exports.getAllConversations = getAllConversations;
async function getAllOpenGroupV1Conversations() {
    const conversations = await channels_1.channels.getAllOpenGroupV1Conversations();
    const collection = new conversation_1.ConversationCollection();
    collection.add(conversations);
    return collection;
}
exports.getAllOpenGroupV1Conversations = getAllOpenGroupV1Conversations;
async function getPubkeysInPublicConversation(id) {
    return channels_1.channels.getPubkeysInPublicConversation(id);
}
exports.getPubkeysInPublicConversation = getPubkeysInPublicConversation;
async function getAllGroupsInvolvingId(id) {
    const conversations = await channels_1.channels.getAllGroupsInvolvingId(id);
    const collection = new conversation_1.ConversationCollection();
    collection.add(conversations);
    return collection;
}
exports.getAllGroupsInvolvingId = getAllGroupsInvolvingId;
async function searchConversations(query) {
    const conversations = await channels_1.channels.searchConversations(query);
    return conversations;
}
exports.searchConversations = searchConversations;
async function searchMessages(query, limit) {
    const messages = (await channels_1.channels.searchMessages(query, limit));
    return lodash_1.default.uniqWith(messages, (left, right) => {
        return left.id === right.id;
    });
}
exports.searchMessages = searchMessages;
async function searchMessagesInConversation(query, conversationId, limit) {
    const messages = (await channels_1.channels.searchMessagesInConversation(query, conversationId, limit));
    return messages;
}
exports.searchMessagesInConversation = searchMessagesInConversation;
async function cleanSeenMessages() {
    await channels_1.channels.cleanSeenMessages();
}
exports.cleanSeenMessages = cleanSeenMessages;
async function cleanLastHashes() {
    await channels_1.channels.cleanLastHashes();
}
exports.cleanLastHashes = cleanLastHashes;
async function saveSeenMessageHashes(data) {
    await channels_1.channels.saveSeenMessageHashes(_cleanData(data));
}
exports.saveSeenMessageHashes = saveSeenMessageHashes;
async function updateLastHash(data) {
    await channels_1.channels.updateLastHash(_cleanData(data));
}
exports.updateLastHash = updateLastHash;
async function saveMessage(data) {
    const cleanedData = _cleanData(data);
    const id = await channels_1.channels.saveMessage(cleanedData);
    expiringMessages_1.ExpirationTimerOptions.updateExpiringMessagesCheck();
    return id;
}
exports.saveMessage = saveMessage;
async function saveMessages(arrayOfMessages) {
    await channels_1.channels.saveMessages(_cleanData(arrayOfMessages));
}
exports.saveMessages = saveMessages;
async function removeMessage(id) {
    const message = await getMessageById(id, true);
    if (message) {
        await channels_1.channels.removeMessage(id);
        await message.cleanup();
    }
}
exports.removeMessage = removeMessage;
async function _removeMessages(ids) {
    await channels_1.channels.removeMessage(ids);
}
exports._removeMessages = _removeMessages;
async function getMessageIdsFromServerIds(serverIds, conversationId) {
    return channels_1.channels.getMessageIdsFromServerIds(serverIds, conversationId);
}
exports.getMessageIdsFromServerIds = getMessageIdsFromServerIds;
async function getMessageById(id, skipTimerInit = false) {
    const message = await channels_1.channels.getMessageById(id);
    if (!message) {
        return null;
    }
    if (skipTimerInit) {
        message.skipTimerInit = skipTimerInit;
    }
    let data = { id: message.conversationId, walletAddress: message.walletAddress };
    updateWalletAddressInConversation(data);
    return new message_1.MessageModel(message);
}
exports.getMessageById = getMessageById;
async function getMessageBySenderAndSentAt({ source, sentAt, }) {
    const messages = await channels_1.channels.getMessageBySenderAndSentAt({
        source,
        sentAt,
    });
    if (!messages || !messages.length) {
        return null;
    }
    return new message_1.MessageModel(messages[0]);
}
exports.getMessageBySenderAndSentAt = getMessageBySenderAndSentAt;
async function filterAlreadyFetchedOpengroupMessage(msgDetails) {
    const msgDetailsNotAlreadyThere = await channels_1.channels.filterAlreadyFetchedOpengroupMessage(msgDetails);
    return msgDetailsNotAlreadyThere || [];
}
exports.filterAlreadyFetchedOpengroupMessage = filterAlreadyFetchedOpengroupMessage;
async function getMessageBySenderAndTimestamp({ source, timestamp, }) {
    const messages = await channels_1.channels.getMessageBySenderAndTimestamp({
        source,
        timestamp,
    });
    if (!messages || !messages.length) {
        return null;
    }
    return new message_1.MessageModel(messages[0]);
}
exports.getMessageBySenderAndTimestamp = getMessageBySenderAndTimestamp;
async function getMessageByServerId(serverId, skipTimerInit = false) {
    const message = await channels_1.channels.getMessageByServerId(serverId);
    if (!message) {
        return null;
    }
    if (skipTimerInit) {
        message.skipTimerInit = skipTimerInit;
    }
    return new message_1.MessageModel(message);
}
async function getUnreadByConversation(conversationId) {
    const messages = await channels_1.channels.getUnreadByConversation(conversationId);
    return new message_1.MessageCollection(messages);
}
exports.getUnreadByConversation = getUnreadByConversation;
async function getUnreadCountByConversation(conversationId) {
    return channels_1.channels.getUnreadCountByConversation(conversationId);
}
exports.getUnreadCountByConversation = getUnreadCountByConversation;
async function getMessageCountByType(conversationId, type) {
    return channels_1.channels.getMessageCountByType(conversationId, type);
}
exports.getMessageCountByType = getMessageCountByType;
async function getMessagesByConversation(conversationId, { skipTimerInit = false, messageId = null }) {
    const messages = await channels_1.channels.getMessagesByConversation(conversationId, {
        messageId,
    });
    if (skipTimerInit) {
        for (const message of messages) {
            message.skipTimerInit = skipTimerInit;
        }
    }
    return new message_1.MessageCollection(messages);
}
exports.getMessagesByConversation = getMessagesByConversation;
async function getCallMessagesByConversation(conversationId) {
    const messages = await channels_1.channels.getMessagesByConversation(conversationId);
    const callNotifications = messages
        .filter((item) => "callNotificationType" in item);
    return callNotifications;
}
exports.getCallMessagesByConversation = getCallMessagesByConversation;
async function getLastMessagesByConversation(conversationId, limit, skipTimerInit) {
    const messages = await channels_1.channels.getLastMessagesByConversation(conversationId, limit);
    if (skipTimerInit) {
        for (const message of messages) {
            message.skipTimerInit = skipTimerInit;
        }
    }
    return new message_1.MessageCollection(messages);
}
exports.getLastMessagesByConversation = getLastMessagesByConversation;
async function getLastMessageIdInConversation(conversationId) {
    const collection = await getLastMessagesByConversation(conversationId, 1, true);
    return collection.models.length ? collection.models[0].id : null;
}
exports.getLastMessageIdInConversation = getLastMessageIdInConversation;
async function getLastMessageInConversation(conversationId) {
    const messages = await channels_1.channels.getLastMessagesByConversation(conversationId, 1);
    for (const message of messages) {
        message.skipTimerInit = true;
    }
    const collection = new message_1.MessageCollection(messages);
    return collection.length ? collection.models[0] : null;
}
exports.getLastMessageInConversation = getLastMessageInConversation;
async function getOldestMessageInConversation(conversationId) {
    const messages = await channels_1.channels.getOldestMessageInConversation(conversationId);
    for (const message of messages) {
        message.skipTimerInit = true;
    }
    const collection = new message_1.MessageCollection(messages);
    return collection.length ? collection.models[0] : null;
}
exports.getOldestMessageInConversation = getOldestMessageInConversation;
async function getMessageCount() {
    return channels_1.channels.getMessageCount();
}
exports.getMessageCount = getMessageCount;
async function getFirstUnreadMessageIdInConversation(conversationId) {
    return channels_1.channels.getFirstUnreadMessageIdInConversation(conversationId);
}
exports.getFirstUnreadMessageIdInConversation = getFirstUnreadMessageIdInConversation;
async function getFirstUnreadMessageWithMention(conversationId, ourPubkey) {
    return channels_1.channels.getFirstUnreadMessageWithMention(conversationId, ourPubkey);
}
exports.getFirstUnreadMessageWithMention = getFirstUnreadMessageWithMention;
async function hasConversationOutgoingMessage(conversationId) {
    return channels_1.channels.hasConversationOutgoingMessage(conversationId);
}
exports.hasConversationOutgoingMessage = hasConversationOutgoingMessage;
async function getLastHashBySnode(convoId, snode, namespace) {
    return channels_1.channels.getLastHashBySnode(convoId, snode, namespace);
}
exports.getLastHashBySnode = getLastHashBySnode;
async function getSeenMessagesByHashList(hashes) {
    return channels_1.channels.getSeenMessagesByHashList(hashes);
}
exports.getSeenMessagesByHashList = getSeenMessagesByHashList;
async function removeAllMessagesInConversation(conversationId) {
    let messages;
    do {
        messages = await getLastMessagesByConversation(conversationId, 500, false);
        if (!messages.length) {
            return;
        }
        const ids = messages.map(message => message.id);
        await Promise.all(messages.map(message => message.cleanup()));
        await channels_1.channels.removeMessage(ids);
    } while (messages.length > 0);
}
exports.removeAllMessagesInConversation = removeAllMessagesInConversation;
async function getMessagesBySentAt(sentAt) {
    const messages = await channels_1.channels.getMessagesBySentAt(sentAt);
    return new message_1.MessageCollection(messages);
}
exports.getMessagesBySentAt = getMessagesBySentAt;
async function getExpiredMessages() {
    const messages = await channels_1.channels.getExpiredMessages();
    return new message_1.MessageCollection(messages);
}
exports.getExpiredMessages = getExpiredMessages;
async function getOutgoingWithoutExpiresAt() {
    const messages = await channels_1.channels.getOutgoingWithoutExpiresAt();
    return new message_1.MessageCollection(messages);
}
exports.getOutgoingWithoutExpiresAt = getOutgoingWithoutExpiresAt;
async function getNextExpiringMessage() {
    const messages = await channels_1.channels.getNextExpiringMessage();
    return new message_1.MessageCollection(messages);
}
exports.getNextExpiringMessage = getNextExpiringMessage;
async function getUnprocessedCount() {
    return channels_1.channels.getUnprocessedCount();
}
exports.getUnprocessedCount = getUnprocessedCount;
async function getAllUnprocessed() {
    return channels_1.channels.getAllUnprocessed();
}
exports.getAllUnprocessed = getAllUnprocessed;
async function getUnprocessedById(id) {
    return channels_1.channels.getUnprocessedById(id);
}
exports.getUnprocessedById = getUnprocessedById;
async function saveUnprocessed(data) {
    const id = await channels_1.channels.saveUnprocessed(_cleanData(data));
    return id;
}
exports.saveUnprocessed = saveUnprocessed;
async function updateUnprocessedAttempts(id, attempts) {
    await channels_1.channels.updateUnprocessedAttempts(id, attempts);
}
exports.updateUnprocessedAttempts = updateUnprocessedAttempts;
async function updateUnprocessedWithData(id, data) {
    await channels_1.channels.updateUnprocessedWithData(id, data);
}
exports.updateUnprocessedWithData = updateUnprocessedWithData;
async function removeUnprocessed(id) {
    await channels_1.channels.removeUnprocessed(id);
}
exports.removeUnprocessed = removeUnprocessed;
async function removeAllUnprocessed() {
    await channels_1.channels.removeAllUnprocessed();
}
exports.removeAllUnprocessed = removeAllUnprocessed;
async function getNextAttachmentDownloadJobs(limit) {
    return channels_1.channels.getNextAttachmentDownloadJobs(limit);
}
exports.getNextAttachmentDownloadJobs = getNextAttachmentDownloadJobs;
async function saveAttachmentDownloadJob(job) {
    await channels_1.channels.saveAttachmentDownloadJob(job);
}
exports.saveAttachmentDownloadJob = saveAttachmentDownloadJob;
async function setAttachmentDownloadJobPending(id, pending) {
    await channels_1.channels.setAttachmentDownloadJobPending(id, pending ? 1 : 0);
}
exports.setAttachmentDownloadJobPending = setAttachmentDownloadJobPending;
async function resetAttachmentDownloadPending() {
    await channels_1.channels.resetAttachmentDownloadPending();
}
exports.resetAttachmentDownloadPending = resetAttachmentDownloadPending;
async function removeAttachmentDownloadJob(id) {
    await channels_1.channels.removeAttachmentDownloadJob(id);
}
exports.removeAttachmentDownloadJob = removeAttachmentDownloadJob;
async function removeAllAttachmentDownloadJobs() {
    await channels_1.channels.removeAllAttachmentDownloadJobs();
}
exports.removeAllAttachmentDownloadJobs = removeAllAttachmentDownloadJobs;
async function removeAll() {
    await channels_1.channels.removeAll();
}
exports.removeAll = removeAll;
async function removeAllWithOutRecipient() {
    await channels_1.channels.removeAllWithOutRecipient();
}
exports.removeAllWithOutRecipient = removeAllWithOutRecipient;
async function removeAllConversations() {
    await channels_1.channels.removeAllConversations();
}
exports.removeAllConversations = removeAllConversations;
async function cleanupOrphanedAttachments() {
    await dataInit.callChannel(CLEANUP_ORPHANED_ATTACHMENTS_KEY);
}
exports.cleanupOrphanedAttachments = cleanupOrphanedAttachments;
async function removeOtherData() {
    await Promise.all([
        dataInit.callChannel(ERASE_SQL_KEY),
        dataInit.callChannel(ERASE_ATTACHMENTS_KEY),
    ]);
}
exports.removeOtherData = removeOtherData;
async function getMessagesWithVisualMediaAttachments(conversationId, limit) {
    return channels_1.channels.getMessagesWithVisualMediaAttachments(conversationId, limit);
}
exports.getMessagesWithVisualMediaAttachments = getMessagesWithVisualMediaAttachments;
async function getMessagesWithFileAttachments(conversationId, limit) {
    return channels_1.channels.getMessagesWithFileAttachments(conversationId, limit);
}
exports.getMessagesWithFileAttachments = getMessagesWithFileAttachments;
exports.SNODE_POOL_ITEM_ID = 'MNODE_POOL_ITEM_ID';
async function getSnodePoolFromDb() {
    const snodesJson = await exports.getItemById(exports.SNODE_POOL_ITEM_ID);
    if (!snodesJson || !snodesJson.value) {
        return null;
    }
    return JSON.parse(snodesJson.value);
}
exports.getSnodePoolFromDb = getSnodePoolFromDb;
async function updateSnodePoolOnDb(snodesAsJsonString) {
    await exports.createOrUpdateItem({ id: exports.SNODE_POOL_ITEM_ID, value: snodesAsJsonString });
}
exports.updateSnodePoolOnDb = updateSnodePoolOnDb;
async function removeOneOpenGroupV1Message() {
    return channels_1.channels.removeOneOpenGroupV1Message();
}
exports.removeOneOpenGroupV1Message = removeOneOpenGroupV1Message;
async function fillWithTestData(convs, msgs) {
    const newConvos = [];
    for (let convsAddedCount = 0; convsAddedCount < convs; convsAddedCount++) {
        const convoId = `${Date.now()} + ${convsAddedCount}`;
        const newConvo = await (0, conversations_1.getConversationController)().getOrCreateAndWait(convoId, conversation_1.ConversationTypeEnum.PRIVATE);
        newConvos.push(newConvo);
    }
    for (let msgsAddedCount = 0; msgsAddedCount < msgs; msgsAddedCount++) {
        const convoToChoose = newConvos[Math.floor(Math.random() * newConvos.length)];
        const direction = Math.random() > 0.5 ? 'outgoing' : 'incoming';
        const body = `spongebob ${new Date().toString()}`;
        if (direction === 'outgoing') {
            await convoToChoose.addSingleOutgoingMessage({
                body,
            });
        }
        else {
            await convoToChoose.addSingleIncomingMessage({
                source: convoToChoose.id,
                body,
            });
        }
    }
}
exports.fillWithTestData = fillWithTestData;
async function saveRecipientAddress(data) {
    return await channels_1.channels.saveRecipientAddress(data);
}
exports.saveRecipientAddress = saveRecipientAddress;
async function getRecipientAddress(data) {
    return channels_1.channels.getRecipientAddress(data);
}
exports.getRecipientAddress = getRecipientAddress;
async function setLRUCache(data) {
    return await channels_1.channels.updateLRUCache(data);
}
exports.setLRUCache = setLRUCache;
async function getLRUCache(data) {
    return channels_1.channels.getLRUCache(data);
}
exports.getLRUCache = getLRUCache;
