"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useAudioPeaks = void 0;
const lodash_1 = require("lodash");
const react_1 = require("react");
const AudioPlayback_1 = require("../components/conversation/AudioPlayback");
const constants_1 = require("../bchat/constants");
function useAudioPeaks(audioUrl, barCount, slicedSrc, size) {
    const [waveformData, setWaveformData] = (0, react_1.useState)(undefined);
    (0, react_1.useEffect)(() => {
        if (!audioUrl) {
            return lodash_1.noop;
        }
        if (size < constants_1.DEFAULT_MIN_AUDIO_MEMORY_SIZE) {
            console.info('MessageAudio: memory size is too low');
            return;
        }
        console.info('MessageAudio: loading audio and computing waveform');
        let canceled = false;
        void (async () => {
            try {
                const { peaks: newPeaks, duration: newDuration } = await (0, AudioPlayback_1.computePeaks)(audioUrl, barCount, slicedSrc);
                if (canceled) {
                    return;
                }
                setWaveformData({
                    peaks: newPeaks,
                    duration: Math.max(newDuration, 1e-23),
                });
            }
            catch (err) {
                console.error('MessageAudio: computePeaks error,corrupted URL ' + audioUrl, err);
            }
        })();
        return () => {
            canceled = true;
        };
    }, [audioUrl, barCount]);
    return {
        duration: waveformData?.duration ?? 1e-23,
        hasPeaks: waveformData !== undefined,
        peaks: waveformData?.peaks ?? new Array(barCount).fill(0),
    };
}
exports.useAudioPeaks = useAudioPeaks;
