"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useModulo = void 0;
const react_1 = __importDefault(require("react"));
const useInterval_1 = __importDefault(require("react-use/lib/useInterval"));
function useModulo(loopBackAt, delay) {
    const [count, setCount] = react_1.default.useState(0);
    (0, useInterval_1.default)(() => {
        if (count >= loopBackAt) {
            setCount(0);
        }
        else {
            setCount(count + 1);
        }
    }, delay);
    return { count };
}
exports.useModulo = useModulo;
