"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useMessageReactsPropsById = exports.useConversationWalletDaemonHeight = exports.useConversationBeldexAddress = exports.useConversationPropsById = exports.useIsRequest = exports.useIsApproved = exports.useIsPinned = exports.useExpireTimer = exports.useWeAreAdmin = exports.useIsKickedFromGroup = exports.useIsLeft = exports.useIsBlocked = exports.useIsPublic = exports.useNotificationSetting = exports.useHasNickname = exports.useIsPrivate = exports.useIsClosedGroup = exports.useIsMe = exports.useOurConversationUsername = exports.useConversationsUsernameWithQuoteOrFullPubkey = exports.useConversationRealName = exports.useConversationUsernameOrShorten = exports.useConversationBnsHolder = exports.useConversationUsername = exports.useOurAvatarPath = exports.useAvatarPath = void 0;
const lodash_1 = __importDefault(require("lodash"));
const react_redux_1 = require("react-redux");
const conversation_1 = require("../models/conversation");
const types_1 = require("../bchat/types");
const utils_1 = require("../bchat/utils");
const conversations_1 = require("../state/selectors/conversations");
function useAvatarPath(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps?.avatarPath || null;
}
exports.useAvatarPath = useAvatarPath;
function useOurAvatarPath() {
    return useAvatarPath(utils_1.UserUtils.getOurPubKeyStrFromCache());
}
exports.useOurAvatarPath = useOurAvatarPath;
function useConversationUsername(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps?.profileName || convoProps?.name || convoId;
}
exports.useConversationUsername = useConversationUsername;
function useConversationBnsHolder(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps?.isBnsHolder;
}
exports.useConversationBnsHolder = useConversationBnsHolder;
function useConversationUsernameOrShorten(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps?.profileName || convoProps?.name || (convoId && types_1.PubKey.shorten(convoId));
}
exports.useConversationUsernameOrShorten = useConversationUsernameOrShorten;
function useConversationRealName(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps?.isPrivate ? convoProps?.name : undefined;
}
exports.useConversationRealName = useConversationRealName;
function useConversationsUsernameWithQuoteOrFullPubkey(pubkeys) {
    return (0, react_redux_1.useSelector)((state) => {
        return pubkeys.map(pubkey => {
            if (pubkey === utils_1.UserUtils.getOurPubKeyStrFromCache() || pubkey.toLowerCase() === 'you') {
                return window.i18n('you');
            }
            const convo = state.conversations.conversationLookup[pubkey];
            const nameGot = convo?.profileName || convo?.name;
            return nameGot?.length ? `${nameGot}` : pubkey;
        });
    });
}
exports.useConversationsUsernameWithQuoteOrFullPubkey = useConversationsUsernameWithQuoteOrFullPubkey;
function useOurConversationUsername() {
    return useConversationUsername(utils_1.UserUtils.getOurPubKeyStrFromCache());
}
exports.useOurConversationUsername = useOurConversationUsername;
function useIsMe(pubkey) {
    return Boolean(pubkey && pubkey === utils_1.UserUtils.getOurPubKeyStrFromCache());
}
exports.useIsMe = useIsMe;
function useIsClosedGroup(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return (convoProps && convoProps.isGroup && !convoProps.isPublic) || false;
}
exports.useIsClosedGroup = useIsClosedGroup;
function useIsPrivate(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.isPrivate);
}
exports.useIsPrivate = useIsPrivate;
function useHasNickname(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.hasNickname);
}
exports.useHasNickname = useHasNickname;
function useNotificationSetting(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps?.currentNotificationSetting || 'all';
}
exports.useNotificationSetting = useNotificationSetting;
function useIsPublic(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.isPublic);
}
exports.useIsPublic = useIsPublic;
function useIsBlocked(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.isBlocked);
}
exports.useIsBlocked = useIsBlocked;
function useIsLeft(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.left);
}
exports.useIsLeft = useIsLeft;
function useIsKickedFromGroup(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.isKickedFromGroup);
}
exports.useIsKickedFromGroup = useIsKickedFromGroup;
function useWeAreAdmin(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.weAreAdmin);
}
exports.useWeAreAdmin = useWeAreAdmin;
function useExpireTimer(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps && convoProps.expireTimer;
}
exports.useExpireTimer = useExpireTimer;
function useIsPinned(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.isPinned);
}
exports.useIsPinned = useIsPinned;
function useIsApproved(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps && convoProps.isApproved);
}
exports.useIsApproved = useIsApproved;
function useIsRequest(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return Boolean(convoProps &&
        conversation_1.ConversationModel.hasValidIncomingRequestValues(lodash_1.default.pick(convoProps, ['isMe', 'isApproved', 'isPrivate', 'isBlocked'])));
}
exports.useIsRequest = useIsRequest;
function useConversationPropsById(convoId) {
    return (0, react_redux_1.useSelector)((state) => {
        if (!convoId) {
            return null;
        }
        const convo = state.conversations.conversationLookup[convoId];
        if (!convo) {
            return null;
        }
        return convo;
    });
}
exports.useConversationPropsById = useConversationPropsById;
function useConversationBeldexAddress(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps?.walletAddress;
}
exports.useConversationBeldexAddress = useConversationBeldexAddress;
function useConversationWalletDaemonHeight(convoId) {
    const convoProps = useConversationPropsById(convoId);
    return convoProps?.walletCreatedDaemonHeight;
}
exports.useConversationWalletDaemonHeight = useConversationWalletDaemonHeight;
function useMessageReactsPropsById(messageId) {
    return (0, react_redux_1.useSelector)((state) => {
        if (!messageId) {
            return null;
        }
        const messageReactsProps = (0, conversations_1.getMessageReactsProps)(state, messageId);
        if (!messageReactsProps) {
            return null;
        }
        return messageReactsProps;
    });
}
exports.useMessageReactsPropsById = useMessageReactsPropsById;
