"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSet = void 0;
const react_1 = require("react");
const lodash_1 = __importDefault(require("lodash"));
function useSet(initialValues = []) {
    const [uniqueValues, setUniqueValues] = (0, react_1.useState)(initialValues);
    const addTo = (0, react_1.useCallback)((valueToAdd) => {
        if (uniqueValues.includes(valueToAdd)) {
            return;
        }
        setUniqueValues([...uniqueValues, valueToAdd]);
    }, [uniqueValues, setUniqueValues]);
    const removeFrom = (0, react_1.useCallback)((valueToRemove) => {
        if (!uniqueValues.includes(valueToRemove)) {
            return;
        }
        setUniqueValues(uniqueValues.filter(v => !lodash_1.default.isEqual(v, valueToRemove)));
    }, [uniqueValues, setUniqueValues]);
    const empty = (0, react_1.useCallback)(() => {
        if (uniqueValues.length) {
            setUniqueValues([]);
            return;
        }
    }, [uniqueValues, setUniqueValues]);
    return { uniqueValues, addTo, removeFrom, empty };
}
exports.useSet = useSet;
