"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useVideoCallEventsListener = void 0;
const react_1 = require("react");
const react_redux_1 = require("react-redux");
const useMountedState_1 = __importDefault(require("react-use/lib/useMountedState"));
const CallManager_1 = require("../bchat/utils/calling/CallManager");
const conversations_1 = require("../state/selectors/conversations");
const call_1 = require("../state/selectors/call");
function useVideoCallEventsListener(uniqueId, onSame) {
    const selectedConversationKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const ongoingCallPubkey = (0, react_redux_1.useSelector)(call_1.getHasOngoingCallWithPubkey);
    const isFullScreen = (0, react_redux_1.useSelector)(call_1.getCallIsInFullScreen);
    const [localStream, setLocalStream] = (0, react_1.useState)(null);
    const [remoteStream, setRemoteStream] = (0, react_1.useState)(null);
    const [localStreamVideoIsMuted, setLocalStreamVideoIsMuted] = (0, react_1.useState)(true);
    const [ourAudioIsMuted, setOurAudioIsMuted] = (0, react_1.useState)(false);
    const [currentSelectedAudioOutput, setCurrentSelectedAudioOutput] = (0, react_1.useState)(CallManager_1.DEVICE_DISABLED_DEVICE_ID);
    const [remoteStreamVideoIsMuted, setRemoteStreamVideoIsMuted] = (0, react_1.useState)(true);
    const mountedState = (0, useMountedState_1.default)();
    const [currentConnectedCameras, setCurrentConnectedCameras] = (0, react_1.useState)([]);
    const [currentConnectedAudioInputs, setCurrentConnectedAudioInputs] = (0, react_1.useState)([]);
    const [currentConnectedAudioOutputs, setCurrentConnectedAudioOutputs] = (0, react_1.useState)([]);
    (0, react_1.useEffect)(() => {
        if ((onSame && ongoingCallPubkey === selectedConversationKey) ||
            (!onSame && ongoingCallPubkey !== selectedConversationKey) ||
            (!onSame && ongoingCallPubkey === selectedConversationKey)) {
            (0, CallManager_1.addVideoEventsListener)(uniqueId, (options) => {
                const { audioInputsList, audioOutputsList, camerasList, isLocalVideoStreamMuted, isRemoteVideoStreamMuted, localStream: lLocalStream, remoteStream: lRemoteStream, isAudioMuted, currentSelectedAudioOutput: outputSelected, } = options;
                if (mountedState()) {
                    setLocalStream(lLocalStream);
                    setRemoteStream(lRemoteStream);
                    setRemoteStreamVideoIsMuted(isRemoteVideoStreamMuted);
                    setLocalStreamVideoIsMuted(isLocalVideoStreamMuted);
                    setOurAudioIsMuted(isAudioMuted);
                    setCurrentSelectedAudioOutput(outputSelected);
                    setCurrentConnectedCameras(camerasList);
                    setCurrentConnectedAudioInputs(audioInputsList);
                    setCurrentConnectedAudioOutputs(audioOutputsList);
                }
            });
        }
        return () => {
            (0, CallManager_1.removeVideoEventsListener)(uniqueId);
        };
    }, [ongoingCallPubkey, selectedConversationKey, isFullScreen]);
    return {
        currentConnectedAudioInputs,
        currentConnectedAudioOutputs,
        currentSelectedAudioOutput,
        currentConnectedCameras,
        localStreamVideoIsMuted,
        remoteStreamVideoIsMuted,
        localStream,
        remoteStream,
        isAudioMuted: ourAudioIsMuted,
        isAudioOutputMuted: currentSelectedAudioOutput === CallManager_1.DEVICE_DISABLED_DEVICE_ID,
    };
}
exports.useVideoCallEventsListener = useVideoCallEventsListener;
