"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const path_1 = __importStar(require("path"));
const url_1 = __importDefault(require("url"));
const os_1 = __importDefault(require("os"));
const fs_1 = __importDefault(require("fs"));
const crypto_1 = __importDefault(require("crypto"));
const lodash_1 = __importDefault(require("lodash"));
const pify_1 = __importDefault(require("pify"));
const spell_check_1 = require("../node/spell_check");
const global_errors_1 = require("../node/global_errors");
const package_json_1 = __importDefault(require("../../package.json"));
(0, global_errors_1.setupGlobalErrorHandler)();
const electron_localshortcut_1 = __importDefault(require("electron-localshortcut"));
const getRealPath = (0, pify_1.default)(fs_1.default.realpath);
const appUserModelId = 'com.beldex-project.messenger-desktop';
console.log('Set Windows Application User Model ID (AUMID)', {
    appUserModelId,
});
electron_1.app.setAppUserModelId(appUserModelId);
let mainWindow = null;
function getMainWindow() {
    return mainWindow;
}
let readyForShutdown = false;
let tray = null;
const config_1 = require("../node/config");
const user_config_1 = require("../node/config/user_config");
const PasswordUtil = __importStar(require("../util/passwordUtils"));
const development = config_1.config.environment === 'development';
const appInstance = config_1.config.util.getEnv('NODE_APP_INSTANCE') || 0;
const attachment_channel_1 = require("../node/attachment_channel");
const updater = __importStar(require("../updater/index"));
const tray_icon_1 = require("../node/tray_icon");
const ephemeral_config_1 = require("../node/config/ephemeral_config");
const logging_1 = require("../node/logging");
const sql_1 = require("../node/sql");
const sqlChannels = __importStar(require("../node/sql_channel"));
const window_state_1 = require("../node/window_state");
const menu_1 = require("../node/menu");
const protocol_filter_1 = require("../node/protocol_filter");
const permissions_1 = require("../node/permissions");
let appStartInitialSpellcheckSetting = true;
const enableTestIntegrationWiderWindow = true;
const isTestIntegration = enableTestIntegrationWiderWindow &&
    Boolean(process.env.NODE_APP_INSTANCE && process.env.NODE_APP_INSTANCE.includes('test-integration'));
async function getSpellCheckSetting() {
    const json = sql_1.sqlNode.getItemById('spell-check');
    if (!json) {
        return true;
    }
    return json.value;
}
function showWindow() {
    if (!mainWindow) {
        return;
    }
    if (mainWindow.isVisible()) {
        mainWindow.focus();
    }
    else {
        mainWindow.show();
    }
    if (tray) {
        tray.updateContextMenu();
    }
}
if (!process.mas) {
    console.log('making app single instance');
    const gotLock = electron_1.app.requestSingleInstanceLock();
    if (!gotLock) {
        if (appInstance === 0) {
            console.log('quitting; we are the second instance');
            electron_1.app.exit();
        }
    }
    else {
        electron_1.app.on('second-instance', () => {
            if (mainWindow) {
                if (mainWindow.isMinimized()) {
                    mainWindow.restore();
                }
                showWindow();
            }
            return true;
        });
    }
}
const windowFromUserConfig = user_config_1.userConfig.get('window');
const windowFromEphemeral = ephemeral_config_1.ephemeralConfig.get('window');
let windowConfig = windowFromEphemeral || windowFromUserConfig;
if (windowFromUserConfig) {
    user_config_1.userConfig.set('window', null);
    ephemeral_config_1.ephemeralConfig.set('window', windowConfig);
}
const locale_1 = require("../node/locale");
const latest_desktop_release_1 = require("../node/latest_desktop_release");
const getRootPath_1 = require("../node/getRootPath");
const errors_1 = require("../bchat/utils/errors");
const cross_port_killer_1 = require("cross-port-killer");
let logger = null;
let locale;
function assertLogger() {
    if (!logger) {
        throw new Error('assertLogger: logger is not set');
    }
    return logger;
}
function prepareURL(pathSegments, moreKeys) {
    const urlObject = {
        pathname: (0, path_1.join)(...pathSegments),
        protocol: 'file:',
        slashes: true,
        query: {
            name: package_json_1.default.productName,
            locale: locale.name,
            version: electron_1.app.getVersion(),
            commitHash: config_1.config.get('commitHash'),
            environment: config_1.config.environment,
            node_version: process.versions.node,
            hostname: os_1.default.hostname(),
            appInstance: process.env.NODE_APP_INSTANCE,
            proxyUrl: process.env.HTTPS_PROXY || process.env.https_proxy,
            appStartInitialSpellcheckSetting,
            ...moreKeys,
        },
    };
    return url_1.default.format(urlObject);
}
function handleUrl(event, target) {
    event.preventDefault();
    const { protocol } = url_1.default.parse(target);
    if (protocol === 'http:' || protocol === 'https:') {
        void electron_1.shell.openExternal(target);
    }
}
function captureClicks(window) {
    window.webContents.on('will-navigate', handleUrl);
    window.webContents.on('new-window', handleUrl);
}
function getDefaultWindowSize() {
    return {
        defaultWidth: isTestIntegration ? 1500 : 880,
        defaultHeight: 820,
        minWidth: 1200,
        minHeight: 600,
    };
}
function getWindowSize() {
    const screenSize = electron_1.screen.getPrimaryDisplay().workAreaSize;
    const { minWidth, minHeight, defaultWidth, defaultHeight } = getDefaultWindowSize();
    const width = Math.min(defaultWidth, Math.max(minWidth, screenSize.width));
    const height = Math.min(defaultHeight, Math.max(minHeight, screenSize.height));
    return { width, height, minWidth, minHeight };
}
function isVisible(window, bounds) {
    const boundsX = lodash_1.default.get(bounds, 'x') || 0;
    const boundsY = lodash_1.default.get(bounds, 'y') || 0;
    const boundsWidth = lodash_1.default.get(bounds, 'width') || getDefaultWindowSize().defaultWidth;
    const boundsHeight = lodash_1.default.get(bounds, 'height') || getDefaultWindowSize().defaultHeight;
    const BOUNDS_BUFFER = 100;
    const rightSideClearOfLeftBound = window.x + window.width >= boundsX + BOUNDS_BUFFER;
    const leftSideClearOfRightBound = window.x <= boundsX + boundsWidth - BOUNDS_BUFFER;
    const topClearOfUpperBound = window.y >= boundsY;
    const topClearOfLowerBound = window.y <= boundsY + boundsHeight - BOUNDS_BUFFER;
    return (rightSideClearOfLeftBound &&
        leftSideClearOfRightBound &&
        topClearOfUpperBound &&
        topClearOfLowerBound);
}
function getStartInTray() {
    const startInTray = process.argv.some(arg => arg === '--start-in-tray') || user_config_1.userConfig.get('startInTray');
    const usingTrayIcon = startInTray || process.argv.some(arg => arg === '--use-tray-icon');
    return { usingTrayIcon, startInTray };
}
async function createWindow() {
    const { minWidth, minHeight, width, height } = getWindowSize();
    windowConfig = windowConfig || {};
    const picked = {
        maximized: windowConfig.maximized || false,
        autoHideMenuBar: windowConfig.autoHideMenuBar || false,
        width: windowConfig.width || width,
        height: windowConfig.height || height,
        x: windowConfig.x,
        y: windowConfig.y,
    };
    if (isTestIntegration) {
        const screenWidth = electron_1.screen.getPrimaryDisplay().workAreaSize.width - getDefaultWindowSize().defaultWidth;
        const screenHeight = electron_1.screen.getPrimaryDisplay().workAreaSize.height - getDefaultWindowSize().defaultHeight;
        picked.x = Math.floor(Math.random() * screenWidth);
        picked.y = Math.floor(Math.random() * screenHeight);
    }
    const windowOptions = {
        show: true,
        minWidth,
        minHeight,
        fullscreen: false,
        backgroundColor: '#000',
        webPreferences: {
            nodeIntegration: true,
            enableRemoteModule: true,
            nodeIntegrationInWorker: true,
            contextIsolation: false,
            preload: path_1.default.join((0, getRootPath_1.getAppRootPath)(), 'preload.js'),
            nativeWindowOpen: true,
            spellcheck: await getSpellCheckSetting(),
        },
        ...picked,
    };
    if (!lodash_1.default.isNumber(windowOptions.width) || windowOptions.width < minWidth) {
        windowOptions.width = Math.max(minWidth, width);
    }
    if (!lodash_1.default.isNumber(windowOptions.height) || windowOptions.height < minHeight) {
        windowOptions.height = Math.max(minHeight, height);
    }
    if (lodash_1.default.isBoolean(windowOptions.maximized)) {
        delete windowOptions.maximized;
    }
    if (!lodash_1.default.isBoolean(windowOptions.autoHideMenuBar)) {
        delete windowOptions.autoHideMenuBar;
    }
    const visibleOnAnyScreen = lodash_1.default.some(electron_1.screen.getAllDisplays(), display => {
        if (!lodash_1.default.isNumber(windowOptions.x) || !lodash_1.default.isNumber(windowOptions.y)) {
            return false;
        }
        return isVisible(windowOptions, lodash_1.default.get(display, 'bounds'));
    });
    if (!visibleOnAnyScreen) {
        console.log('Location reset needed');
        delete windowOptions.x;
        delete windowOptions.y;
    }
    if (windowOptions.fullscreen === false) {
        delete windowOptions.fullscreen;
    }
    assertLogger().info('Initializing BrowserWindow config: %s', JSON.stringify(windowOptions));
    mainWindow = new electron_1.BrowserWindow(windowOptions);
    (0, spell_check_1.setup)(mainWindow, locale.messages);
    const setWindowFocus = () => {
        if (!mainWindow) {
            return;
        }
        mainWindow.webContents.send('set-window-focus', mainWindow.isFocused());
    };
    mainWindow.on('focus', setWindowFocus);
    mainWindow.on('blur', setWindowFocus);
    mainWindow.once('ready-to-show', setWindowFocus);
    global.setInterval(setWindowFocus, 5000);
    electron_localshortcut_1.default.register(mainWindow, 'F5', () => {
        if (!mainWindow) {
            return;
        }
        mainWindow.reload();
    });
    electron_localshortcut_1.default.register(mainWindow, 'CommandOrControl+R', () => {
        if (!mainWindow) {
            return;
        }
        mainWindow.reload();
    });
    function captureAndSaveWindowStats() {
        if (!mainWindow) {
            return;
        }
        const size = mainWindow.getSize();
        const position = mainWindow.getPosition();
        windowConfig = {
            maximized: mainWindow.isMaximized(),
            autoHideMenuBar: mainWindow.isMenuBarAutoHide(),
            width: size[0],
            height: size[1],
            x: position[0],
            y: position[1],
            fullscreen: false,
        };
        if (mainWindow.isFullScreen()) {
            windowConfig.fullscreen = true;
        }
        assertLogger().info('Updating BrowserWindow config: %s', JSON.stringify(windowConfig));
        ephemeral_config_1.ephemeralConfig.set('window', windowConfig);
    }
    const debouncedCaptureStats = lodash_1.default.debounce(captureAndSaveWindowStats, 500);
    mainWindow.on('resize', debouncedCaptureStats);
    mainWindow.on('move', debouncedCaptureStats);
    mainWindow.on('focus', () => {
        if (!mainWindow) {
            return;
        }
        mainWindow.flashFrame(false);
        if (passwordWindow) {
            passwordWindow.close();
            passwordWindow = null;
        }
    });
    mainWindow.maximize();
    const urlToLoad = prepareURL([(0, getRootPath_1.getAppRootPath)(), 'background.html']);
    await mainWindow.loadURL(urlToLoad);
    if (isTestIntegration) {
        setTimeout(() => {
            if (mainWindow && mainWindow.webContents) {
                mainWindow.webContents.openDevTools({
                    mode: 'right',
                    activate: false,
                });
            }
        }, 5000);
    }
    if ((process.env.NODE_APP_INSTANCE || '').startsWith('devprod')) {
        mainWindow.webContents.openDevTools({
            mode: 'bottom',
            activate: false,
        });
    }
    captureClicks(mainWindow);
    mainWindow.on('close', async (e) => {
        (0, cross_port_killer_1.kill)(64371)
            .then()
            .catch(err => {
            throw new errors_1.HTTPError('beldex_rpc_port', err);
        });
        console.log('close event', {
            readyForShutdown: mainWindow ? readyForShutdown : null,
            shouldQuit: (0, window_state_1.windowShouldQuit)(),
        });
        if (mainWindow && readyForShutdown && (0, window_state_1.windowShouldQuit)()) {
            return;
        }
        e.preventDefault();
        mainWindow?.hide();
        if (!(0, window_state_1.windowShouldQuit)() && (getStartInTray().usingTrayIcon || process.platform === 'darwin')) {
            if (tray) {
                tray.updateContextMenu();
            }
            return;
        }
        await requestShutdown();
        if (mainWindow) {
            readyForShutdown = true;
        }
        electron_1.app.quit();
    });
    mainWindow.on('closed', () => {
        mainWindow = null;
    });
}
electron_1.ipcMain.on('show-window', () => {
    showWindow();
});
electron_1.ipcMain.on('set-release-from-file-server', (_event, releaseGotFromFileServer) => {
    (0, latest_desktop_release_1.setLastestRelease)(releaseGotFromFileServer);
});
let isReadyForUpdates = false;
async function readyForUpdates() {
    console.log('[updater] isReadyForUpdates', isReadyForUpdates);
    if (isReadyForUpdates) {
        return;
    }
    isReadyForUpdates = true;
    try {
        await updater.start(getMainWindow, user_config_1.userConfig, locale.messages, logger);
    }
    catch (error) {
        const log = logger || console;
        log.error('Error starting update checks:', error && error.stack ? error.stack : error);
    }
}
electron_1.ipcMain.once('ready-for-updates', readyForUpdates);
const TEN_MINUTES = 10 * 60 * 10;
setTimeout(readyForUpdates, TEN_MINUTES);
function openReleaseNotes() {
    void electron_1.shell.openExternal(`https://github.com/Beldex-Coin/bchat-desktop/releases/tag/v${electron_1.app.getVersion()}`);
}
function openSupportPage() {
    void electron_1.shell.openExternal('https://beldex.io/blog/what-is-bchat/');
}
let passwordWindow = null;
async function showPasswordWindow() {
    if (passwordWindow) {
        passwordWindow.show();
        return;
    }
    const { minWidth, minHeight, width, height } = getWindowSize();
    const windowOptions = {
        show: true,
        width,
        height,
        minWidth,
        minHeight,
        autoHideMenuBar: false,
        webPreferences: {
            nodeIntegration: true,
            enableRemoteModule: true,
            nodeIntegrationInWorker: false,
            contextIsolation: false,
            preload: path_1.default.join((0, getRootPath_1.getAppRootPath)(), 'password_preload.js'),
            nativeWindowOpen: true,
        },
    };
    passwordWindow = new electron_1.BrowserWindow(windowOptions);
    await passwordWindow.loadURL(prepareURL([(0, getRootPath_1.getAppRootPath)(), 'password.html']));
    captureClicks(passwordWindow);
    passwordWindow.on('close', e => {
        if ((0, window_state_1.windowShouldQuit)()) {
            return;
        }
        e.preventDefault();
        passwordWindow?.hide();
        if (!(0, window_state_1.windowShouldQuit)() && (getStartInTray().usingTrayIcon || process.platform === 'darwin')) {
            if (tray) {
                tray.updateContextMenu();
            }
            return;
        }
        if (passwordWindow) {
            passwordWindow.readyForShutdown = true;
        }
        if (!mainWindow) {
            electron_1.app.quit();
        }
    });
    passwordWindow.on('closed', () => {
        passwordWindow = null;
    });
}
let aboutWindow;
async function showAbout() {
    if (aboutWindow) {
        aboutWindow.show();
        return;
    }
    if (!mainWindow) {
        console.info('about window needs mainwindow as parent');
        return;
    }
    const options = {
        width: 500,
        height: 500,
        resizable: true,
        title: locale.messages.about,
        autoHideMenuBar: true,
        backgroundColor: '#000',
        show: false,
        webPreferences: {
            nodeIntegration: true,
            nodeIntegrationInWorker: false,
            contextIsolation: false,
            preload: path_1.default.join((0, getRootPath_1.getAppRootPath)(), 'about_preload.js'),
            nativeWindowOpen: true,
        },
        parent: mainWindow,
    };
    aboutWindow = new electron_1.BrowserWindow(options);
    captureClicks(aboutWindow);
    await aboutWindow.loadURL(prepareURL([(0, getRootPath_1.getAppRootPath)(), 'about.html']));
    aboutWindow.on('closed', () => {
        aboutWindow = null;
    });
    aboutWindow.once('ready-to-show', () => {
        aboutWindow?.show();
    });
}
let debugLogWindow = null;
async function showDebugLogWindow() {
    if (debugLogWindow) {
        debugLogWindow.show();
        return;
    }
    if (!mainWindow) {
        console.info('debug log neeeds mainwindow size to open');
        return;
    }
    const theme = await getThemeFromMainWindow();
    const size = mainWindow.getSize();
    const options = {
        width: Math.max(size[0] - 100, getDefaultWindowSize().minWidth),
        height: Math.max(size[1] - 100, getDefaultWindowSize().minHeight),
        resizable: true,
        title: locale.messages.debugLog,
        autoHideMenuBar: true,
        backgroundColor: '#000',
        show: false,
        modal: true,
        webPreferences: {
            nodeIntegration: true,
            nodeIntegrationInWorker: false,
            contextIsolation: false,
            preload: path_1.default.join((0, getRootPath_1.getAppRootPath)(), 'debug_log_preload.js'),
            nativeWindowOpen: true,
        },
        parent: mainWindow,
    };
    debugLogWindow = new electron_1.BrowserWindow(options);
    captureClicks(debugLogWindow);
    await debugLogWindow.loadURL(prepareURL([(0, getRootPath_1.getAppRootPath)(), 'debug_log.html'], { theme }));
    debugLogWindow.on('closed', () => {
        debugLogWindow = null;
    });
    debugLogWindow.once('ready-to-show', () => {
        debugLogWindow?.show();
    });
}
let ready = false;
electron_1.app.on('ready', async () => {
    const userDataPath = await getRealPath(electron_1.app.getPath('userData'));
    const installPath = await getRealPath((0, path_1.join)(electron_1.app.getAppPath(), '..', '..'));
    (0, protocol_filter_1.installFileHandler)({
        protocol: electron_1.protocol,
        userDataPath,
        installPath,
        isWindows: process.platform === 'win32',
    });
    (0, protocol_filter_1.installWebHandler)({
        protocol: electron_1.protocol,
    });
    (0, permissions_1.installPermissionsHandler)({ userConfig: user_config_1.userConfig });
    await (0, logging_1.initializeLogger)();
    logger = (0, logging_1.getLogger)();
    assertLogger().info('app ready');
    assertLogger().info(`starting version ${package_json_1.default.version}`);
    if (!locale) {
        const appLocale = electron_1.app.getLocale() || 'en';
        locale = (0, locale_1.load)({ appLocale, logger });
    }
    const key = getDefaultSQLKey();
    const dbHasPassword = user_config_1.userConfig.get('dbHasPassword');
    if (dbHasPassword) {
        await showPasswordWindow();
    }
    else {
        await showMainWindow(key);
    }
});
function getDefaultSQLKey() {
    let key = user_config_1.userConfig.get('key');
    if (!key) {
        console.log('key/initialize: Generating new encryption key, since we did not find it on disk');
        key = crypto_1.default.randomBytes(32).toString('hex');
        user_config_1.userConfig.set('key', key);
    }
    return key;
}
async function removeDB() {
    const userDir = await getRealPath(electron_1.app.getPath('userData'));
    sql_1.sqlNode.removeDB(userDir);
    try {
        console.error('Remove DB: removing.', userDir);
        user_config_1.userConfig.remove();
        ephemeral_config_1.ephemeralConfig.remove();
    }
    catch (e) {
        console.error('Remove DB: Failed to remove configs.', e);
    }
}
async function showMainWindow(sqlKey, passwordAttempt = false) {
    const userDataPath = await getRealPath(electron_1.app.getPath('userData'));
    await sql_1.sqlNode.initializeSql({
        configDir: userDataPath,
        key: sqlKey,
        messages: locale.messages,
        passwordAttempt,
    });
    appStartInitialSpellcheckSetting = await getSpellCheckSetting();
    sqlChannels.initializeSqlChannel();
    sql_1.sqlNode.cleanUpOldOpengroups();
    await (0, attachment_channel_1.initAttachmentsChannel)({
        userDataPath,
    });
    ready = true;
    await createWindow();
    if (getStartInTray().usingTrayIcon) {
        tray = (0, tray_icon_1.createTrayIcon)(getMainWindow, locale.messages);
    }
    setupMenu();
}
function setupMenu() {
    const { platform } = process;
    const menuOptions = {
        development,
        showDebugLog: showDebugLogWindow,
        showWindow,
        showAbout,
        openReleaseNotes,
        openSupportPage,
        platform,
    };
    const template = (0, menu_1.createTemplate)(menuOptions, locale.messages);
    const menu = electron_1.Menu.buildFromTemplate(template);
    electron_1.Menu.setApplicationMenu(menu);
}
async function requestShutdown() {
    if (!mainWindow || !mainWindow.webContents) {
        return;
    }
    console.log('requestShutdown: Requesting close of mainWindow...');
    const request = new Promise((resolve, reject) => {
        electron_1.ipcMain.once('now-ready-for-shutdown', (_event, error) => {
            console.log('requestShutdown: Response received');
            if (error) {
                reject(error);
                return;
            }
            resolve(undefined);
            return;
        });
        mainWindow?.webContents.send('get-ready-for-shutdown');
        setTimeout(() => {
            console.log('requestShutdown: Response never received; forcing shutdown.');
            resolve(undefined);
        }, 2 * 60 * 1000);
    });
    try {
        await request;
    }
    catch (error) {
        console.log('requestShutdown error:', error && error.stack ? error.stack : error);
    }
}
electron_1.app.on('before-quit', async () => {
    (0, cross_port_killer_1.kill)(64371)
        .then()
        .catch((err) => {
        throw new errors_1.HTTPError('beldex_rpc_port', err);
    });
    console.log('before-quit event', {
        readyForShutdown: mainWindow ? readyForShutdown : null,
        shouldQuit: (0, window_state_1.windowShouldQuit)(),
    });
    if (tray) {
        tray.destroy();
    }
    (0, window_state_1.windowMarkShouldQuit)();
});
electron_1.app.on('window-all-closed', () => {
    if (process.platform !== 'darwin') {
        electron_1.app.quit();
    }
});
electron_1.app.on('activate', async () => {
    if (!ready) {
        return;
    }
    if (mainWindow) {
        mainWindow.show();
    }
    else {
        await createWindow();
    }
});
electron_1.app.on('web-contents-created', (_createEvent, contents) => {
    contents.on('will-attach-webview', attachEvent => {
        attachEvent.preventDefault();
    });
    contents.on('new-window', newEvent => {
        newEvent.preventDefault();
    });
});
electron_1.ipcMain.on('locale-data', event => {
    event.returnValue = locale.messages;
});
electron_1.ipcMain.on('draw-attention', () => {
    if (!mainWindow) {
        return;
    }
    if (process.platform === 'win32') {
        mainWindow.flashFrame(true);
    }
});
electron_1.ipcMain.on('restart', () => {
    electron_1.app.relaunch();
    electron_1.app.quit();
});
electron_1.ipcMain.on('resetDatabase', async () => {
    await removeDB();
    electron_1.app.relaunch();
    electron_1.app.quit();
});
electron_1.ipcMain.on('set-auto-hide-menu-bar', (_event, autoHide) => {
    if (mainWindow) {
        mainWindow.setAutoHideMenuBar(autoHide);
    }
});
electron_1.ipcMain.on('set-menu-bar-visibility', (_event, visibility) => {
    if (mainWindow) {
        mainWindow.setMenuBarVisibility(visibility);
    }
});
electron_1.ipcMain.on('close-about', () => {
    if (aboutWindow) {
        aboutWindow.close();
    }
});
electron_1.ipcMain.on('password-window-login', async (event, passPhrase) => {
    const sendResponse = (e) => {
        event.sender.send('password-window-login-response', e);
    };
    try {
        const passwordAttempt = true;
        await showMainWindow(passPhrase, passwordAttempt);
        sendResponse(undefined);
    }
    catch (e) {
        const localisedError = locale.messages.invalidPassword;
        sendResponse(localisedError || 'Invalid password');
    }
});
electron_1.ipcMain.on('start-in-tray-on-start', (event, newValue) => {
    try {
        user_config_1.userConfig.set('startInTray', newValue);
        if (newValue) {
            if (!tray) {
                tray = (0, tray_icon_1.createTrayIcon)(getMainWindow, locale.messages);
            }
        }
        else {
        }
        event.sender.send('start-in-tray-on-start-response', null);
    }
    catch (e) {
        event.sender.send('start-in-tray-on-start-response', e);
    }
});
electron_1.ipcMain.on('get-start-in-tray', event => {
    try {
        const val = user_config_1.userConfig.get('startInTray');
        event.sender.send('get-start-in-tray-response', val);
    }
    catch (e) {
        event.sender.send('get-start-in-tray-response', false);
    }
});
electron_1.ipcMain.on('get-opengroup-pruning', event => {
    try {
        const val = user_config_1.userConfig.get('opengroupPruning');
        event.sender.send('get-opengroup-pruning-response', val);
    }
    catch (e) {
        event.sender.send('get-opengroup-pruning-response', false);
    }
});
electron_1.ipcMain.on('set-opengroup-pruning', (event, newValue) => {
    try {
        user_config_1.userConfig.set('opengroupPruning', newValue);
        event.sender.send('set-opengroup-pruning-response', null);
    }
    catch (e) {
        event.sender.send('set-opengroup-pruning-response', e);
    }
});
electron_1.ipcMain.on('set-password', async (event, passPhrase, oldPhrase) => {
    const sendResponse = (response) => {
        event.sender.send('set-password-response', response);
    };
    try {
        const hash = sql_1.sqlNode.getPasswordHash();
        const hashMatches = oldPhrase && PasswordUtil.matchesHash(oldPhrase, hash);
        if (hash && !hashMatches) {
            const incorrectOldPassword = locale.messages.invalidOldPassword;
            sendResponse(incorrectOldPassword || 'Failed to set password: Old password provided is invalid');
            return;
        }
        if (lodash_1.default.isEmpty(passPhrase)) {
            const defaultKey = getDefaultSQLKey();
            sql_1.sqlNode.setSQLPassword(defaultKey);
            sql_1.sqlNode.removePasswordHash();
            user_config_1.userConfig.set('dbHasPassword', false);
        }
        else {
            sql_1.sqlNode.setSQLPassword(passPhrase);
            const newHash = PasswordUtil.generateHash(passPhrase);
            sql_1.sqlNode.savePasswordHash(newHash);
            user_config_1.userConfig.set('dbHasPassword', true);
        }
        sendResponse(undefined);
    }
    catch (e) {
        const localisedError = locale.messages.setPasswordFail;
        sendResponse(localisedError || 'Failed to set password');
    }
});
electron_1.ipcMain.on('show-debug-log', showDebugLogWindow);
electron_1.ipcMain.on('close-debug-log', () => {
    if (debugLogWindow) {
        debugLogWindow.close();
    }
});
electron_1.ipcMain.on('save-debug-log', (_event, logText) => {
    const osSpecificDesktopFolder = electron_1.app.getPath('desktop');
    console.info(`Trying to save logs to log Desktop ${osSpecificDesktopFolder}`);
    const outputPath = path_1.default.join(osSpecificDesktopFolder, `bchat_debug_${Date.now()}.log`);
    fs_1.default.writeFile(outputPath, logText, err => {
        if (err) {
            console.error(`Error saving debug log to ${outputPath}`);
            return;
        }
        console.info(`Saved log - ${outputPath}`);
    });
});
electron_1.ipcMain.on('get-media-permissions', event => {
    event.returnValue = user_config_1.userConfig.get('mediaPermissions') || false;
});
electron_1.ipcMain.on('set-media-permissions', (event, value) => {
    user_config_1.userConfig.set('mediaPermissions', value);
    (0, permissions_1.installPermissionsHandler)({ userConfig: user_config_1.userConfig });
    event.sender.send('set-success-media-permissions', null);
});
electron_1.ipcMain.on('get-call-media-permissions', event => {
    event.returnValue = user_config_1.userConfig.get('callMediaPermissions') || false;
});
electron_1.ipcMain.on('set-call-media-permissions', (event, value) => {
    user_config_1.userConfig.set('callMediaPermissions', value);
    (0, permissions_1.installPermissionsHandler)({ userConfig: user_config_1.userConfig });
    event.sender.send('set-success-call-media-permissions', null);
});
electron_1.ipcMain.on('get-auto-update-setting', event => {
    const configValue = user_config_1.userConfig.get('autoUpdate');
    event.returnValue = typeof configValue !== 'boolean' ? true : configValue;
});
electron_1.ipcMain.on('set-auto-update-setting', async (_event, enabled) => {
    user_config_1.userConfig.set('autoUpdate', !!enabled);
    if (enabled) {
        await readyForUpdates();
    }
    else {
        updater.stop();
        isReadyForUpdates = false;
    }
});
async function getThemeFromMainWindow() {
    return new Promise(resolve => {
        electron_1.ipcMain.once('get-success-theme-setting', (_event, value) => {
            resolve(value);
        });
        mainWindow?.webContents.send('get-theme-setting');
    });
}
async function askForMediaAccess() {
    let status = electron_1.systemPreferences.getMediaAccessStatus('microphone');
    if (status !== 'granted') {
        await electron_1.systemPreferences.askForMediaAccess('microphone');
    }
    status = electron_1.systemPreferences.getMediaAccessStatus('camera');
    if (status !== 'granted') {
        await electron_1.systemPreferences.askForMediaAccess('camera');
    }
}
electron_1.ipcMain.on('media-access', async () => {
    await askForMediaAccess();
});
